/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.api.DegreeVisitor;
import org.neo4j.kernel.impl.core.DenseNodeChainPosition;
import org.neo4j.kernel.impl.core.RelationshipLoadingPosition;
import org.neo4j.kernel.impl.core.SingleChainPosition;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.RelIdArray;

public class RelationshipChainLoader {
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final RelationshipGroupStore relationshipGroupStore;
    private final int relationshipGrabSize;

    public RelationshipChainLoader(NeoStore neoStore) {
        this.nodeStore = neoStore.getNodeStore();
        this.relationshipStore = neoStore.getRelationshipStore();
        this.relationshipGroupStore = neoStore.getRelationshipGroupStore();
        this.relationshipGrabSize = neoStore.getRelationshipGrabSize();
    }

    public static int relCount(long nodeId, RelationshipRecord rel) {
        return (int)(nodeId == rel.getFirstNode() ? rel.getFirstPrevRel() : rel.getSecondPrevRel());
    }

    public Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, RelationshipLoadingPosition> getMoreRelationships(long nodeId, RelationshipLoadingPosition originalPosition, RelIdArray.DirectionWrapper direction, int[] types) {
        ArrayList<RelationshipRecord> out = new ArrayList<RelationshipRecord>();
        ArrayList<RelationshipRecord> in = new ArrayList<RelationshipRecord>();
        ArrayList<RelationshipRecord> loop = null;
        EnumMap result = new EnumMap(RelIdArray.DirectionWrapper.class);
        result.put(RelIdArray.DirectionWrapper.OUTGOING, out);
        result.put(RelIdArray.DirectionWrapper.INCOMING, in);
        RelationshipLoadingPosition loadPosition = originalPosition.clone();
        long position = loadPosition.position(direction, types);
        RelationshipRecord relRecord = null;
        boolean allocateNewRecord = true;
        for (int i = 0; i < this.relationshipGrabSize && position != (long)Record.NO_NEXT_RELATIONSHIP.intValue(); ++i) {
            if (allocateNewRecord) {
                relRecord = new RelationshipRecord(-1L);
                allocateNewRecord = false;
            }
            if (!this.relationshipStore.fillChainRecord(position, relRecord)) {
                return Pair.of(result, loadPosition);
            }
            long firstNode = relRecord.getFirstNode();
            long secondNode = relRecord.getSecondNode();
            if (relRecord.inUse()) {
                if (firstNode == secondNode) {
                    if (loop == null) {
                        loop = new ArrayList<RelationshipRecord>();
                        result.put(RelIdArray.DirectionWrapper.BOTH, loop);
                    }
                    loop.add(relRecord);
                    allocateNewRecord = true;
                } else if (firstNode == nodeId) {
                    out.add(relRecord);
                    allocateNewRecord = true;
                } else if (secondNode == nodeId) {
                    in.add(relRecord);
                    allocateNewRecord = true;
                }
            } else {
                --i;
            }
            long next = 0L;
            if (firstNode == nodeId) {
                next = relRecord.getFirstNextRel();
            } else if (secondNode == nodeId) {
                next = relRecord.getSecondNextRel();
            } else {
                throw new InvalidRecordException("While loading relationships for Node[" + nodeId + "] a Relationship[" + relRecord.getId() + "] was encountered that had startNode: " + firstNode + " and endNode: " + secondNode + ", i.e. which had neither start nor end node as the node we're " + "loading relationships for");
            }
            position = loadPosition.nextPosition(next, direction, types);
        }
        return Pair.of(result, loadPosition);
    }

    public int getRelationshipCount(long id, int type, RelIdArray.DirectionWrapper direction) {
        NodeRecord node = this.nodeStore.getRecord(id);
        long nextRel = node.getNextRel();
        if (nextRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            return 0;
        }
        if (!node.isDense()) {
            assert (type == -1);
            assert (direction == RelIdArray.DirectionWrapper.BOTH);
            return this.getRelationshipCount(node, nextRel);
        }
        Map<Integer, RelationshipGroupRecord> groups = this.loadRelationshipGroups(node);
        if (type == -1 && direction == RelIdArray.DirectionWrapper.BOTH) {
            int count = 0;
            for (RelationshipGroupRecord group : groups.values()) {
                count += this.getRelationshipCount(node, group.getFirstOut());
                count += this.getRelationshipCount(node, group.getFirstIn());
                count += this.getRelationshipCount(node, group.getFirstLoop());
            }
            return count;
        }
        if (type == -1) {
            int count = 0;
            for (RelationshipGroupRecord group : groups.values()) {
                count += this.getRelationshipCount(node, group, direction);
            }
            return count;
        }
        if (direction == RelIdArray.DirectionWrapper.BOTH) {
            RelationshipGroupRecord group = groups.get(type);
            if (group == null) {
                return 0;
            }
            int count = 0;
            count += this.getRelationshipCount(node, group.getFirstOut());
            count += this.getRelationshipCount(node, group.getFirstIn());
            return count += this.getRelationshipCount(node, group.getFirstLoop());
        }
        RelationshipGroupRecord group = groups.get(type);
        if (group == null) {
            return 0;
        }
        return this.getRelationshipCount(node, group, direction);
    }

    public void visitRelationshipCounts(long nodeId, DegreeVisitor visitor) {
        NodeRecord node = this.nodeStore.getRecord(nodeId);
        long nextRecord = node.getNextRel();
        if (Record.NO_NEXT_RELATIONSHIP.is(nextRecord)) {
            return;
        }
        if (!node.isDense()) {
            throw new UnsupportedOperationException("non-dense nodes should be handled by the cache layer");
        }
        while (!Record.NO_NEXT_RELATIONSHIP.is(nextRecord)) {
            RelationshipGroupRecord group = this.relationshipGroupStore.getRecord(nextRecord);
            nextRecord = group.getNext();
            int outgoing = this.getRelationshipCount(node, group.getFirstOut());
            int incoming = this.getRelationshipCount(node, group.getFirstIn());
            int loops = this.getRelationshipCount(node, group.getFirstLoop());
            visitor.visitDegree(group.getType(), outgoing + loops, incoming + loops);
        }
    }

    private int getRelationshipCount(NodeRecord node, RelationshipGroupRecord group, RelIdArray.DirectionWrapper direction) {
        if (direction == RelIdArray.DirectionWrapper.BOTH) {
            return this.getRelationshipCount(node, RelIdArray.DirectionWrapper.OUTGOING.getNextRel(group)) + this.getRelationshipCount(node, RelIdArray.DirectionWrapper.INCOMING.getNextRel(group)) + this.getRelationshipCount(node, RelIdArray.DirectionWrapper.BOTH.getNextRel(group));
        }
        return this.getRelationshipCount(node, direction.getNextRel(group)) + this.getRelationshipCount(node, RelIdArray.DirectionWrapper.BOTH.getNextRel(group));
    }

    private int getRelationshipCount(NodeRecord node, long relId) {
        if (relId == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            return 0;
        }
        RelationshipRecord rel = this.relationshipStore.getRecord(relId);
        return (int)(node.getId() == rel.getFirstNode() ? rel.getFirstPrevRel() : rel.getSecondPrevRel());
    }

    public Integer[] getRelationshipTypes(long id) {
        Map<Integer, RelationshipGroupRecord> groups = this.loadRelationshipGroups(this.nodeStore.getRecord(id));
        Integer[] types = new Integer[groups.size()];
        int i = 0;
        for (Integer type : groups.keySet()) {
            types[i++] = type;
        }
        return types;
    }

    public RelationshipLoadingPosition getRelationshipChainPosition(long id) {
        NodeRecord node;
        try {
            node = this.nodeStore.getRecord(id);
        }
        catch (InvalidRecordException e) {
            return RelationshipLoadingPosition.EMPTY;
        }
        if (node.isDense()) {
            long firstGroup = node.getNextRel();
            if (firstGroup == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                return RelationshipLoadingPosition.EMPTY;
            }
            Map<Integer, RelationshipGroupRecord> groups = this.loadRelationshipGroups(node);
            return new DenseNodeChainPosition(groups);
        }
        long firstRel = node.getNextRel();
        return firstRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? RelationshipLoadingPosition.EMPTY : new SingleChainPosition(firstRel);
    }

    private Map<Integer, RelationshipGroupRecord> loadRelationshipGroups(NodeRecord node) {
        assert (node.isDense());
        long groupId = node.getNextRel();
        long previousGroupId = Record.NO_NEXT_RELATIONSHIP.intValue();
        HashMap<Integer, RelationshipGroupRecord> result = new HashMap<Integer, RelationshipGroupRecord>();
        while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RelationshipGroupRecord record = this.relationshipGroupStore.getRecord(groupId);
            record.setPrev(previousGroupId);
            result.put(record.getType(), record);
            previousGroupId = groupId;
            groupId = record.getNext();
        }
        return result;
    }
}

