/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;

public class RecoveryVisitor
implements Visitor<CommittedTransactionRepresentation, IOException>,
Closeable {
    private final TransactionIdStore store;
    private final TransactionRepresentationStoreApplier storeApplier;
    private final AtomicInteger recoveredCount;
    private final Monitor monitor;
    private long lastTransactionIdApplied = -1L;

    public RecoveryVisitor(TransactionIdStore store, TransactionRepresentationStoreApplier storeApplier, AtomicInteger recoveredCount, Monitor monitor) {
        this.store = store;
        this.storeApplier = storeApplier;
        this.recoveredCount = recoveredCount;
        this.monitor = monitor;
    }

    @Override
    public boolean visit(CommittedTransactionRepresentation transaction) throws IOException {
        long txId = transaction.getCommitEntry().getTxId();
        try (LockGroup locks = new LockGroup();){
            this.storeApplier.apply(transaction.getTransactionRepresentation(), locks, txId, TransactionApplicationMode.RECOVERY);
        }
        this.recoveredCount.incrementAndGet();
        this.lastTransactionIdApplied = txId;
        this.monitor.transactionRecovered(txId);
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.lastTransactionIdApplied != -1L) {
            this.store.setLastCommittedAndClosedTransactionId(this.lastTransactionIdApplied);
        }
    }

    public static interface Monitor {
        public void transactionRecovered(long var1);
    }
}

