/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.neo4j.helpers.Listeners;
import org.neo4j.helpers.Provider;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleStatus;

public class DataSourceManager
implements Lifecycle,
Provider<KernelAPI> {
    private LifeSupport life = new LifeSupport();
    private Iterable<Listener> dsRegistrationListeners = Listeners.newListeners();
    private NeoStoreDataSource dataSource;

    public void addListener(Listener listener) {
        if (this.life.getStatus().equals((Object)LifecycleStatus.STARTED)) {
            try {
                if (this.dataSource != null) {
                    listener.registered(this.dataSource);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.dsRegistrationListeners = Listeners.addListener(listener, this.dsRegistrationListeners);
    }

    public void removeListener(Listener listener) {
        this.dsRegistrationListeners = Listeners.removeListener(listener, this.dsRegistrationListeners);
    }

    public void register(final NeoStoreDataSource dataSource) {
        this.dataSource = dataSource;
        if (this.life.getStatus().equals((Object)LifecycleStatus.STARTED)) {
            Listeners.notifyListeners(this.dsRegistrationListeners, new Listeners.Notification<Listener>(){

                @Override
                public void notify(Listener listener) {
                    listener.registered(dataSource);
                }
            });
        }
    }

    public void unregister(final NeoStoreDataSource dataSource) {
        this.dataSource = null;
        Listeners.notifyListeners(this.dsRegistrationListeners, new Listeners.Notification<Listener>(){

            @Override
            public void notify(Listener listener) {
                listener.unregistered(dataSource);
            }
        });
        this.life.remove(dataSource);
    }

    public NeoStoreDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public void init() throws Throwable {
        this.life = new LifeSupport();
    }

    @Override
    public void start() throws Throwable {
        this.life.add(this.dataSource);
        this.life.start();
        for (Listener listener : this.dsRegistrationListeners) {
            try {
                if (this.dataSource == null) continue;
                listener.registered(this.dataSource);
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void stop() throws Throwable {
        this.life.stop();
    }

    @Override
    public void shutdown() throws Throwable {
        this.life.shutdown();
        this.dataSource = null;
    }

    @Override
    public KernelAPI instance() {
        return this.dataSource.getKernel();
    }

    public static interface Listener {
        public void registered(NeoStoreDataSource var1);

        public void unregistered(NeoStoreDataSource var1);
    }
}

