/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.record.NeoStoreUtil;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;

public class ReadOnlyTransactionIdStore
implements TransactionIdStore {
    private final long transactionId;

    public ReadOnlyTransactionIdStore(FileSystemAbstraction fs, File storeDir) {
        this.transactionId = NeoStoreUtil.neoStoreExists(fs, storeDir) ? new NeoStoreUtil(storeDir, fs).getLastCommittedTx() : 0L;
    }

    @Override
    public long nextCommittingTransactionId() {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public void transactionCommitted(long transactionId) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public long getLastCommittedTransactionId() {
        return this.transactionId;
    }

    @Override
    public long getLastClosedTransactionId() {
        return this.transactionId;
    }

    @Override
    public void setLastCommittedAndClosedTransactionId(long transactionId) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public void transactionClosed(long transactionId) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public boolean closedTransactionIdIsOnParWithCommittedTransactionId() {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public void flush() {
    }
}

