/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogHeaderVisitor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogRecoveryCheck;
import org.neo4j.kernel.impl.transaction.log.LogRotationControl;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalWritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReaderLogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class PhysicalLogFile
extends LifecycleAdapter
implements LogFile {
    public static final String DEFAULT_NAME = "neostore.transaction.db";
    public static final String REGEX_DEFAULT_NAME = "neostore\\.transaction\\.db";
    public static final String DEFAULT_VERSION_SUFFIX = ".";
    public static final String REGEX_DEFAULT_VERSION_SUFFIX = "\\.";
    private final long rotateAtSize;
    private final FileSystemAbstraction fileSystem;
    private final LogPruneStrategy pruneStrategy;
    private final TransactionIdStore transactionIdStore;
    private final PhysicalLogFiles logFiles;
    private final TransactionMetadataCache transactionMetadataCache;
    private final Visitor<ReadableVersionableLogChannel, IOException> recoveredDataVisitor;
    private final Monitor monitor;
    private final ByteBuffer headerBuffer = ByteBuffer.allocate(16);
    private final LogRotationControl logRotationControl;
    private PhysicalWritableLogChannel writer;
    private final LogVersionRepository logVersionRepository;
    private PhysicalLogVersionedStoreChannel channel;
    private final LogVersionBridge readerLogVersionBridge;
    private final Lock pruneLock = new ReentrantLock();

    public PhysicalLogFile(FileSystemAbstraction fileSystem, PhysicalLogFiles logFiles, long rotateAtSize, LogPruneStrategy pruneStrategy, TransactionIdStore transactionIdStore, LogVersionRepository logVersionRepository, Monitor monitor, LogRotationControl logRotationControl, TransactionMetadataCache transactionMetadataCache, Visitor<ReadableVersionableLogChannel, IOException> recoveredDataVisitor) {
        this.fileSystem = fileSystem;
        this.rotateAtSize = rotateAtSize;
        this.pruneStrategy = pruneStrategy;
        this.transactionIdStore = transactionIdStore;
        this.logVersionRepository = logVersionRepository;
        this.monitor = monitor;
        this.logRotationControl = logRotationControl;
        this.transactionMetadataCache = transactionMetadataCache;
        this.recoveredDataVisitor = recoveredDataVisitor;
        this.logFiles = logFiles;
        this.readerLogVersionBridge = new ReaderLogVersionBridge(fileSystem, logFiles);
    }

    @Override
    public void init() throws Throwable {
        long lastLogVersionUsed = this.logVersionRepository.getCurrentLogVersion();
        this.channel = this.openLogChannelForVersion(lastLogVersionUsed);
        this.writer = new PhysicalWritableLogChannel(this.channel);
    }

    @Override
    public void start() throws Throwable {
        this.doRecoveryOn(this.channel, this.recoveredDataVisitor);
    }

    @Override
    public synchronized void stop() throws Throwable {
        this.logRotationControl.awaitAllTransactionsClosed();
        this.logRotationControl.forceEverything();
        this.logVersionRepository.incrementAndGetVersion();
    }

    @Override
    public synchronized void shutdown() throws Throwable {
        this.writer.close();
        this.channel.close();
    }

    private PhysicalLogVersionedStoreChannel openLogChannelForVersion(long forVersion) throws IOException {
        File toOpen = this.logFiles.getLogFileForVersion(forVersion);
        StoreChannel storeChannel = this.fileSystem.open(toOpen, "rw");
        LogHeader header = LogHeaderReader.readLogHeader(this.headerBuffer, (ReadableByteChannel)storeChannel, false);
        if (header == null) {
            long lastTxId = this.transactionIdStore.getLastCommittedTransactionId();
            LogHeaderWriter.writeLogHeader(this.headerBuffer, forVersion, lastTxId);
            this.transactionMetadataCache.putHeader(forVersion, lastTxId);
            storeChannel.writeAll(this.headerBuffer);
            this.monitor.opened(toOpen, forVersion, lastTxId, true);
        }
        byte formatVersion = header == null ? (byte)5 : (byte)header.logFormatVersion;
        return new PhysicalLogVersionedStoreChannel(storeChannel, forVersion, formatVersion);
    }

    private void doRecoveryOn(PhysicalLogVersionedStoreChannel toRecover, Visitor<ReadableVersionableLogChannel, IOException> recoveredDataVisitor) throws IOException {
        if (new LogRecoveryCheck(toRecover).recoveryRequired()) {
            this.monitor.recoveryRequired(toRecover.getVersion());
            ReadAheadLogChannel recoveredDataChannel = new ReadAheadLogChannel(toRecover, LogVersionBridge.NO_MORE_CHANNELS, 4096);
            recoveredDataVisitor.visit(recoveredDataChannel);
            this.logRotationControl.forceEverything();
            this.monitor.recoveryCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkRotation() throws IOException {
        if (this.channel.position() >= this.rotateAtSize) {
            PhysicalLogFile physicalLogFile = this;
            synchronized (physicalLogFile) {
                if (this.channel.position() >= this.rotateAtSize) {
                    this.doRotate();
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prune() {
        if (this.pruneLock.tryLock()) {
            try {
                this.pruneStrategy.prune();
            }
            finally {
                this.pruneLock.unlock();
            }
        }
    }

    public synchronized void forceRotate() throws IOException {
        this.doRotate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRotate() throws IOException {
        PhysicalWritableLogChannel physicalWritableLogChannel = this.writer;
        synchronized (physicalWritableLogChannel) {
            this.logRotationControl.awaitAllTransactionsClosed();
            this.logRotationControl.forceEverything();
            this.channel = this.rotate(this.channel);
            this.writer.setChannel(this.channel);
        }
    }

    private PhysicalLogVersionedStoreChannel rotate(LogVersionedStoreChannel currentLog) throws IOException {
        long newLogVersion = this.logVersionRepository.incrementAndGetVersion();
        PhysicalLogVersionedStoreChannel newLog = this.openLogChannelForVersion(newLogVersion);
        currentLog.close();
        return newLog;
    }

    @Override
    public WritableLogChannel getWriter() {
        return this.writer;
    }

    @Override
    public ReadableVersionableLogChannel getReader(LogPosition position) throws IOException {
        PhysicalLogVersionedStoreChannel logChannel = PhysicalLogFile.openForVersion(this.logFiles, this.fileSystem, position.getLogVersion());
        logChannel.position(position.getByteOffset());
        return new ReadAheadLogChannel(logChannel, this.readerLogVersionBridge, 4096);
    }

    public static PhysicalLogVersionedStoreChannel openForVersion(PhysicalLogFiles logFiles, FileSystemAbstraction fileSystem, long version) throws IOException {
        File fileToOpen = logFiles.getLogFileForVersion(version);
        StoreChannel rawChannel = fileSystem.open(fileToOpen, "r");
        ByteBuffer buffer = ByteBuffer.allocate(16);
        LogHeader header = LogHeaderReader.readLogHeader(buffer, (ReadableByteChannel)rawChannel, true);
        assert (header.logVersion == version);
        return new PhysicalLogVersionedStoreChannel(rawChannel, version, header.logFormatVersion);
    }

    @Override
    public void accept(LogFile.LogFileVisitor visitor, LogPosition startingFromPosition) throws IOException {
        try (ReadableVersionableLogChannel reader = this.getReader(startingFromPosition);){
            visitor.visit(startingFromPosition, reader);
        }
    }

    @Override
    public void accept(LogHeaderVisitor visitor) throws IOException {
        long logVersion = this.logFiles.getHighestLogVersion();
        long highTransactionId = this.transactionIdStore.getLastCommittedTransactionId();
        while (this.logFiles.versionExists(logVersion)) {
            long lowTransactionId;
            LogPosition position;
            long previousLogLastTxId = this.transactionMetadataCache.getLogHeader(logVersion);
            if (previousLogLastTxId == -1L) {
                LogHeader header = LogHeaderReader.readLogHeader(this.fileSystem, this.logFiles.getLogFileForVersion(logVersion));
                assert (logVersion == header.logVersion);
                this.transactionMetadataCache.putHeader(header.logVersion, header.lastCommittedTxId);
                previousLogLastTxId = header.lastCommittedTxId;
            }
            if (!visitor.visit(position = new LogPosition(logVersion, 16L), lowTransactionId = previousLogLastTxId + 1L, highTransactionId)) break;
            --logVersion;
            highTransactionId = previousLogLastTxId;
        }
    }

    @Override
    public File currentLogFile() {
        return this.logFiles.getLogFileForVersion(this.logFiles.getHighestLogVersion());
    }

    public static interface Monitor {
        public void recoveryRequired(long var1);

        public void recoveryCompleted();

        public void opened(File var1, long var2, long var4, boolean var6);

        public void failureToTruncate(File var1, IOException var2);

        public static class Adapter
        implements Monitor {
            @Override
            public void recoveryRequired(long recoveredLogVersion) {
            }

            @Override
            public void recoveryCompleted() {
            }

            @Override
            public void opened(File logFile, long logVersion, long lastTransactionId, boolean clean) {
            }

            @Override
            public void failureToTruncate(File logFile, IOException e) {
            }
        }
    }
}

