/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.regex.Pattern;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.FileOperation;

public class LogFiles {
    public static final FilenameFilter FILENAME_FILTER = new LogicalLogFilenameFilter();

    public static void move(FileSystemAbstraction fs, File fromDirectory, File toDirectory) throws IOException {
        File[] logFiles;
        assert (fs.isDirectory(fromDirectory));
        assert (fs.isDirectory(toDirectory));
        for (File logFile : logFiles = fs.listFiles(fromDirectory, FILENAME_FILTER)) {
            FileOperation.MOVE.perform(fs, logFile.getName(), fromDirectory, toDirectory);
        }
    }

    public static final class LogicalLogFilenameFilter
    implements FilenameFilter {
        private static final Pattern LOG_FILENAME_PATTERN = Pattern.compile("neostore\\.transaction\\.db\\..*");

        @Override
        public boolean accept(File dir, String name) {
            return LOG_FILENAME_PATTERN.matcher(name).matches();
        }
    }
}

