/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.pagecache.StandalonePageCache;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.monitoring.Monitors;

public class StoreFactory {
    public static final String LABELS_PART = ".labels";
    public static final String NAMES_PART = ".names";
    public static final String INDEX_PART = ".index";
    public static final String KEYS_PART = ".keys";
    public static final String ARRAYS_PART = ".arrays";
    public static final String STRINGS_PART = ".strings";
    public static final String NODE_STORE_NAME = ".nodestore.db";
    public static final String NODE_LABELS_STORE_NAME = ".nodestore.db.labels";
    public static final String PROPERTY_STORE_NAME = ".propertystore.db";
    public static final String PROPERTY_KEY_TOKEN_STORE_NAME = ".propertystore.db.index";
    public static final String PROPERTY_KEY_TOKEN_NAMES_STORE_NAME = ".propertystore.db.index.keys";
    public static final String PROPERTY_STRINGS_STORE_NAME = ".propertystore.db.strings";
    public static final String PROPERTY_ARRAYS_STORE_NAME = ".propertystore.db.arrays";
    public static final String RELATIONSHIP_STORE_NAME = ".relationshipstore.db";
    public static final String RELATIONSHIP_TYPE_TOKEN_STORE_NAME = ".relationshiptypestore.db";
    public static final String RELATIONSHIP_TYPE_TOKEN_NAMES_STORE_NAME = ".relationshiptypestore.db.names";
    public static final String LABEL_TOKEN_STORE_NAME = ".labeltokenstore.db";
    public static final String LABEL_TOKEN_NAMES_STORE_NAME = ".labeltokenstore.db.names";
    public static final String SCHEMA_STORE_NAME = ".schemastore.db";
    public static final String RELATIONSHIP_GROUP_STORE_NAME = ".relationshipgroupstore.db";
    public static final String COUNTS_STORE = ".counts.db";
    private final Config config;
    private final IdGeneratorFactory idGeneratorFactory;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final StringLogger stringLogger;
    private final StoreVersionMismatchHandler versionMismatchHandler;
    private final File neoStoreFileName;
    private final Monitors monitors;
    private final PageCache pageCache;

    public StoreFactory(FileSystemAbstraction fileSystem, File storeDir, PageCache pageCache, StringLogger logger, Monitors monitors) {
        this(fileSystem, storeDir, pageCache, logger, monitors, StoreVersionMismatchHandler.FORCE_CURRENT_VERSION);
    }

    public StoreFactory(FileSystemAbstraction fileSystem, File storeDir, PageCache pageCache, StringLogger logger, Monitors monitors, StoreVersionMismatchHandler versionMismatchHandler) {
        this(StoreFactory.configForStoreDir(new Config(), storeDir), new DefaultIdGeneratorFactory(), pageCache, fileSystem, logger, monitors, versionMismatchHandler);
    }

    public StoreFactory(Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, Monitors monitors) {
        this(config, idGeneratorFactory, pageCache, fileSystemAbstraction, stringLogger, monitors, StoreVersionMismatchHandler.FORCE_CURRENT_VERSION);
    }

    public StoreFactory(Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, Monitors monitors, StoreVersionMismatchHandler versionMismatchHandler) {
        this.config = config;
        this.idGeneratorFactory = idGeneratorFactory;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.stringLogger = stringLogger;
        this.versionMismatchHandler = versionMismatchHandler;
        this.neoStoreFileName = config.get(GraphDatabaseSettings.neo_store);
        assert (this.neoStoreFileName != null);
        this.monitors = monitors;
        this.pageCache = pageCache;
    }

    public static String buildTypeDescriptorAndVersion(String typeDescriptor) {
        return typeDescriptor + " " + "v0.A.4";
    }

    public static Config configForStoreDir(Config config, File storeDir) {
        return config.with(MapUtil.stringMap(GraphDatabaseSettings.neo_store.name(), new File(storeDir, "neostore").getAbsolutePath(), GraphDatabaseSettings.store_dir.name(), storeDir.getAbsolutePath()));
    }

    private File storeFileName(String toAppend) {
        return new File(this.neoStoreFileName.getPath() + toAppend);
    }

    public NeoStore newNeoStore(boolean allowCreateEmpty, boolean allowRebuild) {
        return this.newNeoStore(allowCreateEmpty, allowRebuild, -1L);
    }

    private NeoStore newNeoStore(boolean allowCreateEmpty, boolean allowRebuild, long txId) {
        boolean storeExists = this.storeExists();
        if (!storeExists && allowCreateEmpty) {
            return this.createNeoStore();
        }
        if (txId == -1L) {
            txId = NeoStore.getTxId(this.fileSystemAbstraction, this.neoStoreFileName);
        }
        if (storeExists && allowRebuild && !this.countsStoreExists()) {
            this.stringLogger.warn("Missing counts store, rebuilding it.");
            this.rebuildCountsStore(txId);
        }
        return new NeoStore(this.neoStoreFileName, this.config, this.idGeneratorFactory, this.pageCache, this.fileSystemAbstraction, this.stringLogger, this.newRelationshipTypeTokenStore(), this.newLabelTokenStore(), this.newPropertyStore(), this.newRelationshipStore(), this.newNodeStore(), this.newSchemaStore(), this.newRelationshipGroupStore(), this.newCountsStore(txId), this.versionMismatchHandler, this.monitors);
    }

    public boolean storeExists() {
        return this.fileSystemAbstraction.fileExists(this.neoStoreFileName);
    }

    private boolean countsStoreExists() {
        return CountsTracker.countsStoreExists(this.fileSystemAbstraction, this.storeFileName(COUNTS_STORE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildCountsStore(long txId) {
        LifeSupport life = new LifeSupport();
        life.start();
        try {
            StandalonePageCache pageCache = StandalonePageCacheFactory.createPageCache(this.fileSystemAbstraction, new Config(), "build-counts");
            File storeFileBase = this.storeFileName(COUNTS_STORE);
            CountsTracker.createEmptyCountsStore(pageCache, storeFileBase, StoreFactory.buildTypeDescriptorAndVersion(CountsTracker.STORE_DESCRIPTOR));
            try (NodeStore nodeStore = this.newNodeStore();
                 RelationshipStore relationshipStore = this.newRelationshipStore();
                 CountsTracker tracker = new CountsTracker(this.stringLogger, this.fileSystemAbstraction, pageCache, storeFileBase, 1L);){
                CountsComputer.computeCounts(nodeStore, relationshipStore).accept(new CountsAccessor.Initializer(tracker));
                try {
                    tracker.rotate(txId);
                }
                catch (IOException e) {
                    throw new UnderlyingStorageException("Unable to recreate CountsStore", e);
                }
            }
        }
        finally {
            life.shutdown();
        }
    }

    public RelationshipGroupStore newRelationshipGroupStore() {
        return this.newRelationshipGroupStore(this.storeFileName(RELATIONSHIP_GROUP_STORE_NAME));
    }

    public RelationshipGroupStore newRelationshipGroupStore(File baseFile) {
        return new RelationshipGroupStore(baseFile, this.config, this.idGeneratorFactory, this.pageCache, this.fileSystemAbstraction, this.stringLogger, this.versionMismatchHandler, this.monitors);
    }

    public SchemaStore newSchemaStore() {
        return this.newSchemaStore(this.storeFileName(SCHEMA_STORE_NAME));
    }

    public SchemaStore newSchemaStore(File baseFile) {
        return new SchemaStore(baseFile, this.config, IdType.SCHEMA, this.idGeneratorFactory, this.pageCache, this.fileSystemAbstraction, this.stringLogger, this.versionMismatchHandler, this.monitors);
    }

    public DynamicStringStore newDynamicStringStore(File fileName, IdType nameIdType) {
        return new DynamicStringStore(fileName, this.config, nameIdType, this.idGeneratorFactory, this.pageCache, this.fileSystemAbstraction, this.stringLogger, this.versionMismatchHandler, this.monitors);
    }

    public RelationshipTypeTokenStore newRelationshipTypeTokenStore() {
        return this.newRelationshipTypeTokenStore(this.storeFileName(RELATIONSHIP_TYPE_TOKEN_NAMES_STORE_NAME), this.storeFileName(RELATIONSHIP_TYPE_TOKEN_STORE_NAME));
    }

    public RelationshipTypeTokenStore newRelationshipTypeTokenStore(File baseFile) {
        return this.newRelationshipTypeTokenStore(new File(baseFile + NAMES_PART), baseFile);
    }

    private RelationshipTypeTokenStore newRelationshipTypeTokenStore(File relationshipTypeTokenNamesStore, File relationshipTypeTokenStore) {
        DynamicStringStore nameStore = this.newDynamicStringStore(relationshipTypeTokenNamesStore, IdType.RELATIONSHIP_TYPE_TOKEN_NAME);
        return new RelationshipTypeTokenStore(relationshipTypeTokenStore, this.config, this.idGeneratorFactory, this.pageCache, this.fileSystemAbstraction, this.stringLogger, nameStore, this.versionMismatchHandler, this.monitors);
    }

    public PropertyStore newPropertyStore() {
        return this.newPropertyStore(this.storeFileName(PROPERTY_STRINGS_STORE_NAME), this.storeFileName(PROPERTY_ARRAYS_STORE_NAME), this.storeFileName(PROPERTY_STORE_NAME), this.storeFileName(PROPERTY_KEY_TOKEN_STORE_NAME));
    }

    public PropertyStore newPropertyStore(File baseFile) {
        return this.newPropertyStore(new File(baseFile.getPath() + STRINGS_PART), new File(baseFile.getPath() + ARRAYS_PART), baseFile, new File(baseFile.getPath() + INDEX_PART));
    }

    private PropertyStore newPropertyStore(File propertyStringStore, File propertyArrayStore, File propertyStore, File propertyKeysStore) {
        PropertyKeyTokenStore propertyKeyTokenStore = this.newPropertyKeyTokenStore(propertyKeysStore);
        DynamicStringStore stringPropertyStore = this.newDynamicStringStore(propertyStringStore, IdType.STRING_BLOCK);
        DynamicArrayStore arrayPropertyStore = this.newDynamicArrayStore(propertyArrayStore, IdType.ARRAY_BLOCK);
        return new PropertyStore(propertyStore, this.config, this.idGeneratorFactory, this.pageCache, this.fileSystemAbstraction, this.stringLogger, stringPropertyStore, propertyKeyTokenStore, arrayPropertyStore, this.versionMismatchHandler, this.monitors);
    }

    public PropertyKeyTokenStore newPropertyKeyTokenStore() {
        return this.newPropertyKeyTokenStore(this.storeFileName(PROPERTY_KEY_TOKEN_NAMES_STORE_NAME), this.storeFileName(PROPERTY_KEY_TOKEN_STORE_NAME));
    }

    public PropertyKeyTokenStore newPropertyKeyTokenStore(File baseFile) {
        return this.newPropertyKeyTokenStore(new File(baseFile.getPath() + KEYS_PART), baseFile);
    }

    private PropertyKeyTokenStore newPropertyKeyTokenStore(File propertyKeyTokenNamesStore, File propertyKeyTokenStore) {
        DynamicStringStore nameStore = this.newDynamicStringStore(propertyKeyTokenNamesStore, IdType.PROPERTY_KEY_TOKEN_NAME);
        return new PropertyKeyTokenStore(propertyKeyTokenStore, this.config, this.idGeneratorFactory, this.pageCache, this.fileSystemAbstraction, this.stringLogger, nameStore, this.versionMismatchHandler, this.monitors);
    }

    public LabelTokenStore newLabelTokenStore() {
        return this.newLabelTokenStore(this.storeFileName(LABEL_TOKEN_NAMES_STORE_NAME), this.storeFileName(LABEL_TOKEN_STORE_NAME));
    }

    public LabelTokenStore newLabelTokenStore(File baseFile) {
        return this.newLabelTokenStore(new File(baseFile + NAMES_PART), baseFile);
    }

    private LabelTokenStore newLabelTokenStore(File labelTokenNamesStore, File labelTokenStore) {
        DynamicStringStore nameStore = this.newDynamicStringStore(labelTokenNamesStore, IdType.LABEL_TOKEN_NAME);
        return new LabelTokenStore(labelTokenStore, this.config, this.idGeneratorFactory, this.pageCache, this.fileSystemAbstraction, this.stringLogger, nameStore, this.versionMismatchHandler, this.monitors);
    }

    public RelationshipStore newRelationshipStore() {
        return this.newRelationshipStore(this.storeFileName(RELATIONSHIP_STORE_NAME));
    }

    public RelationshipStore newRelationshipStore(File baseFile) {
        return new RelationshipStore(baseFile, this.config, this.idGeneratorFactory, this.pageCache, this.fileSystemAbstraction, this.stringLogger, this.versionMismatchHandler, this.monitors);
    }

    public DynamicArrayStore newDynamicArrayStore(File fileName, IdType idType) {
        return new DynamicArrayStore(fileName, this.config, idType, this.idGeneratorFactory, this.pageCache, this.fileSystemAbstraction, this.stringLogger, this.versionMismatchHandler, this.monitors);
    }

    public NodeStore newNodeStore() {
        return this.newNodeStore(this.storeFileName(NODE_LABELS_STORE_NAME), this.storeFileName(NODE_STORE_NAME));
    }

    public NodeStore newNodeStore(File baseFile) {
        return this.newNodeStore(new File(baseFile.getPath() + LABELS_PART), baseFile);
    }

    private NodeStore newNodeStore(File labelStore, File nodeStore) {
        DynamicArrayStore dynamicLabelStore = new DynamicArrayStore(labelStore, this.config, IdType.NODE_LABELS, this.idGeneratorFactory, this.pageCache, this.fileSystemAbstraction, this.stringLogger, this.versionMismatchHandler, this.monitors);
        return new NodeStore(nodeStore, this.config, this.idGeneratorFactory, this.pageCache, this.fileSystemAbstraction, this.stringLogger, dynamicLabelStore, this.versionMismatchHandler, this.monitors);
    }

    private CountsTracker newCountsStore(long txId) {
        return new CountsTracker(this.stringLogger, this.fileSystemAbstraction, this.pageCache, this.storeFileName(COUNTS_STORE), txId);
    }

    public NeoStore createNeoStore() {
        return this.createNeoStore(new StoreId());
    }

    public NeoStore createNeoStore(StoreId storeId) {
        this.stringLogger.info("Creating new db @ " + this.neoStoreFileName);
        try {
            this.fileSystemAbstraction.mkdirs(this.neoStoreFileName.getParentFile());
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to create directory " + this.neoStoreFileName.getParentFile() + " for creating a neo store in", e);
        }
        this.createEmptyStore(this.neoStoreFileName, StoreFactory.buildTypeDescriptorAndVersion("NeoStore"));
        this.createNodeStore();
        this.createRelationshipStore();
        this.createPropertyStore();
        this.createRelationshipTypeStore();
        this.createLabelTokenStore();
        this.createSchemaStore();
        this.createRelationshipGroupStore(this.config.get(Configuration.dense_node_threshold));
        this.createCountsStore();
        NeoStore neoStore = this.newNeoStore(false, false, 1L);
        for (int i = 0; i < 9; ++i) {
            neoStore.nextId();
        }
        neoStore.setCreationTime(storeId.getCreationTime());
        neoStore.setRandomNumber(storeId.getRandomId());
        neoStore.setUpgradeTime(storeId.getCreationTime());
        neoStore.setUpgradeId(storeId.getRandomId());
        neoStore.setCurrentLogVersion(0L);
        neoStore.setLastCommittedAndClosedTransactionId(1L);
        neoStore.setStoreVersion(NeoStore.versionStringToLong("v0.A.4"));
        neoStore.setGraphNextProp(-1L);
        neoStore.setLatestConstraintIntroducingTx(0L);
        neoStore.flush();
        return neoStore;
    }

    public void createNodeStore() {
        this.createNodeLabelsStore();
        this.createEmptyStore(this.storeFileName(NODE_STORE_NAME), StoreFactory.buildTypeDescriptorAndVersion("NodeStore"));
    }

    private void createNodeLabelsStore() {
        int labelStoreBlockSize = this.config.get(Configuration.label_block_size);
        this.createEmptyDynamicStore(this.storeFileName(NODE_LABELS_STORE_NAME), labelStoreBlockSize, DynamicArrayStore.VERSION, IdType.NODE_LABELS);
    }

    public void createRelationshipStore() {
        this.createEmptyStore(this.storeFileName(RELATIONSHIP_STORE_NAME), StoreFactory.buildTypeDescriptorAndVersion("RelationshipStore"));
    }

    public void createPropertyStore() {
        this.createEmptyStore(this.storeFileName(PROPERTY_STORE_NAME), StoreFactory.buildTypeDescriptorAndVersion("PropertyStore"));
        int stringStoreBlockSize = this.config.get(Configuration.string_block_size);
        int arrayStoreBlockSize = this.config.get(Configuration.array_block_size);
        this.createPropertyKeyTokenStore();
        this.createDynamicStringStore(this.storeFileName(PROPERTY_STRINGS_STORE_NAME), stringStoreBlockSize, IdType.STRING_BLOCK);
        this.createDynamicArrayStore(this.storeFileName(PROPERTY_ARRAYS_STORE_NAME), arrayStoreBlockSize);
    }

    private void createRelationshipTypeStore() {
        this.createEmptyStore(this.storeFileName(RELATIONSHIP_TYPE_TOKEN_STORE_NAME), StoreFactory.buildTypeDescriptorAndVersion("RelationshipTypeStore"));
        this.createDynamicStringStore(this.storeFileName(RELATIONSHIP_TYPE_TOKEN_NAMES_STORE_NAME), 30, IdType.RELATIONSHIP_TYPE_TOKEN_NAME);
        RelationshipTypeTokenStore store = this.newRelationshipTypeTokenStore();
        store.close();
    }

    private void createLabelTokenStore() {
        this.createEmptyStore(this.storeFileName(LABEL_TOKEN_STORE_NAME), StoreFactory.buildTypeDescriptorAndVersion("LabelTokenStore"));
        this.createDynamicStringStore(this.storeFileName(LABEL_TOKEN_NAMES_STORE_NAME), 30, IdType.LABEL_TOKEN_NAME);
        LabelTokenStore store = this.newLabelTokenStore();
        store.close();
    }

    public void createDynamicStringStore(File fileName, int blockSize, IdType idType) {
        this.createEmptyDynamicStore(fileName, blockSize, DynamicStringStore.VERSION, idType);
    }

    public void createPropertyKeyTokenStore() {
        this.createEmptyStore(this.storeFileName(PROPERTY_KEY_TOKEN_STORE_NAME), StoreFactory.buildTypeDescriptorAndVersion("PropertyIndexStore"));
        this.createDynamicStringStore(this.storeFileName(PROPERTY_KEY_TOKEN_NAMES_STORE_NAME), 30, IdType.PROPERTY_KEY_TOKEN_NAME);
    }

    public void createDynamicArrayStore(File fileName, int blockSize) {
        this.createEmptyDynamicStore(fileName, blockSize, DynamicArrayStore.VERSION, IdType.ARRAY_BLOCK);
    }

    public void createSchemaStore() {
        this.createEmptyDynamicStore(this.storeFileName(SCHEMA_STORE_NAME), 56, SchemaStore.VERSION, IdType.SCHEMA);
    }

    private void createCountsStore() {
        CountsTracker.createEmptyCountsStore(this.pageCache, this.storeFileName(COUNTS_STORE), StoreFactory.buildTypeDescriptorAndVersion(CountsTracker.STORE_DESCRIPTOR));
    }

    public void createEmptyDynamicStore(File fileName, int baseBlockSize, String typeAndVersionDescriptor, IdType idType) {
        int blockSize = baseBlockSize;
        if (fileName == null) {
            throw new IllegalArgumentException("Null filename");
        }
        if (this.fileSystemAbstraction.fileExists(fileName)) {
            throw new IllegalStateException("Can't create store[" + fileName + "], file already exists");
        }
        if (blockSize < 1) {
            throw new IllegalArgumentException("Illegal block size[" + blockSize + "]");
        }
        if (blockSize > 65535) {
            throw new IllegalArgumentException("Illegal block size[" + blockSize + "], limit is 65535");
        }
        blockSize += 8;
        try {
            StoreChannel channel = this.fileSystemAbstraction.create(fileName);
            int endHeaderSize = blockSize + UTF8.encode(typeAndVersionDescriptor).length;
            ByteBuffer buffer = ByteBuffer.allocate(endHeaderSize);
            buffer.putInt(blockSize);
            buffer.position(endHeaderSize - typeAndVersionDescriptor.length());
            buffer.put(UTF8.encode(typeAndVersionDescriptor)).flip();
            channel.write(buffer);
            channel.force(false);
            channel.close();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to create store " + fileName, e);
        }
        this.idGeneratorFactory.create(this.fileSystemAbstraction, new File(fileName.getPath() + ".id"), 0L);
        IdGenerator idGenerator = this.idGeneratorFactory.open(this.fileSystemAbstraction, new File(fileName.getPath() + ".id"), idType.getGrabSize(), idType, 0L);
        idGenerator.nextId();
        idGenerator.close();
    }

    public void createRelationshipGroupStore(int denseNodeThreshold) {
        ByteBuffer firstRecord = ByteBuffer.allocate(25).putInt(denseNodeThreshold);
        firstRecord.flip();
        firstRecord.limit(firstRecord.capacity());
        this.createEmptyStore(this.storeFileName(RELATIONSHIP_GROUP_STORE_NAME), StoreFactory.buildTypeDescriptorAndVersion("RelationshipGroupStore"), firstRecord, IdType.RELATIONSHIP_GROUP);
    }

    public void createEmptyStore(File fileName, String typeAndVersionDescriptor) {
        this.createEmptyStore(fileName, typeAndVersionDescriptor, null, null);
    }

    private void createEmptyStore(File fileName, String typeAndVersionDescriptor, ByteBuffer firstRecordData, IdType idType) {
        if (fileName == null) {
            throw new IllegalArgumentException("Null filename");
        }
        if (this.fileSystemAbstraction.fileExists(fileName)) {
            throw new IllegalStateException("Can't create store[" + fileName + "], file already exists");
        }
        try {
            StoreChannel channel = this.fileSystemAbstraction.create(fileName);
            int endHeaderSize = UTF8.encode(typeAndVersionDescriptor).length;
            if (firstRecordData != null) {
                endHeaderSize += firstRecordData.limit();
            }
            ByteBuffer buffer = ByteBuffer.allocate(endHeaderSize);
            if (firstRecordData != null) {
                buffer.put(firstRecordData);
            }
            buffer.put(UTF8.encode(typeAndVersionDescriptor)).flip();
            channel.write(buffer);
            channel.force(false);
            channel.close();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to create store " + fileName, e);
        }
        this.idGeneratorFactory.create(this.fileSystemAbstraction, new File(fileName.getPath() + ".id"), 0L);
        if (firstRecordData != null) {
            IdGenerator idGenerator = this.idGeneratorFactory.open(this.fileSystemAbstraction, new File(fileName.getPath() + ".id"), 1, idType, 0L);
            idGenerator.nextId();
            idGenerator.close();
        }
    }

    public static abstract class Configuration {
        public static final Setting<Integer> string_block_size = GraphDatabaseSettings.string_block_size;
        public static final Setting<Integer> array_block_size = GraphDatabaseSettings.array_block_size;
        public static final Setting<Integer> label_block_size = GraphDatabaseSettings.label_block_size;
        public static final Setting<Integer> dense_node_threshold = GraphDatabaseSettings.dense_node_threshold;
    }
}

