/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Settings;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.RunnablePageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.monitoring.PageCacheMonitor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class LifecycledPageCache
extends LifecycleAdapter
implements PageCache {
    private final RunnablePageCache pageCache;
    private final JobScheduler scheduler;
    private volatile JobScheduler.JobHandle pageEvictionJobHandle;

    public LifecycledPageCache(PageSwapperFactory swapperFactory, JobScheduler scheduler, Config config, PageCacheMonitor monitor) {
        this.scheduler = scheduler;
        this.pageCache = new MuninnPageCache(swapperFactory, LifecycledPageCache.calculateMaxPages(config), LifecycledPageCache.calculatePageSize(config), monitor);
    }

    private static int calculateMaxPages(Config config) {
        long availableMemory = config.get(GraphDatabaseSettings.mapped_memory_total_size);
        long pageSize = config.get(GraphDatabaseSettings.mapped_memory_page_size);
        long pageCount = availableMemory / pageSize;
        return (int)Math.min(Integer.MAX_VALUE, pageCount);
    }

    private static int calculatePageSize(Config config) {
        return config.get(GraphDatabaseSettings.mapped_memory_page_size).intValue();
    }

    @Override
    public void start() {
        this.pageEvictionJobHandle = this.scheduler.schedule(JobScheduler.Group.pageCacheEviction, (Runnable)this.pageCache);
    }

    @Override
    public void stop() throws IOException {
        JobScheduler.JobHandle handle = this.pageEvictionJobHandle;
        if (handle != null) {
            handle.cancel(true);
        }
        this.close();
    }

    public void close() throws IOException {
        this.pageCache.close();
    }

    public void unmap(File fileName) throws IOException {
        this.pageCache.unmap(fileName);
    }

    public PagedFile map(File file, int filePageSize) throws IOException {
        return this.pageCache.map(file, filePageSize);
    }

    public void flush() throws IOException {
        this.pageCache.flush();
    }

    public int pageSize() {
        return this.pageCache.pageSize();
    }

    public int maxCachedPages() {
        return this.pageCache.maxCachedPages();
    }

    public void dumpConfiguration(StringLogger messagesLog) {
        long totalPhysicalMemMb = Settings.DirectMemoryUsage.totalPhysicalMemory() / 1024L / 1024L;
        long maxVmUsageMb = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        long pageCacheMb = this.maxCachedPages() * this.pageSize() / 1024 / 1024;
        String msg = "Physical mem: " + totalPhysicalMemMb + "MB," + " Heap size: " + maxVmUsageMb + "MB," + " Page cache size: " + pageCacheMb + "MB.";
        messagesLog.info(msg);
    }

    public PageCache unwrap() {
        return this.pageCache;
    }
}

