/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.primitive.FunctionFromPrimitiveInt;
import org.neo4j.function.primitive.FunctionFromPrimitiveLong;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.ResourceClosingIterator;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.traversal.OldTraverserWrapper;

public class NodeProxy
implements Node {
    private final NodeLookup nodeLookup;
    private final RelationshipProxy.RelationshipLookups relLookup;
    private final ThreadToStatementContextBridge statementContextProvider;
    private final long nodeId;

    public NodeProxy(long nodeId, NodeLookup nodeLookup, RelationshipProxy.RelationshipLookups relLookup, ThreadToStatementContextBridge statementContextProvider) {
        this.nodeId = nodeId;
        this.nodeLookup = nodeLookup;
        this.relLookup = relLookup;
        this.statementContextProvider = statementContextProvider;
    }

    @Override
    public long getId() {
        return this.nodeId;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.nodeLookup.getGraphDatabase();
    }

    @Override
    public void delete() {
        try (Statement statement = this.statementContextProvider.instance();){
            statement.dataWriteOperations().nodeDelete(this.getId());
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException("Unable to delete Node[" + this.nodeId + "] since it has already been deleted.");
        }
    }

    public ResourceIterable<Relationship> getRelationships() {
        return this.getRelationships(Direction.BOTH);
    }

    public ResourceIterable<Relationship> getRelationships(Direction dir) {
        Statement statement = this.statementContextProvider.instance();
        try {
            return this.map2rels(statement, statement.readOperations().nodeGetRelationships(this.nodeId, dir));
        }
        catch (EntityNotFoundException e) {
            statement.close();
            throw new NotFoundException(String.format("Node %d not found", this.nodeId), e);
        }
    }

    public ResourceIterable<Relationship> getRelationships(RelationshipType ... types) {
        return this.getRelationships(Direction.BOTH, types);
    }

    public ResourceIterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
        return this.getRelationships(dir, new RelationshipType[]{type});
    }

    public ResourceIterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
        Statement statement = this.statementContextProvider.instance();
        try {
            return this.map2rels(statement, statement.readOperations().nodeGetRelationships(this.nodeId, direction, this.relTypeIds(types, statement)));
        }
        catch (EntityNotFoundException e) {
            statement.close();
            throw new NotFoundException(String.format("Node %d not found", this.nodeId), e);
        }
    }

    @Override
    public boolean hasRelationship() {
        return this.hasRelationship(Direction.BOTH);
    }

    @Override
    public boolean hasRelationship(Direction dir) {
        try (ResourceIterator rels = this.getRelationships(dir).iterator();){
            boolean bl = rels.hasNext();
            return bl;
        }
    }

    @Override
    public boolean hasRelationship(RelationshipType ... types) {
        return this.hasRelationship(Direction.BOTH, types);
    }

    @Override
    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        try (ResourceIterator rels = this.getRelationships(direction, types).iterator();){
            boolean bl = rels.hasNext();
            return bl;
        }
    }

    @Override
    public boolean hasRelationship(RelationshipType type, Direction dir) {
        return this.hasRelationship(dir, type);
    }

    @Override
    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        try (ResourceIterator rels = this.getRelationships(dir, new RelationshipType[]{type}).iterator();){
            if (!rels.hasNext()) {
                Relationship relationship = null;
                return relationship;
            }
            Relationship rel = (Relationship)rels.next();
            while (rels.hasNext()) {
                Relationship other = (Relationship)rels.next();
                if (other.equals(rel)) continue;
                throw new NotFoundException("More than one relationship[" + type + ", " + (Object)((Object)dir) + "] found for " + this);
            }
            Relationship relationship = rel;
            return relationship;
        }
    }

    private void assertInUnterminatedTransaction() {
        this.statementContextProvider.assertInUnterminatedTransaction();
    }

    @Override
    public void setProperty(String key, Object value) {
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            try {
                statement.dataWriteOperations().nodeSetProperty(this.nodeId, Property.property(propertyKeyId, value));
            }
            catch (ConstraintValidationKernelException e) {
                throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e);
            }
            catch (IllegalArgumentException e) {
                this.statementContextProvider.getKernelTransactionBoundToThisThread(true).failure();
                throw e;
            }
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object removeProperty(String key) throws NotFoundException {
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            Object object = statement.dataWriteOperations().nodeRemoveProperty(this.nodeId, propertyKeyId).value(null);
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(key);
            Object object = statement.readOperations().nodeGetProperty(this.nodeId, propertyKeyId).value(defaultValue);
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<String> getPropertyKeys() {
        try (Statement statement = this.statementContextProvider.instance();){
            ArrayList<String> keys = new ArrayList<String>();
            Iterator<DefinedProperty> properties = statement.readOperations().nodeGetAllProperties(this.getId());
            while (properties.hasNext()) {
                keys.add(statement.readOperations().propertyKeyGetName(properties.next().propertyKeyId()));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found", e);
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new ThisShouldNotHappenError("Jake", "Property key retrieved through kernel API should exist.", e);
        }
    }

    @Override
    public Object getProperty(String key) throws NotFoundException {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        Throwable throwable = null;
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(key);
            if (propertyKeyId == -1) {
                throw new NotFoundException(String.format("No such property, '%s'.", key));
            }
            Object object = statement.readOperations().nodeGetProperty(this.nodeId, propertyKeyId).value();
            return object;
        }
        catch (EntityNotFoundException | PropertyNotFoundException e) {
            try {
                throw new NotFoundException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(key);
            boolean bl = statement.readOperations().nodeGetProperty(this.nodeId, propertyKeyId).isDefined();
            return bl;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    public int compareTo(Object node) {
        long theirId;
        Node n = (Node)node;
        long ourId = this.getId();
        if (ourId < (theirId = n.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof Node && this.getId() == ((Node)o).getId();
    }

    public int hashCode() {
        return (int)(this.nodeId >>> 32 ^ this.nodeId);
    }

    public String toString() {
        return "Node[" + this.getId() + "]";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        if (otherNode == null) {
            throw new IllegalArgumentException("Other node is null.");
        }
        try (Statement statement = this.statementContextProvider.instance();){
            int relationshipTypeId = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName(type.name());
            RelationshipProxy relationshipProxy = this.nodeLookup.getNodeManager().newRelationshipProxyById(statement.dataWriteOperations().relationshipCreate(relationshipTypeId, this.nodeId, otherNode.getId()));
            return relationshipProxy;
        }
        catch (RelationshipTypeIdNotFoundKernelException | IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException("Node[" + e.entityId() + "] is deleted and cannot be used to create a relationship");
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
        this.assertInUnterminatedTransaction();
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{relationshipType, direction});
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
        this.assertInUnterminatedTransaction();
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{firstRelationshipType, firstDirection, secondRelationshipType, secondDirection});
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
        this.assertInUnterminatedTransaction();
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, relationshipTypesAndDirections);
    }

    @Override
    public void addLabel(Label label) {
        try (Statement statement = this.statementContextProvider.instance();){
            try {
                statement.dataWriteOperations().nodeAddLabel(this.getId(), statement.tokenWriteOperations().labelGetOrCreateForName(label.name()));
            }
            catch (ConstraintValidationKernelException e) {
                throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e);
            }
        }
        catch (IllegalTokenNameException e) {
            throw new ConstraintViolationException(String.format("Invalid label name '%s'.", label.name()), e);
        }
        catch (TooManyLabelsException e) {
            throw new ConstraintViolationException("Unable to add label.", e);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("No node with id " + this.getId() + " found.", e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    @Override
    public void removeLabel(Label label) {
        try (Statement statement = this.statementContextProvider.instance();){
            int labelId = statement.readOperations().labelGetForName(label.name());
            if (labelId != -1) {
                statement.dataWriteOperations().nodeRemoveLabel(this.getId(), labelId);
            }
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("No node with id " + this.getId() + " found.", e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasLabel(Label label) {
        try (Statement statement = this.statementContextProvider.instance();){
            int labelId = statement.readOperations().labelGetForName(label.name());
            boolean bl = statement.readOperations().nodeHasLabel(this.getId(), labelId);
            return bl;
        }
        catch (EntityNotFoundException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<Label> getLabels() {
        try (Statement statement = this.statementContextProvider.instance();){
            PrimitiveIntIterator labels = statement.readOperations().nodeGetLabels(this.getId());
            ArrayList<Label> keys = new ArrayList<Label>();
            while (labels.hasNext()) {
                int labelId = labels.next();
                keys.add(DynamicLabel.label(statement.readOperations().labelGetName(labelId)));
            }
            ArrayList<Label> arrayList = keys;
            return arrayList;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found", e);
        }
        catch (LabelNotFoundKernelException e) {
            throw new ThisShouldNotHappenError("Stefan", "Label retrieved through kernel API should exist.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDegree() {
        try (Statement statement = this.statementContextProvider.instance();){
            int n = statement.readOperations().nodeGetDegree(this.nodeId, Direction.BOTH);
            return n;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDegree(RelationshipType type) {
        try (Statement statement = this.statementContextProvider.instance();){
            ReadOperations ops = statement.readOperations();
            int typeId = ops.relationshipTypeGetForName(type.name());
            if (typeId == -1) {
                int n = 0;
                return n;
            }
            int n = ops.nodeGetDegree(this.nodeId, Direction.BOTH, typeId);
            return n;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDegree(Direction direction) {
        try (Statement statement = this.statementContextProvider.instance();){
            ReadOperations ops = statement.readOperations();
            int n = ops.nodeGetDegree(this.nodeId, direction);
            return n;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDegree(RelationshipType type, Direction direction) {
        try (Statement statement = this.statementContextProvider.instance();){
            ReadOperations ops = statement.readOperations();
            int typeId = ops.relationshipTypeGetForName(type.name());
            if (typeId == -1) {
                int n = 0;
                return n;
            }
            int n = ops.nodeGetDegree(this.nodeId, direction, typeId);
            return n;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<RelationshipType> getRelationshipTypes() {
        try (Statement statement = this.statementContextProvider.instance();){
            ReadOperations ops = statement.readOperations();
            Iterable<RelationshipType> iterable = this.map2relTypes(statement, ops.nodeGetRelationshipTypes(this.nodeId));
            return iterable;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found.", e);
        }
    }

    private int[] relTypeIds(RelationshipType[] types, Statement statement) {
        int[] ids = new int[types.length];
        int outIndex = 0;
        for (int i = 0; i < types.length; ++i) {
            int id = statement.readOperations().relationshipTypeGetForName(types[i].name());
            if (id == -1) continue;
            ids[outIndex++] = id;
        }
        if (outIndex != ids.length) {
            ids = Arrays.copyOf(ids, outIndex);
        }
        return ids;
    }

    private ResourceIterable<Relationship> map2rels(Statement statement, PrimitiveLongIterator input) {
        return Iterables.asResourceIterable(ResourceClosingIterator.newResourceIterator(statement, PrimitiveLongCollections.map((FunctionFromPrimitiveLong)new FunctionFromPrimitiveLong<Relationship>(){

            public Relationship apply(long id) {
                return new RelationshipProxy(id, NodeProxy.this.relLookup, NodeProxy.this.statementContextProvider);
            }
        }, (PrimitiveLongIterator)input)));
    }

    private Iterable<RelationshipType> map2relTypes(final Statement statement, PrimitiveIntIterator input) {
        return IteratorUtil.asList(PrimitiveIntCollections.map((FunctionFromPrimitiveInt)new FunctionFromPrimitiveInt<RelationshipType>(){

            public RelationshipType apply(int id) {
                try {
                    return DynamicRelationshipType.withName(statement.readOperations().relationshipTypeGetName(id));
                }
                catch (RelationshipTypeIdNotFoundKernelException e) {
                    throw new ThisShouldNotHappenError("Jake", "Kernel API returned non-existent relationship type: " + id);
                }
            }
        }, (PrimitiveIntIterator)input));
    }

    public static interface NodeLookup {
        public GraphDatabaseService getGraphDatabase();

        public NodeManager getNodeManager();
    }
}

