/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.TxState;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.util.register.NeoRegister;
import org.neo4j.kernel.impl.util.register.NeoRegisters;
import org.neo4j.register.Register;

public class AugmentWithLocalStateExpandCursor
implements Cursor {
    private final RelationshipVisitor<RuntimeException> neighborFetcher = new RelationshipVisitor<RuntimeException>(){

        @Override
        public void visit(long id, int type, long startNode, long endNode) throws RuntimeException {
            AugmentWithLocalStateExpandCursor.this.relId.write(id);
            long origin = AugmentWithLocalStateExpandCursor.this.nodeId.read();
            if (startNode == endNode) {
                AugmentWithLocalStateExpandCursor.this.startNodeId.write(origin);
                AugmentWithLocalStateExpandCursor.this.neighborNodeId.write(origin);
                AugmentWithLocalStateExpandCursor.this.direction.write((Object)Direction.BOTH);
                AugmentWithLocalStateExpandCursor.this.relType.write(type);
            } else if (startNode == origin) {
                AugmentWithLocalStateExpandCursor.this.startNodeId.write(origin);
                AugmentWithLocalStateExpandCursor.this.neighborNodeId.write(endNode);
                AugmentWithLocalStateExpandCursor.this.direction.write((Object)Direction.OUTGOING);
                AugmentWithLocalStateExpandCursor.this.relType.write(type);
            } else {
                AugmentWithLocalStateExpandCursor.this.startNodeId.write(origin);
                AugmentWithLocalStateExpandCursor.this.neighborNodeId.write(startNode);
                AugmentWithLocalStateExpandCursor.this.direction.write((Object)Direction.INCOMING);
                AugmentWithLocalStateExpandCursor.this.relType.write(type);
            }
        }
    };
    private final StoreInputCursor storeInputCursor = new StoreInputCursor();
    private final Cursor storeCursor;
    private final Cursor inputCursor;
    private final TxState txState;
    private final NeoRegister.Node.In nodeId;
    private final Register.Object.In<int[]> relTypes;
    private final Register.Object.In<Direction> expandDirection;
    private final NeoRegister.Relationship.Out relId;
    private final NeoRegister.RelType.Out relType;
    private final Register.Object.Out<Direction> direction;
    private final NeoRegister.Node.Out startNodeId;
    private final NeoRegister.Node.Out neighborNodeId;
    private final NeoRegister.RelationshipRegister relIdFromStore = NeoRegisters.newRelationshipRegister();
    private State state = State.DELEGATING_TO_STORE;
    private PrimitiveLongIterator txLocalRels;

    public AugmentWithLocalStateExpandCursor(StoreReadLayer store, TxState state, Cursor inputCursor, NeoRegister.Node.In nodeId, Register.Object.In<int[]> relTypes, Register.Object.In<Direction> expandDirection, NeoRegister.Relationship.Out relId, NeoRegister.RelType.Out relType, Register.Object.Out<Direction> direction, NeoRegister.Node.Out startNodeId, NeoRegister.Node.Out neighborNodeId) {
        this.txState = state;
        this.inputCursor = inputCursor;
        this.nodeId = nodeId;
        this.relTypes = relTypes;
        this.expandDirection = expandDirection;
        this.relId = relId;
        this.relType = relType;
        this.direction = direction;
        this.startNodeId = startNodeId;
        this.neighborNodeId = neighborNodeId;
        this.storeCursor = store.expand(this.storeInputCursor, nodeId, relTypes, expandDirection, this.relIdFromStore, relType, direction, startNodeId, neighborNodeId);
    }

    public boolean next() {
        switch (this.state) {
            case DELEGATING_TO_STORE: {
                return this.nextFromStore();
            }
            case INJECTING_LOCAL_RELS: {
                return this.nextTxLocalRel();
            }
        }
        throw new ThisShouldNotHappenError("jake", "Unknown state: " + (Object)((Object)this.state));
    }

    private boolean nextTxLocalRel() {
        if (this.txLocalRels.hasNext()) {
            long id = this.txLocalRels.next();
            this.txState.relationshipVisit(id, this.neighborFetcher);
            return true;
        }
        this.state = State.DELEGATING_TO_STORE;
        return this.next();
    }

    private boolean nextFromStore() {
        if (!this.txState.nodeIsAddedInThisTx(this.nodeId.read())) {
            while (this.storeCursor.next()) {
                if (this.txState.relationshipIsDeletedInThisTx(this.relIdFromStore.read())) continue;
                this.relId.write(this.relIdFromStore.read());
                return true;
            }
        }
        if (this.inputCursor.next()) {
            this.storeInputCursor.makeNextAvailable();
            this.storeCursor.reset();
            this.txLocalRels = this.txState.addedRelationships(this.nodeId.read(), (int[])this.relTypes.read(), (Direction)((Object)this.expandDirection.read()));
            if (this.txLocalRels != null) {
                this.state = State.INJECTING_LOCAL_RELS;
            }
            return this.next();
        }
        return false;
    }

    public void reset() {
        this.storeCursor.reset();
        this.inputCursor.reset();
    }

    public void close() {
        this.storeCursor.close();
        this.inputCursor.close();
    }

    private static enum State {
        DELEGATING_TO_STORE,
        INJECTING_LOCAL_RELS;

    }

    private static class StoreInputCursor
    implements Cursor {
        private boolean next = false;

        private StoreInputCursor() {
        }

        public boolean next() {
            if (this.next) {
                this.next = false;
                return true;
            }
            return false;
        }

        public void reset() {
        }

        public void close() {
        }

        public void makeNextAvailable() {
            this.next = true;
        }
    }
}

