/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Iterator;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;

public class RemoveOrphanConstraintIndexesOnStartup {
    private final StringLogger log;
    private final KernelAPI kernel;

    public RemoveOrphanConstraintIndexesOnStartup(KernelAPI kernel, Logging logging) {
        this.kernel = kernel;
        this.log = logging.getMessagesLog(this.getClass());
    }

    public void perform() {
        try (KernelTransaction transaction = this.kernel.newTransaction();
             Statement statement = transaction.acquireStatement();){
            Iterator<IndexDescriptor> indexes = statement.readOperations().uniqueIndexesGetAll();
            while (indexes.hasNext()) {
                IndexDescriptor index = indexes.next();
                if (statement.readOperations().indexGetOwningUniquenessConstraintId(index) != null) continue;
                statement.schemaWriteOperations().uniqueIndexDrop(index);
            }
        }
        catch (KernelException e) {
            this.log.error("Failed to execute orphan index checking transaction.", e);
        }
    }
}

