/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.graphdb.index.IndexProviders;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Provider;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.TransactionEventHandlers;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.ConstraintEnforcingEntityOperations;
import org.neo4j.kernel.impl.api.DataIntegrityValidatingStatementOperations;
import org.neo4j.kernel.impl.api.GuardingStatementOperations;
import org.neo4j.kernel.impl.api.Kernel;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.LegacyIndexApplier;
import org.neo4j.kernel.impl.api.LegacyPropertyTrackers;
import org.neo4j.kernel.impl.api.LockingStatementOperations;
import org.neo4j.kernel.impl.api.SchemaStateConcern;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.store.CacheLayer;
import org.neo4j.kernel.impl.api.store.DiskLayer;
import org.neo4j.kernel.impl.api.store.PersistenceCache;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.cache.AutoLoadingCache;
import org.neo4j.kernel.impl.cache.BridgingCacheAccess;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipLoader;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.StartupStatisticsProvider;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.LegacyIndexStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ReentrantLockService;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.LogFileRecoverer;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogRotationControl;
import org.neo4j.kernel.impl.transaction.log.LoggingLogFileMonitor;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFileInformation;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReaderFactory;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.transaction.state.CacheLoaders;
import org.neo4j.kernel.impl.transaction.state.DefaultSchemaIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.impl.transaction.state.NeoStoreFileListing;
import org.neo4j.kernel.impl.transaction.state.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.NeoStoreInjectedTransactionValidator;
import org.neo4j.kernel.impl.transaction.state.NeoStoreProvider;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContextSupplier;
import org.neo4j.kernel.impl.transaction.state.RecoveryVisitor;
import org.neo4j.kernel.impl.transaction.state.RelationshipChainLoader;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.impl.util.SynchronizedArrayIdOrderingQueue;
import org.neo4j.kernel.info.DiagnosticsExtractor;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class NeoStoreDataSource
implements NeoStoreProvider,
Lifecycle,
LogRotationControl,
IndexProviders {
    private final Monitors monitors;
    public static final String DEFAULT_DATA_SOURCE_NAME = "nioneodb";
    private final StringLogger msgLog;
    private final Logging logging;
    private final DependencyResolver dependencyResolver;
    private final TokenNameLookup tokenNameLookup;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokens;
    private final RelationshipTypeTokenHolder relationshipTypeTokens;
    private final Locks locks;
    private final SchemaWriteGuard schemaWriteGuard;
    private final TransactionEventHandlers transactionEventHandlers;
    private final StoreFactory storeFactory;
    private final JobScheduler scheduler;
    private final UpdateableSchemaState updateableSchemaState;
    private final Config config;
    private final LockService lockService;
    private final IndexingService.Monitor indexingServiceMonitor;
    private final FileSystemAbstraction fs;
    private final StoreUpgrader storeMigrationProcess;
    private final TransactionMonitor transactionMonitor;
    private final KernelHealth kernelHealth;
    private final PhysicalLogFile.Monitor physicalLogMonitor;
    private final TransactionHeaderInformationFactory transactionHeaderInformationFactory;
    private final StartupStatisticsProvider startupStatistics;
    private final Caches cacheProvider;
    private final NodeManager nodeManager;
    private final CommitProcessFactory commitProcessFactory;
    private final PageCache pageCache;
    private final AtomicInteger recoveredCount = new AtomicInteger();
    private final Guard guard;
    private final Map<String, IndexImplementation> indexProviders = new HashMap<String, IndexImplementation>();
    private final LegacyIndexApplier.ProviderLookup legacyIndexProviderLookup;
    private KernelTransactions kernelTransactions;
    private Dependencies dependencies;
    private LifeSupport life;
    private KernelAPI kernel;
    private NeoStore neoStore;
    private IndexingService indexingService;
    private SchemaIndexProvider indexProvider;
    private NeoStoreFileListing fileListing;
    private File storeDir;
    private boolean readOnly;
    private AutoLoadingCache<NodeImpl> nodeCache;
    private AutoLoadingCache<RelationshipImpl> relationshipCache;
    private SchemaCache schemaCache;
    private LabelScanStore labelScanStore;
    private StoreReadLayer storeLayer;
    private LogFile logFile;
    private IndexConfigStore indexConfigStore;

    public NeoStoreDataSource(Config config, StoreFactory sf, StringLogger stringLogger, JobScheduler scheduler, Logging logging, UpdateableSchemaState updateableSchemaState, TokenNameLookup tokenNameLookup, DependencyResolver dependencyResolver, PropertyKeyTokenHolder propertyKeyTokens, LabelTokenHolder labelTokens, RelationshipTypeTokenHolder relationshipTypeTokens, Locks lockManager, SchemaWriteGuard schemaWriteGuard, TransactionEventHandlers transactionEventHandlers, IndexingService.Monitor indexingServiceMonitor, FileSystemAbstraction fs, StoreUpgrader storeMigrationProcess, TransactionMonitor transactionMonitor, KernelHealth kernelHealth, PhysicalLogFile.Monitor physicalLogMonitor, TransactionHeaderInformationFactory transactionHeaderInformationFactory, StartupStatisticsProvider startupStatistics, Caches cacheProvider, NodeManager nodeManager, Guard guard, IndexConfigStore indexConfigStore, CommitProcessFactory commitProcessFactory, PageCache pageCache, Monitors monitors) {
        this.config = config;
        this.tokenNameLookup = tokenNameLookup;
        this.dependencyResolver = dependencyResolver;
        this.scheduler = scheduler;
        this.logging = logging;
        this.propertyKeyTokenHolder = propertyKeyTokens;
        this.labelTokens = labelTokens;
        this.relationshipTypeTokens = relationshipTypeTokens;
        this.locks = lockManager;
        this.schemaWriteGuard = schemaWriteGuard;
        this.transactionEventHandlers = transactionEventHandlers;
        this.indexingServiceMonitor = indexingServiceMonitor;
        this.fs = fs;
        this.storeMigrationProcess = storeMigrationProcess;
        this.transactionMonitor = transactionMonitor;
        this.kernelHealth = kernelHealth;
        this.physicalLogMonitor = physicalLogMonitor;
        this.transactionHeaderInformationFactory = transactionHeaderInformationFactory;
        this.startupStatistics = startupStatistics;
        this.cacheProvider = cacheProvider;
        this.nodeManager = nodeManager;
        this.guard = guard;
        this.indexConfigStore = indexConfigStore;
        this.monitors = monitors;
        this.readOnly = config.get(Configuration.read_only);
        this.msgLog = stringLogger;
        this.storeFactory = sf;
        this.updateableSchemaState = updateableSchemaState;
        this.lockService = new ReentrantLockService();
        this.legacyIndexProviderLookup = new LegacyIndexApplier.ProviderLookup(){

            @Override
            public IndexImplementation lookup(String name) {
                assert (name != null) : "Null provider name supplied";
                IndexImplementation provider = (IndexImplementation)NeoStoreDataSource.this.indexProviders.get(name);
                if (provider == null) {
                    throw new IllegalArgumentException("No index provider '" + name + "' found. Maybe the intended provider (or one more of its " + "dependencies) " + "aren't on the classpath or it failed to load.");
                }
                return provider;
            }

            @Override
            public Iterable<IndexImplementation> providers() {
                return NeoStoreDataSource.this.indexProviders.values();
            }
        };
        this.commitProcessFactory = commitProcessFactory;
        this.pageCache = pageCache;
    }

    @Override
    public void init() {
    }

    @Override
    public void start() throws IOException {
        this.dependencies = new Dependencies();
        this.life = new LifeSupport();
        this.storeDir = this.config.get(Configuration.store_dir);
        File store = this.config.get(Configuration.neo_store);
        if (!this.storeFactory.storeExists()) {
            this.storeFactory.createNeoStore().close();
        }
        this.indexProvider = this.dependencyResolver.resolveDependency(SchemaIndexProvider.class, SchemaIndexProvider.HIGHEST_PRIORITIZED_OR_NONE);
        this.storeMigrationProcess.addParticipant(this.indexProvider.storeMigrationParticipant());
        DefaultSchemaIndexProviderMap providerMap = new DefaultSchemaIndexProviderMap(this.indexProvider);
        this.storeMigrationProcess.migrateIfNeeded(store.getParentFile(), this.indexProvider, this.pageCache);
        this.neoStore = this.dependencies.satisfyDependency(this.storeFactory.newNeoStore(false, true));
        this.dependencies.satisfyDependency(this.neoStore);
        this.schemaCache = new SchemaCache(Collections.emptyList());
        this.nodeCache = new AutoLoadingCache<NodeImpl>(this.cacheProvider.node(), CacheLoaders.nodeLoader(this.neoStore.getNodeStore()));
        this.relationshipCache = new AutoLoadingCache<RelationshipImpl>(this.cacheProvider.relationship(), CacheLoaders.relationshipLoader(this.neoStore.getRelationshipStore()));
        RelationshipLoader relationshipLoader = new RelationshipLoader(this.lockService, this.relationshipCache, new RelationshipChainLoader(this.neoStore));
        PersistenceCache persistenceCache = new PersistenceCache(this.nodeCache, this.relationshipCache, this.nodeManager, relationshipLoader, this.propertyKeyTokenHolder, this.relationshipTypeTokens, this.labelTokens, this.nodeManager);
        BridgingCacheAccess cacheAccess = new BridgingCacheAccess(this.schemaCache, this.updateableSchemaState, persistenceCache);
        try {
            this.indexingService = IndexingService.create(new IndexSamplingConfig(this.config), this.scheduler, providerMap, new NeoStoreIndexStoreView(this.lockService, this.neoStore), this.tokenNameLookup, this.updateableSchemaState, this.indexRuleLoader(), this.logging, this.indexingServiceMonitor);
            IntegrityValidator integrityValidator = new IntegrityValidator(this.neoStore, this.indexingService);
            this.labelScanStore = this.dependencyResolver.resolveDependency(LabelScanStoreProvider.class, LabelScanStoreProvider.HIGHEST_PRIORITIZED).getLabelScanStore();
            this.fileListing = new NeoStoreFileListing(this.storeDir, this.labelScanStore, this.indexingService, this.legacyIndexProviderLookup);
            Provider<NeoStore> neoStoreProvider = new Provider<NeoStore>(){

                @Override
                public NeoStore instance() {
                    return NeoStoreDataSource.this.getNeoStore();
                }
            };
            this.storeLayer = this.config.get(GraphDatabaseSettings.cache_type).equals("experimental-off") ? new DiskLayer(this.propertyKeyTokenHolder, this.labelTokens, this.relationshipTypeTokens, new SchemaStorage(this.neoStore.getSchemaStore()), neoStoreProvider, this.indexingService) : new CacheLayer(new DiskLayer(this.propertyKeyTokenHolder, this.labelTokens, this.relationshipTypeTokens, new SchemaStorage(this.neoStore.getSchemaStore()), neoStoreProvider, this.indexingService), persistenceCache, this.indexingService, this.schemaCache);
            LegacyPropertyTrackers legacyPropertyTrackers = new LegacyPropertyTrackers(this.propertyKeyTokenHolder, this.nodeManager.getNodePropertyTrackers(), this.nodeManager.getRelationshipPropertyTrackers(), this.nodeManager);
            NeoStoreTransactionContextSupplier neoStoreTransactionContextSupplier = new NeoStoreTransactionContextSupplier(this.neoStore);
            TransactionHooks hooks = new TransactionHooks();
            File directory = this.config.get(GraphDatabaseSettings.store_dir);
            TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache(1000, 100000);
            PhysicalLogFiles logFiles = new PhysicalLogFiles(directory, "neostore.transaction.db", this.fs);
            PhysicalLogFileInformation.SPI logInformation = new PhysicalLogFileInformation.SPI(){

                @Override
                public long getTimestampForVersion(long version) throws IOException {
                    LogPosition position = new LogPosition(version, 16L);
                    try (ReadableVersionableLogChannel channel = NeoStoreDataSource.this.logFile.getReader(position);){
                        LogEntry entry;
                        LogEntryReader reader = new LogEntryReaderFactory().versionable();
                        while ((entry = reader.readLogEntry(channel)) != null) {
                            if (!(entry instanceof LogEntryStart)) continue;
                            long l = ((LogEntryStart)entry.as()).getTimeWritten();
                            return l;
                        }
                    }
                    return -1L;
                }
            };
            LogFileInformation logFileInformation = this.dependencies.satisfyDependency(new PhysicalLogFileInformation(logFiles, transactionMetadataCache, this.neoStore, logInformation));
            LogPruneStrategy logPruneStrategy = LogPruneStrategyFactory.fromConfigValue(this.fs, logFileInformation, logFiles, this.neoStore, this.config.get(GraphDatabaseSettings.keep_logical_logs));
            SynchronizedArrayIdOrderingQueue legacyIndexTransactionOrdering = new SynchronizedArrayIdOrderingQueue(20);
            TransactionRepresentationStoreApplier storeApplier = this.dependencies.satisfyDependency(new TransactionRepresentationStoreApplier(this.indexingService, this.labelScanStore, this.neoStore, cacheAccess, this.lockService, this.legacyIndexProviderLookup, this.indexConfigStore, legacyIndexTransactionOrdering));
            LoggingLogFileMonitor loggingLogMonitor = new LoggingLogFileMonitor(this.logging.getMessagesLog(this.getClass()));
            TransactionRepresentationStoreApplier storeRecoverer = new TransactionRepresentationStoreApplier(this.indexingService, this.labelScanStore, this.neoStore, cacheAccess, this.lockService, this.legacyIndexProviderLookup, this.indexConfigStore, IdOrderingQueue.BYPASS);
            this.monitors.addMonitorListener(loggingLogMonitor, new String[0]);
            RecoveryVisitor recoveryVisitor = new RecoveryVisitor(this.neoStore, storeRecoverer, this.recoveredCount, loggingLogMonitor);
            LogEntryReader<ReadableVersionableLogChannel> logEntryReader = new LogEntryReaderFactory().versionable();
            LogFileRecoverer logFileRecoverer = new LogFileRecoverer(logEntryReader, recoveryVisitor);
            this.logFile = this.dependencies.satisfyDependency(new PhysicalLogFile(this.fs, logFiles, this.config.get(GraphDatabaseSettings.logical_log_rotation_threshold), logPruneStrategy, this.neoStore, this.neoStore, this.physicalLogMonitor, this, transactionMetadataCache, logFileRecoverer));
            LogicalTransactionStore logicalTransactionStore = this.dependencies.satisfyDependency(new PhysicalLogicalTransactionStore(this.logFile, transactionMetadataCache, this.neoStore, legacyIndexTransactionOrdering, this.config.get(GraphDatabaseSettings.batched_writes)));
            TransactionCommitProcess transactionCommitProcess = this.dependencies.satisfyDependency(this.commitProcessFactory.create(logicalTransactionStore, this.kernelHealth, this.neoStore, storeApplier, new NeoStoreInjectedTransactionValidator(integrityValidator), TransactionApplicationMode.INTERNAL, this.config));
            Provider<KernelAPI> kernelProvider = new Provider<KernelAPI>(){

                @Override
                public KernelAPI instance() {
                    return NeoStoreDataSource.this.kernel;
                }
            };
            ConstraintIndexCreator constraintIndexCreator = new ConstraintIndexCreator(kernelProvider, this.indexingService);
            LegacyIndexStore legacyIndexStore = new LegacyIndexStore(this.config, this.indexConfigStore, kernelProvider, this.legacyIndexProviderLookup);
            StatementOperationParts statementOperations = this.buildStatementOperations(this.storeLayer, legacyPropertyTrackers, constraintIndexCreator, this.updateableSchemaState, this.guard, legacyIndexStore);
            this.kernelTransactions = this.life.add(new KernelTransactions(neoStoreTransactionContextSupplier, this.neoStore, this.locks, integrityValidator, constraintIndexCreator, this.indexingService, this.labelScanStore, statementOperations, this.updateableSchemaState, this.schemaWriteGuard, providerMap, this.transactionHeaderInformationFactory, persistenceCache, this.storeLayer, transactionCommitProcess, this.indexConfigStore, this.legacyIndexProviderLookup, hooks, this.transactionMonitor, this.life));
            this.kernel = new Kernel(this.kernelTransactions, hooks, this.kernelHealth, this.transactionMonitor);
            this.life.add(this.logFile);
            this.life.add(logicalTransactionStore);
            this.life.add(new LifecycleAdapter(){

                @Override
                public void start() throws Throwable {
                    NeoStoreDataSource.this.startupStatistics.setNumberOfRecoveredTransactions(NeoStoreDataSource.this.recoveredCount.get());
                    NeoStoreDataSource.this.recoveredCount.set(0);
                    NeoStoreDataSource.this.loadSchemaCache();
                }
            });
            this.life.add(new LifecycleAdapter(){

                @Override
                public void start() {
                    if (NeoStoreDataSource.this.startupStatistics.numberOfRecoveredTransactions() > 0) {
                        NeoStoreDataSource.this.neoStore.rebuildIdGenerators();
                    }
                    NeoStoreDataSource.this.neoStore.makeStoreOk();
                }
            });
            this.life.add(this.indexingService);
            this.life.add(this.labelScanStore);
            this.kernel.registerTransactionHook(this.transactionEventHandlers);
            this.life.start();
            this.propertyKeyTokenHolder.addTokens(this.neoStore.getPropertyKeyTokenStore().getTokens(Integer.MAX_VALUE));
            this.relationshipTypeTokens.addTokens(this.neoStore.getRelationshipTypeTokenStore().getTokens(Integer.MAX_VALUE));
            this.labelTokens.addTokens(this.neoStore.getLabelTokenStore().getTokens(Integer.MAX_VALUE));
        }
        catch (Throwable e) {
            try {
                this.neoStore.close();
            }
            catch (Exception closeException) {
                this.msgLog.logMessage("Couldn't close neostore after startup failure");
            }
            throw Exceptions.launderedException(e);
        }
    }

    private void loadSchemaCache() {
        this.schemaCache.clear();
        for (SchemaRule schemaRule : IteratorUtil.loop(this.neoStore.getSchemaStore().loadAllSchemaRules())) {
            this.schemaCache.addSchemaRule(schemaRule);
        }
    }

    private Iterable<IndexRule> indexRuleLoader() {
        return new Iterable<IndexRule>(){

            @Override
            public Iterator<IndexRule> iterator() {
                return new SchemaStorage(NeoStoreDataSource.this.neoStore.getSchemaStore()).allIndexRules();
            }
        };
    }

    public NeoStore getNeoStore() {
        return this.neoStore;
    }

    public IndexingService getIndexService() {
        return this.indexingService;
    }

    public SchemaIndexProvider getIndexProvider() {
        return this.indexProvider;
    }

    public LabelScanStore getLabelScanStore() {
        return this.labelScanStore;
    }

    public LockService getLockService() {
        return this.lockService;
    }

    @Override
    public void stop() {
        this.forceEverything();
        this.life.shutdown();
        this.neoStore.close();
        this.msgLog.info("NeoStore closed");
    }

    @Override
    public void forceEverything() {
        this.indexingService.flushAll();
        this.labelScanStore.force();
        for (IndexImplementation index : this.indexProviders.values()) {
            index.force();
        }
        this.neoStore.flush();
    }

    @Override
    public void shutdown() {
    }

    public StoreId getStoreId() {
        return this.neoStore.getStoreId();
    }

    public String getStoreDir() {
        return this.storeDir.getPath();
    }

    public long getCreationTime() {
        return this.neoStore.getCreationTime();
    }

    public long getRandomIdentifier() {
        return this.neoStore.getRandomNumber();
    }

    public long getCurrentLogVersion() {
        return this.neoStore.getCurrentLogVersion();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public KernelAPI getKernel() {
        return this.kernel;
    }

    public ResourceIterator<File> listStoreFiles() throws IOException {
        return this.fileListing.listStoreFiles();
    }

    public void registerDiagnosticsWith(DiagnosticsManager manager) {
        manager.registerAll(Diagnostics.class, this);
    }

    @Override
    public NeoStore evaluate() {
        return this.neoStore;
    }

    public StoreReadLayer getStoreLayer() {
        return this.storeLayer;
    }

    @Override
    public void awaitAllTransactionsClosed() {
        while (!this.neoStore.closedTransactionIdIsOnParWithCommittedTransactionId()) {
            LockSupport.parkNanos(1000000L);
        }
    }

    public Cache<NodeImpl> getNodeCache() {
        return this.nodeCache;
    }

    public Cache<RelationshipImpl> getRelationshipCache() {
        return this.relationshipCache;
    }

    public DependencyResolver getDependencyResolver() {
        return this.dependencies;
    }

    private StatementOperationParts buildStatementOperations(StoreReadLayer storeReadLayer, LegacyPropertyTrackers legacyPropertyTrackers, ConstraintIndexCreator constraintIndexCreator, UpdateableSchemaState updateableSchemaState, Guard guard, LegacyIndexStore legacyIndexStore) {
        StateHandlingStatementOperations stateHandlingContext = new StateHandlingStatementOperations(storeReadLayer, legacyPropertyTrackers, constraintIndexCreator, legacyIndexStore);
        StatementOperationParts parts = new StatementOperationParts(stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, new SchemaStateConcern(updateableSchemaState), null, stateHandlingContext, stateHandlingContext, stateHandlingContext);
        ConstraintEnforcingEntityOperations constraintEnforcingEntityOperations = new ConstraintEnforcingEntityOperations(parts.entityWriteOperations(), parts.entityReadOperations(), parts.schemaReadOperations());
        DataIntegrityValidatingStatementOperations dataIntegrityContext = new DataIntegrityValidatingStatementOperations(parts.keyWriteOperations(), parts.schemaReadOperations(), parts.schemaWriteOperations());
        parts = parts.override(null, dataIntegrityContext, constraintEnforcingEntityOperations, constraintEnforcingEntityOperations, null, dataIntegrityContext, null, null, null, null, null);
        LockingStatementOperations lockingContext = new LockingStatementOperations(parts.entityReadOperations(), parts.entityWriteOperations(), parts.schemaReadOperations(), parts.schemaWriteOperations(), parts.schemaStateOperations());
        parts = parts.override(null, null, null, lockingContext, lockingContext, lockingContext, lockingContext, lockingContext, null, null, null);
        if (guard != null) {
            GuardingStatementOperations guardingOperations = new GuardingStatementOperations(parts.entityWriteOperations(), parts.entityReadOperations(), guard);
            parts = parts.override(null, null, guardingOperations, guardingOperations, null, null, null, null, null, null, null);
        }
        return parts;
    }

    @Override
    public void registerIndexProvider(String name, IndexImplementation index) {
        assert (!this.indexProviders.containsKey(name)) : "Index provider '" + name + "' already registered";
        this.indexProviders.put(name, index);
    }

    @Override
    public boolean unregisterIndexProvider(String name) {
        IndexImplementation removed = this.indexProviders.remove(name);
        return removed != null;
    }

    public void afterModeSwitch() {
        this.loadSchemaCache();
        this.kernelTransactions.disposeAll();
    }

    public static abstract class Configuration {
        public static final Setting<String> keep_logical_logs = GraphDatabaseSettings.keep_logical_logs;
        public static final Setting<Boolean> read_only = GraphDatabaseSettings.read_only;
        public static final Setting<File> store_dir = InternalAbstractGraphDatabase.Configuration.store_dir;
        public static final Setting<File> neo_store = InternalAbstractGraphDatabase.Configuration.neo_store;
    }

    private static enum Diagnostics implements DiagnosticsExtractor<NeoStoreDataSource>
    {
        NEO_STORE_VERSIONS("Store versions:"){

            @Override
            void dump(NeoStoreDataSource source, StringLogger.LineLogger log) {
                source.neoStore.logVersions(log);
            }
        }
        ,
        NEO_STORE_ID_USAGE("Id usage:"){

            @Override
            void dump(NeoStoreDataSource source, StringLogger.LineLogger log) {
                source.neoStore.logIdUsage(log);
            }
        };

        private final String message;

        private Diagnostics(String message) {
            this.message = message;
        }

        @Override
        public void dumpDiagnostics(final NeoStoreDataSource source, DiagnosticsPhase phase, StringLogger log) {
            if (this.applicable(phase)) {
                log.logLongMessage(this.message, new Visitor<StringLogger.LineLogger, RuntimeException>(){

                    @Override
                    public boolean visit(StringLogger.LineLogger logger) {
                        Diagnostics.this.dump(source, logger);
                        return false;
                    }
                }, true);
            }
        }

        boolean applicable(DiagnosticsPhase phase) {
            return phase.isInitialization() || phase.isExplicitlyRequested();
        }

        abstract void dump(NeoStoreDataSource var1, StringLogger.LineLogger var2);
    }
}

