/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.impl.nioneo.xa.command.LogHandler;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;

public class LogFilter
implements LogHandler {
    private final Function<List<LogEntry>, List<LogEntry>> interceptor;
    private final LogHandler delegate;
    private final List<LogEntry> logEntries;

    public LogFilter(Function<List<LogEntry>, List<LogEntry>> interceptor, LogHandler delegate) {
        this.interceptor = interceptor;
        this.delegate = delegate;
        this.logEntries = new ArrayList<LogEntry>();
    }

    @Override
    public void startLog() {
        this.logEntries.clear();
    }

    @Override
    public void startEntry(LogEntry.Start startEntry) {
        this.logEntries.add(startEntry);
    }

    @Override
    public void prepareEntry(LogEntry.Prepare prepareEntry) {
        this.logEntries.add(prepareEntry);
    }

    @Override
    public void onePhaseCommitEntry(LogEntry.OnePhaseCommit onePhaseCommitEntry) {
        this.logEntries.add(onePhaseCommitEntry);
    }

    @Override
    public void twoPhaseCommitEntry(LogEntry.TwoPhaseCommit twoPhaseCommitEntry) {
        this.logEntries.add(twoPhaseCommitEntry);
    }

    @Override
    public void doneEntry(LogEntry.Done doneEntry) {
        this.logEntries.add(doneEntry);
    }

    @Override
    public void commandEntry(LogEntry.Command commandEntry) {
        this.logEntries.add(commandEntry);
    }

    @Override
    public void endLog(boolean success) throws IOException {
        List<LogEntry> filtered = this.interceptor.apply(this.logEntries);
        this.delegate.startLog();
        for (LogEntry entry : filtered) {
            entry.accept(this.delegate);
        }
        this.delegate.endLog(success);
        this.logEntries.clear();
    }
}

