/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.primitive.PrimitiveLongPredicate;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Resource;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TxState;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.TransactionalException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.PropertyKeyIdIterator;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.LegacyPropertyTrackers;
import org.neo4j.kernel.impl.api.operations.EntityOperations;
import org.neo4j.kernel.impl.api.operations.KeyReadOperations;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.nioneo.store.SchemaStorage;
import org.neo4j.kernel.impl.util.DiffSets;
import org.neo4j.kernel.impl.util.PrimitiveLongResourceIterator;

public class StateHandlingStatementOperations
implements KeyReadOperations,
KeyWriteOperations,
EntityOperations,
SchemaReadOperations,
SchemaWriteOperations {
    private final StoreReadLayer storeLayer;
    private final LegacyPropertyTrackers legacyPropertyTrackers;
    private final ConstraintIndexCreator constraintIndexCreator;

    public StateHandlingStatementOperations(StoreReadLayer storeLayer, LegacyPropertyTrackers propertyTrackers, ConstraintIndexCreator constraintIndexCreator) {
        this.storeLayer = storeLayer;
        this.legacyPropertyTrackers = propertyTrackers;
        this.constraintIndexCreator = constraintIndexCreator;
    }

    @Override
    public long nodeCreate(KernelStatement statement) {
        return statement.txState().nodeDoCreate();
    }

    @Override
    public void nodeDelete(KernelStatement state, long nodeId) throws EntityNotFoundException {
        this.assertNodeExists(state, nodeId);
        this.legacyPropertyTrackers.nodeDelete(nodeId);
        state.txState().nodeDoDelete(nodeId);
    }

    private void assertNodeExists(KernelStatement state, long nodeId) throws EntityNotFoundException {
        if (!this.nodeExists(state, nodeId)) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId);
        }
    }

    private boolean nodeExists(KernelStatement state, long nodeId) {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().nodeIsDeletedInThisTx(nodeId)) {
                return false;
            }
            if (state.txState().nodeIsAddedInThisTx(nodeId)) {
                return true;
            }
        }
        return this.storeLayer.nodeExists(nodeId);
    }

    @Override
    public long relationshipCreate(KernelStatement state, int relationshipTypeId, long startNodeId, long endNodeId) {
        long id = state.txState().relationshipDoCreate(relationshipTypeId, startNodeId, endNodeId);
        state.neoStoreTransaction.relationshipCreate(id, relationshipTypeId, startNodeId, endNodeId);
        return id;
    }

    @Override
    public void relationshipDelete(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        this.assertRelationshipExists(state, relationshipId);
        this.legacyPropertyTrackers.relationshipDelete(relationshipId);
        final TxState txState = state.txState();
        if (txState.relationshipIsAddedInThisTx(relationshipId)) {
            txState.relationshipDoDeleteAddedInThisTx(relationshipId);
        } else {
            try {
                this.storeLayer.visit(relationshipId, new StoreReadLayer.RelationshipVisitor(){

                    @Override
                    public void visit(long relId, long startNode, long endNode, int type) {
                        txState.relationshipDoDelete(relId, startNode, endNode, type);
                    }
                });
            }
            catch (EntityNotFoundException e) {
                return;
            }
        }
    }

    private void assertRelationshipExists(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        if (!this.relationshipExists(state, relationshipId)) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId);
        }
    }

    private boolean relationshipExists(KernelStatement state, long relationshipId) {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().relationshipIsDeletedInThisTx(relationshipId)) {
                return false;
            }
            if (state.txState().relationshipIsAddedInThisTx(relationshipId)) {
                return true;
            }
        }
        return this.storeLayer.relationshipExists(relationshipId);
    }

    @Override
    public boolean nodeHasLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().nodeIsDeletedInThisTx(nodeId)) {
                return false;
            }
            if (state.txState().nodeIsAddedInThisTx(nodeId)) {
                TxState.UpdateTriState labelState = state.txState().labelState(nodeId, labelId);
                return labelState.isTouched() && labelState.isAdded();
            }
            TxState.UpdateTriState labelState = state.txState().labelState(nodeId, labelId);
            if (labelState.isTouched()) {
                return labelState.isAdded();
            }
        }
        return this.storeLayer.nodeHasLabel(nodeId, labelId);
    }

    @Override
    public PrimitiveIntIterator nodeGetLabels(KernelStatement state, long nodeId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().nodeIsDeletedInThisTx(nodeId)) {
                return PrimitiveIntCollections.emptyIterator();
            }
            if (state.txState().nodeIsAddedInThisTx(nodeId)) {
                return PrimitiveIntCollections.toPrimitiveIterator(state.txState().nodeStateLabelDiffSets(nodeId).getAdded().iterator());
            }
            return state.txState().nodeStateLabelDiffSets(nodeId).augment(this.storeLayer.nodeGetLabels(nodeId));
        }
        return this.storeLayer.nodeGetLabels(nodeId);
    }

    @Override
    public PrimitiveIntIterator nodeGetCommittedLabels(KernelStatement state, long nodeId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges() && state.txState().nodeIsAddedInThisTx(nodeId)) {
            return PrimitiveIntCollections.emptyIterator();
        }
        return this.storeLayer.nodeGetLabels(nodeId);
    }

    @Override
    public boolean nodeAddLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        if (this.nodeHasLabel(state, nodeId, labelId)) {
            return false;
        }
        state.txState().nodeDoAddLabel(labelId, nodeId);
        Iterator<DefinedProperty> properties = this.nodeGetAllProperties(state, nodeId);
        while (properties.hasNext()) {
            DefinedProperty property = properties.next();
            this.indexUpdateProperty(state, nodeId, labelId, property.propertyKeyId(), null, property);
        }
        return true;
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        if (!this.nodeHasLabel(state, nodeId, labelId)) {
            return false;
        }
        state.txState().nodeDoRemoveLabel(labelId, nodeId);
        Iterator<DefinedProperty> properties = this.nodeGetAllProperties(state, nodeId);
        while (properties.hasNext()) {
            DefinedProperty property = properties.next();
            this.indexUpdateProperty(state, nodeId, labelId, property.propertyKeyId(), property, null);
        }
        return true;
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        if (state.hasTxStateWithChanges()) {
            PrimitiveLongIterator wLabelChanges = state.txState().nodesWithLabelChanged(labelId).augment(this.storeLayer.nodesGetForLabel(state, labelId));
            return state.txState().addedAndRemovedNodes().augmentWithRemovals(wLabelChanges);
        }
        return this.storeLayer.nodesGetForLabel(state, labelId);
    }

    @Override
    public IndexDescriptor indexCreate(KernelStatement state, int labelId, int propertyKey) {
        IndexDescriptor rule = new IndexDescriptor(labelId, propertyKey);
        state.txState().indexRuleDoAdd(rule);
        return rule;
    }

    @Override
    public void indexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        state.txState().indexDoDrop(descriptor);
    }

    @Override
    public void uniqueIndexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        state.txState().constraintIndexDoDrop(descriptor);
    }

    @Override
    public UniquenessConstraint uniquenessConstraintCreate(KernelStatement state, int labelId, int propertyKeyId) throws CreateConstraintFailureException {
        UniquenessConstraint constraint = new UniquenessConstraint(labelId, propertyKeyId);
        try {
            IndexDescriptor index = new IndexDescriptor(labelId, propertyKeyId);
            if (state.txState().constraintIndexDoUnRemove(index)) {
                state.txState().constraintIndexDiffSetsByLabel(labelId).unRemove(index);
                if (!state.txState().constraintDoUnRemove(constraint)) {
                    state.txState().constraintsChangesForLabel(labelId).unRemove(constraint);
                    state.txState().constraintDoAdd(constraint, state.txState().indexCreatedForConstraint(constraint));
                }
            } else {
                Iterator<UniquenessConstraint> it = this.storeLayer.constraintsGetForLabelAndPropertyKey(labelId, propertyKeyId);
                while (it.hasNext()) {
                    if (!it.next().equals(labelId, propertyKeyId)) continue;
                    return constraint;
                }
                long indexId = this.constraintIndexCreator.createUniquenessConstraintIndex(state, this, labelId, propertyKeyId);
                state.txState().constraintDoAdd(constraint, indexId);
            }
            return constraint;
        }
        catch (TransactionalException | ConstraintVerificationFailedKernelException | DropIndexFailureException e) {
            throw new CreateConstraintFailureException(constraint, (Throwable)e);
        }
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKeyId) {
        return this.applyConstraintsDiff(state, this.storeLayer.constraintsGetForLabelAndPropertyKey(labelId, propertyKeyId), labelId, propertyKeyId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(KernelStatement state, int labelId) {
        return this.applyConstraintsDiff(state, this.storeLayer.constraintsGetForLabel(labelId), labelId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll(KernelStatement state) {
        return this.applyConstraintsDiff(state, this.storeLayer.constraintsGetAll());
    }

    private Iterator<UniquenessConstraint> applyConstraintsDiff(KernelStatement state, Iterator<UniquenessConstraint> constraints, int labelId, int propertyKeyId) {
        DiffSets<UniquenessConstraint> diff;
        if (state.hasTxStateWithChanges() && (diff = state.txState().constraintsChangesForLabelAndProperty(labelId, propertyKeyId)) != null) {
            return diff.apply(constraints);
        }
        return constraints;
    }

    private Iterator<UniquenessConstraint> applyConstraintsDiff(KernelStatement state, Iterator<UniquenessConstraint> constraints, int labelId) {
        DiffSets<UniquenessConstraint> diff;
        if (state.hasTxStateWithChanges() && (diff = state.txState().constraintsChangesForLabel(labelId)) != null) {
            return diff.apply(constraints);
        }
        return constraints;
    }

    private Iterator<UniquenessConstraint> applyConstraintsDiff(KernelStatement state, Iterator<UniquenessConstraint> constraints) {
        DiffSets<UniquenessConstraint> diff;
        if (state.hasTxStateWithChanges() && (diff = state.txState().constraintsChanges()) != null) {
            return diff.apply(constraints);
        }
        return constraints;
    }

    @Override
    public void constraintDrop(KernelStatement state, UniquenessConstraint constraint) {
        state.txState().constraintDoDrop(constraint);
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKey) {
        IndexDescriptor indexDescriptor = this.storeLayer.indexesGetForLabelAndPropertyKey(labelId, propertyKey);
        Iterator<IndexDescriptor> committedRule = IteratorUtil.iterator(indexDescriptor);
        DiffSets<IndexDescriptor> ruleDiffSet = state.txState().indexDiffSetsByLabel(labelId);
        boolean hasTxStateWithChanges = state.hasTxStateWithChanges();
        Iterator<IndexDescriptor> rules = hasTxStateWithChanges ? this.filterByPropertyKeyId(ruleDiffSet.apply(committedRule), propertyKey) : committedRule;
        return IteratorUtil.singleOrNull(rules);
    }

    private Iterator<IndexDescriptor> filterByPropertyKeyId(Iterator<IndexDescriptor> descriptorIterator, final int propertyKey) {
        Predicate<IndexDescriptor> predicate = new Predicate<IndexDescriptor>(){

            @Override
            public boolean accept(IndexDescriptor item) {
                return item.getPropertyKeyId() == propertyKey;
            }
        };
        return Iterables.filter(predicate, descriptorIterator);
    }

    @Override
    public InternalIndexState indexGetState(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        if (state.hasTxStateWithChanges()) {
            if (this.checkIndexState(descriptor, state.txState().indexDiffSetsByLabel(descriptor.getLabelId()))) {
                return InternalIndexState.POPULATING;
            }
            if (this.checkIndexState(descriptor, state.txState().constraintIndexDiffSetsByLabel(descriptor.getLabelId()))) {
                return InternalIndexState.POPULATING;
            }
        }
        return this.storeLayer.indexGetState(descriptor);
    }

    private boolean checkIndexState(IndexDescriptor indexRule, DiffSets<IndexDescriptor> diffSet) throws IndexNotFoundKernelException {
        if (diffSet.isAdded(indexRule)) {
            return true;
        }
        if (diffSet.isRemoved(indexRule)) {
            throw new IndexNotFoundKernelException(String.format("Index for label id %d on property id %d has been dropped in this transaction.", indexRule.getLabelId(), indexRule.getPropertyKeyId()));
        }
        return false;
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(KernelStatement state, int labelId) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().indexDiffSetsByLabel(labelId).apply(this.storeLayer.indexesGetForLabel(labelId));
        }
        return this.storeLayer.indexesGetForLabel(labelId);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().indexChanges().apply(this.storeLayer.indexesGetAll());
        }
        return this.storeLayer.indexesGetAll();
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(KernelStatement state, int labelId) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintIndexDiffSetsByLabel(labelId).apply(this.storeLayer.uniqueIndexesGetForLabel(labelId));
        }
        return this.storeLayer.uniqueIndexesGetForLabel(labelId);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintIndexChanges().apply(this.storeLayer.uniqueIndexesGetAll());
        }
        return this.storeLayer.uniqueIndexesGetAll();
    }

    @Override
    public long nodeGetUniqueFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        PrimitiveLongResourceIterator committed = this.storeLayer.nodeGetUniqueFromIndexLookup(state, index, value);
        PrimitiveLongIterator exactMatches = this.filterExactIndexMatches(state, index, value, committed);
        PrimitiveLongIterator changeFilteredMatches = this.filterIndexStateChanges(state, index, value, exactMatches);
        return PrimitiveLongCollections.single((PrimitiveLongIterator)IteratorUtil.resourceIterator(changeFilteredMatches, (Resource)committed), (long)-1L);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        PrimitiveLongResourceIterator committed = this.storeLayer.nodesGetFromIndexLookup(state, index, value);
        PrimitiveLongIterator exactMatches = this.filterExactIndexMatches(state, index, value, committed);
        PrimitiveLongIterator changeFilteredMatches = this.filterIndexStateChanges(state, index, value, exactMatches);
        return IteratorUtil.resourceIterator(changeFilteredMatches, (Resource)committed);
    }

    private PrimitiveLongIterator filterExactIndexMatches(KernelStatement state, IndexDescriptor index, Object value, PrimitiveLongIterator committed) {
        if (this.isNumberOrArray(value)) {
            return PrimitiveLongCollections.filter((PrimitiveLongIterator)committed, (PrimitiveLongPredicate)this.exactMatch(state, index.getPropertyKeyId(), value));
        }
        return committed;
    }

    private boolean isNumberOrArray(Object value) {
        return value instanceof Number || value.getClass().isArray();
    }

    private PrimitiveLongPredicate exactMatch(final KernelStatement state, final int propertyKeyId, final Object value) {
        return new PrimitiveLongPredicate(){

            public boolean accept(long nodeId) {
                try {
                    return StateHandlingStatementOperations.this.nodeGetProperty(state, nodeId, propertyKeyId).valueEquals(value);
                }
                catch (EntityNotFoundException e) {
                    throw new ThisShouldNotHappenError("Chris", "An index claims a node by id " + nodeId + " has the value. However, it looks like that node does not exist.", e);
                }
            }
        };
    }

    private PrimitiveLongIterator filterIndexStateChanges(KernelStatement state, IndexDescriptor index, Object value, PrimitiveLongIterator nodeIds) {
        if (state.hasTxStateWithChanges()) {
            DiffSets<Long> labelPropertyChanges = state.txState().indexUpdates(index, value);
            DiffSets<Long> nodes = state.txState().addedAndRemovedNodes();
            return nodes.augmentWithRemovals(labelPropertyChanges.augment(nodeIds));
        }
        return nodeIds;
    }

    @Override
    public Property nodeSetProperty(KernelStatement state, long nodeId, DefinedProperty property) throws EntityNotFoundException {
        Property existingProperty = this.nodeGetProperty(state, nodeId, property.propertyKeyId());
        if (!existingProperty.isDefined()) {
            this.legacyPropertyTrackers.nodeAddStoreProperty(nodeId, property);
        } else {
            this.legacyPropertyTrackers.nodeChangeStoreProperty(nodeId, (DefinedProperty)existingProperty, property);
        }
        state.txState().nodeDoReplaceProperty(nodeId, existingProperty, property);
        this.indexesUpdateProperty(state, nodeId, property.propertyKeyId(), existingProperty instanceof DefinedProperty ? (DefinedProperty)existingProperty : null, property);
        return existingProperty;
    }

    @Override
    public Property relationshipSetProperty(KernelStatement state, long relationshipId, DefinedProperty property) throws EntityNotFoundException {
        Property existingProperty = this.relationshipGetProperty(state, relationshipId, property.propertyKeyId());
        if (!existingProperty.isDefined()) {
            this.legacyPropertyTrackers.relationshipAddStoreProperty(relationshipId, property);
        } else {
            this.legacyPropertyTrackers.relationshipChangeStoreProperty(relationshipId, (DefinedProperty)existingProperty, property);
        }
        state.txState().relationshipDoReplaceProperty(relationshipId, existingProperty, property);
        return existingProperty;
    }

    @Override
    public Property graphSetProperty(KernelStatement state, DefinedProperty property) {
        Property existingProperty = this.graphGetProperty(state, property.propertyKeyId());
        state.txState().graphDoReplaceProperty(existingProperty, property);
        return existingProperty;
    }

    @Override
    public Property nodeRemoveProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        Property existingProperty = this.nodeGetProperty(state, nodeId, propertyKeyId);
        if (existingProperty.isDefined()) {
            this.legacyPropertyTrackers.nodeRemoveStoreProperty(nodeId, (DefinedProperty)existingProperty);
            state.txState().nodeDoRemoveProperty(nodeId, (DefinedProperty)existingProperty);
            this.indexesUpdateProperty(state, nodeId, propertyKeyId, (DefinedProperty)existingProperty, null);
        }
        return existingProperty;
    }

    @Override
    public Property relationshipRemoveProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        Property existingProperty = this.relationshipGetProperty(state, relationshipId, propertyKeyId);
        if (existingProperty.isDefined()) {
            this.legacyPropertyTrackers.relationshipRemoveStoreProperty(relationshipId, (DefinedProperty)existingProperty);
            state.txState().relationshipDoRemoveProperty(relationshipId, (DefinedProperty)existingProperty);
        }
        return existingProperty;
    }

    @Override
    public Property graphRemoveProperty(KernelStatement state, int propertyKeyId) {
        Property existingProperty = this.graphGetProperty(state, propertyKeyId);
        if (existingProperty.isDefined()) {
            state.txState().graphDoRemoveProperty((DefinedProperty)existingProperty);
        }
        return existingProperty;
    }

    private void indexesUpdateProperty(KernelStatement state, long nodeId, int propertyKey, DefinedProperty before, DefinedProperty after) throws EntityNotFoundException {
        PrimitiveIntIterator labels = this.nodeGetLabels(state, nodeId);
        while (labels.hasNext()) {
            this.indexUpdateProperty(state, nodeId, labels.next(), propertyKey, before, after);
        }
    }

    private void indexUpdateProperty(KernelStatement state, long nodeId, int labelId, int propertyKey, DefinedProperty before, DefinedProperty after) {
        IndexDescriptor descriptor = this.indexesGetForLabelAndPropertyKey(state, labelId, propertyKey);
        if (descriptor != null) {
            state.txState().indexUpdateProperty(descriptor, nodeId, before, after);
        }
    }

    @Override
    public PrimitiveLongIterator nodeGetPropertyKeys(KernelStatement state, long nodeId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            return new PropertyKeyIdIterator(this.nodeGetAllProperties(state, nodeId));
        }
        return this.storeLayer.nodeGetPropertyKeys(nodeId);
    }

    @Override
    public Property nodeGetProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            Iterator<DefinedProperty> properties = this.nodeGetAllProperties(state, nodeId);
            while (properties.hasNext()) {
                Property property = properties.next();
                if (property.propertyKeyId() != propertyKeyId) continue;
                return property;
            }
            return Property.noNodeProperty(nodeId, propertyKeyId);
        }
        return this.storeLayer.nodeGetProperty(nodeId, propertyKeyId);
    }

    @Override
    public Iterator<DefinedProperty> nodeGetAllProperties(KernelStatement state, long nodeId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().nodeIsAddedInThisTx(nodeId)) {
                return state.txState().addedAndChangedNodeProperties(nodeId);
            }
            if (state.txState().nodeIsDeletedInThisTx(nodeId)) {
                throw new IllegalStateException("Node " + nodeId + " has been deleted");
            }
            return state.txState().augmentNodeProperties(nodeId, this.storeLayer.nodeGetAllProperties(nodeId));
        }
        return this.storeLayer.nodeGetAllProperties(nodeId);
    }

    @Override
    public Iterator<DefinedProperty> nodeGetAllCommittedProperties(KernelStatement statement, long nodeId) throws EntityNotFoundException {
        if (statement.hasTxStateWithChanges() && statement.txState().nodeIsAddedInThisTx(nodeId)) {
            return Collections.emptyIterator();
        }
        return this.storeLayer.nodeGetAllProperties(nodeId);
    }

    @Override
    public PrimitiveLongIterator relationshipGetPropertyKeys(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            return new PropertyKeyIdIterator(this.relationshipGetAllProperties(state, relationshipId));
        }
        return this.storeLayer.relationshipGetPropertyKeys(relationshipId);
    }

    @Override
    public Property relationshipGetProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            Iterator<DefinedProperty> properties = this.relationshipGetAllProperties(state, relationshipId);
            while (properties.hasNext()) {
                Property property = properties.next();
                if (property.propertyKeyId() != propertyKeyId) continue;
                return property;
            }
            return Property.noRelationshipProperty(relationshipId, propertyKeyId);
        }
        return this.storeLayer.relationshipGetProperty(relationshipId, propertyKeyId);
    }

    @Override
    public Property nodeGetCommittedProperty(KernelStatement statement, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        if (statement.hasTxStateWithChanges() && statement.txState().nodeIsAddedInThisTx(nodeId)) {
            return Property.noNodeProperty(nodeId, propertyKeyId);
        }
        return this.storeLayer.nodeGetProperty(nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipGetCommittedProperty(KernelStatement statement, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        if (statement.hasTxStateWithChanges() && statement.txState().relationshipIsAddedInThisTx(relationshipId)) {
            return Property.noRelationshipProperty(relationshipId, propertyKeyId);
        }
        return this.storeLayer.relationshipGetProperty(relationshipId, propertyKeyId);
    }

    @Override
    public Iterator<DefinedProperty> relationshipGetAllProperties(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().relationshipIsAddedInThisTx(relationshipId)) {
                return state.txState().addedAndChangedRelProperties(relationshipId);
            }
            if (state.txState().relationshipIsDeletedInThisTx(relationshipId)) {
                throw new IllegalStateException("Relationship " + relationshipId + " has been deleted");
            }
            return state.txState().augmentRelProperties(relationshipId, this.storeLayer.relationshipGetAllProperties(relationshipId));
        }
        return this.storeLayer.relationshipGetAllProperties(relationshipId);
    }

    @Override
    public Iterator<DefinedProperty> relationshipGetAllCommittedProperties(KernelStatement statement, long relId) throws EntityNotFoundException {
        if (statement.hasTxStateWithChanges() && statement.txState().relationshipIsAddedInThisTx(relId)) {
            return Collections.emptyIterator();
        }
        return this.storeLayer.relationshipGetAllProperties(relId);
    }

    @Override
    public PrimitiveLongIterator graphGetPropertyKeys(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return new PropertyKeyIdIterator(this.graphGetAllProperties(state));
        }
        return this.storeLayer.graphGetPropertyKeys(state);
    }

    @Override
    public Property graphGetProperty(KernelStatement state, int propertyKeyId) {
        Iterator<DefinedProperty> properties = this.graphGetAllProperties(state);
        while (properties.hasNext()) {
            Property property = properties.next();
            if (property.propertyKeyId() != propertyKeyId) continue;
            return property;
        }
        return Property.noGraphProperty(propertyKeyId);
    }

    @Override
    public Iterator<DefinedProperty> graphGetAllProperties(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().augmentGraphProperties(this.storeLayer.graphGetAllProperties());
        }
        return this.storeLayer.graphGetAllProperties();
    }

    @Override
    public PrimitiveLongIterator nodeGetRelationships(KernelStatement state, long nodeId, Direction direction, int[] relTypes) throws EntityNotFoundException {
        relTypes = StateHandlingStatementOperations.deduplicate(relTypes);
        if (state.hasTxStateWithChanges()) {
            TxState txState = state.txState();
            PrimitiveLongIterator stored = txState.nodeIsAddedInThisTx(nodeId) ? PrimitiveLongCollections.emptyIterator() : this.storeLayer.nodeListRelationships(nodeId, direction, relTypes);
            return txState.augmentRelationships(nodeId, direction, relTypes, stored);
        }
        return this.storeLayer.nodeListRelationships(nodeId, direction, relTypes);
    }

    @Override
    public PrimitiveLongIterator nodeGetRelationships(KernelStatement state, long nodeId, Direction direction) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            TxState txState = state.txState();
            PrimitiveLongIterator stored = txState.nodeIsAddedInThisTx(nodeId) ? PrimitiveLongCollections.emptyIterator() : this.storeLayer.nodeListRelationships(state, nodeId, direction);
            return txState.augmentRelationships(nodeId, direction, stored);
        }
        return this.storeLayer.nodeListRelationships(state, nodeId, direction);
    }

    @Override
    public int nodeGetDegree(KernelStatement state, long nodeId, Direction direction, int relType) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            int degree = 0;
            if (state.txState().nodeIsDeletedInThisTx(nodeId)) {
                return 0;
            }
            if (!state.txState().nodeIsAddedInThisTx(nodeId)) {
                degree = this.storeLayer.nodeGetDegree(nodeId, direction, relType);
            }
            return state.txState().augmentNodeDegree(nodeId, degree, direction, relType);
        }
        return this.storeLayer.nodeGetDegree(nodeId, direction, relType);
    }

    @Override
    public int nodeGetDegree(KernelStatement state, long nodeId, Direction direction) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            int degree = 0;
            if (state.txState().nodeIsDeletedInThisTx(nodeId)) {
                return 0;
            }
            if (!state.txState().nodeIsAddedInThisTx(nodeId)) {
                degree = this.storeLayer.nodeGetDegree(nodeId, direction);
            }
            return state.txState().augmentNodeDegree(nodeId, degree, direction);
        }
        return this.storeLayer.nodeGetDegree(nodeId, direction);
    }

    @Override
    public PrimitiveIntIterator nodeGetRelationshipTypes(KernelStatement statement, long nodeId) throws EntityNotFoundException {
        if (statement.hasTxStateWithChanges() && statement.txState().nodeModifiedInThisTx(nodeId)) {
            TxState tx = statement.txState();
            if (tx.nodeIsDeletedInThisTx(nodeId)) {
                return PrimitiveIntCollections.emptyIterator();
            }
            if (tx.nodeIsAddedInThisTx(nodeId)) {
                return tx.nodeRelationshipTypes(nodeId);
            }
            HashSet<Integer> types = new HashSet<Integer>();
            PrimitiveIntIterator typesInTx = tx.nodeRelationshipTypes(nodeId);
            while (typesInTx.hasNext()) {
                types.add(typesInTx.next());
            }
            PrimitiveIntIterator committedTypes = this.storeLayer.nodeGetRelationshipTypes(nodeId);
            while (committedTypes.hasNext()) {
                int current = committedTypes.next();
                if (types.contains(current) || this.nodeGetDegree(statement, nodeId, Direction.BOTH, current) <= 0) continue;
                types.add(current);
            }
            return PrimitiveIntCollections.toPrimitiveIterator(types.iterator());
        }
        return this.storeLayer.nodeGetRelationshipTypes(nodeId);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(KernelStatement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.storeLayer.indexGetOwningUniquenessConstraintId(index);
    }

    @Override
    public long indexGetCommittedId(KernelStatement state, IndexDescriptor index, SchemaStorage.IndexRuleKind kind) throws SchemaRuleNotFoundException {
        return this.storeLayer.indexGetCommittedId(index, kind);
    }

    @Override
    public String indexGetFailure(Statement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.storeLayer.indexGetFailure(descriptor);
    }

    @Override
    public int labelGetForName(Statement state, String labelName) {
        return this.storeLayer.labelGetForName(labelName);
    }

    @Override
    public String labelGetName(Statement state, int labelId) throws LabelNotFoundKernelException {
        return this.storeLayer.labelGetName(labelId);
    }

    @Override
    public int propertyKeyGetForName(Statement state, String propertyKeyName) {
        return this.storeLayer.propertyKeyGetForName(propertyKeyName);
    }

    @Override
    public String propertyKeyGetName(Statement state, int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        return this.storeLayer.propertyKeyGetName(propertyKeyId);
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens(Statement state) {
        return this.storeLayer.propertyKeyGetAllTokens();
    }

    @Override
    public Iterator<Token> labelsGetAllTokens(Statement state) {
        return this.storeLayer.labelsGetAllTokens();
    }

    @Override
    public int relationshipTypeGetForName(Statement state, String relationshipTypeName) {
        return this.storeLayer.relationshipTypeGetForName(relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(Statement state, int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        return this.storeLayer.relationshipTypeGetName(relationshipTypeId);
    }

    @Override
    public int labelGetOrCreateForName(Statement state, String labelName) throws IllegalTokenNameException, TooManyLabelsException {
        return this.storeLayer.labelGetOrCreateForName(labelName);
    }

    @Override
    public int propertyKeyGetOrCreateForName(Statement state, String propertyKeyName) throws IllegalTokenNameException {
        return this.storeLayer.propertyKeyGetOrCreateForName(propertyKeyName);
    }

    @Override
    public int relationshipTypeGetOrCreateForName(Statement state, String relationshipTypeName) throws IllegalTokenNameException {
        return this.storeLayer.relationshipTypeGetOrCreateForName(relationshipTypeName);
    }

    private static int[] deduplicate(int[] types) {
        int unique = 0;
        for (int i = 0; i < types.length; ++i) {
            int type = types[i];
            for (int j = 0; j < unique; ++j) {
                if (type != types[j]) continue;
                type = -1;
                break;
            }
            if (type == -1) continue;
            types[unique++] = types[i];
        }
        if (unique < types.length) {
            types = Arrays.copyOf(types, unique);
        }
        return types;
    }
}

