/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Listeners;
import org.neo4j.helpers.collection.Iterables;

public class AvailabilityGuard {
    private Iterable<AvailabilityListener> listeners = Listeners.newListeners();
    private final AtomicInteger available;
    private final List<AvailabilityRequirement> blockingComponents = new CopyOnWriteArrayList<AvailabilityRequirement>();
    private final Clock clock;
    public static final Function<AvailabilityRequirement, String> DESCRIPTION = new Function<AvailabilityRequirement, String>(){

        @Override
        public String apply(AvailabilityRequirement availabilityRequirement) {
            return availabilityRequirement.description();
        }
    };

    public AvailabilityGuard(Clock clock) {
        this(clock, 0);
    }

    public AvailabilityGuard(Clock clock, int conditionCount) {
        this.clock = clock;
        this.available = new AtomicInteger(conditionCount);
    }

    public void deny(AvailabilityRequirement requirementNotMet) {
        int val;
        do {
            if ((val = this.available.get()) != -1) continue;
            return;
        } while (!this.available.compareAndSet(val, val + 1));
        this.blockingComponents.add(requirementNotMet);
        if (val == 0) {
            Listeners.notifyListeners(this.listeners, new Listeners.Notification<AvailabilityListener>(){

                @Override
                public void notify(AvailabilityListener listener) {
                    listener.unavailable();
                }
            });
        }
    }

    public void grant(AvailabilityRequirement requirementNowMet) {
        int val;
        do {
            if ((val = this.available.get()) != -1) continue;
            return;
        } while (!this.available.compareAndSet(val, val - 1));
        this.blockingComponents.remove(requirementNowMet);
        if (val == 1) {
            Listeners.notifyListeners(this.listeners, new Listeners.Notification<AvailabilityListener>(){

                @Override
                public void notify(AvailabilityListener listener) {
                    listener.available();
                }
            });
        }
    }

    public void shutdown() {
        int val = this.available.getAndSet(-1);
        if (val == 0) {
            Listeners.notifyListeners(this.listeners, new Listeners.Notification<AvailabilityListener>(){

                @Override
                public void notify(AvailabilityListener listener) {
                    listener.unavailable();
                }
            });
        }
    }

    public boolean isAvailable(long millis) {
        int val = this.available.get();
        if (val == 0) {
            return true;
        }
        if (val == -1) {
            return false;
        }
        long start = this.clock.currentTimeMillis();
        while (this.clock.currentTimeMillis() < start + millis) {
            val = this.available.get();
            if (val == 0) {
                return true;
            }
            if (val == -1) {
                return false;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                break;
            }
            Thread.yield();
        }
        return false;
    }

    public void addListener(AvailabilityListener listener) {
        this.listeners = Listeners.addListener(listener, this.listeners);
    }

    public void removeListener(AvailabilityListener listener) {
        this.listeners = Listeners.removeListener(listener, this.listeners);
    }

    public String describeWhoIsBlocking() {
        if (this.blockingComponents.size() > 0 || this.available.get() > 0) {
            String causes = Iterables.join(", ", Iterables.map(DESCRIPTION, this.blockingComponents));
            return this.available.get() + " reasons for blocking: " + causes + ".";
        }
        return "No blocking components";
    }

    public static interface AvailabilityRequirement {
        public String description();
    }

    public static interface AvailabilityListener {
        public void available();

        public void unavailable();
    }
}

