/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;

public class XaLogicalLogFiles {
    private static final String ACTIVE_FILE_SUFFIX = ".active";
    private static final String LOG_2_SUFFIX = ".2";
    private static final String LOG_1_SUFFIX = ".1";
    private File logBaseName;
    private FileSystemAbstraction fileSystem;

    public XaLogicalLogFiles(File fileName, FileSystemAbstraction fileSystem) {
        this.logBaseName = fileName;
        this.fileSystem = fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State determineState() throws IOException {
        File activeFileName = new File(this.logBaseName.getPath() + ACTIVE_FILE_SUFFIX);
        if (!this.fileSystem.fileExists(activeFileName)) {
            if (this.fileSystem.fileExists(this.logBaseName)) {
                return State.LEGACY_WITHOUT_LOG_ROTATION;
            }
            return State.NO_ACTIVE_FILE;
        }
        StoreChannel fc = null;
        byte[] bytes = new byte[256];
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        int read = 0;
        try {
            fc = this.fileSystem.open(activeFileName, "rw");
            read = fc.read(buf);
        }
        finally {
            if (fc != null) {
                fc.close();
            }
        }
        if (read != 4) {
            throw new IllegalStateException("Read " + read + " bytes from " + activeFileName + " but expected 4");
        }
        buf.flip();
        char c = buf.asCharBuffer().get();
        if (c == 'C') {
            return State.CLEAN;
        }
        if (c == '1') {
            if (!this.fileSystem.fileExists(this.getLog1FileName())) {
                throw new IllegalStateException("Active marked as 1 but no " + this.getLog1FileName() + " exist");
            }
            if (this.fileSystem.fileExists(this.getLog2FileName())) {
                return State.DUAL_LOGS_LOG_1_ACTIVE;
            }
            return State.LOG_1_ACTIVE;
        }
        if (c == '2') {
            if (!this.fileSystem.fileExists(this.getLog2FileName())) {
                throw new IllegalStateException("Active marked as 2 but no " + this.getLog2FileName() + " exist");
            }
            if (this.fileSystem.fileExists(this.getLog1FileName())) {
                return State.DUAL_LOGS_LOG_2_ACTIVE;
            }
            return State.LOG_2_ACTIVE;
        }
        throw new IllegalStateException("Unknown active log: " + c);
    }

    public File getLog1FileName() {
        return new File(this.logBaseName.getPath() + LOG_1_SUFFIX);
    }

    public File getLog2FileName() {
        return new File(this.logBaseName.getPath() + LOG_2_SUFFIX);
    }

    public long determineNextLogVersion(long fallbackVersion) {
        long highestSeen = -1L;
        for (File file : this.fileSystem.listFiles(this.logBaseName.getParentFile())) {
            Pattern p;
            Matcher m;
            String fileName = file.getName();
            if (!fileName.startsWith(this.logBaseName.getName()) || !(m = (p = Pattern.compile("^.*\\.v([0-9]+)$")).matcher(fileName)).find()) continue;
            highestSeen = Math.max(highestSeen, (long)Integer.parseInt(m.group(1)));
        }
        return highestSeen > -1L ? highestSeen + 1L : fallbackVersion;
    }

    public static enum State {
        LEGACY_WITHOUT_LOG_ROTATION,
        NO_ACTIVE_FILE,
        CLEAN,
        LOG_1_ACTIVE,
        LOG_2_ACTIVE,
        DUAL_LOGS_LOG_1_ACTIVE,
        DUAL_LOGS_LOG_2_ACTIVE;

    }
}

