/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa.command;

import java.io.IOException;
import org.neo4j.kernel.impl.nioneo.xa.command.LogHandler;
import org.neo4j.kernel.impl.nioneo.xa.command.LogWriter;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryWriter;

public class SlaveLogWriter
extends LogHandler.Filter {
    private LogBuffer writeBuffer;
    private final LogWriter.SPI spi;
    private final LogEntryWriter logEntryWriter;

    public SlaveLogWriter(LogHandler applier, LogWriter.SPI spi, LogEntryWriter logEntryWriter) {
        super(applier);
        this.logEntryWriter = logEntryWriter;
        this.spi = spi;
    }

    @Override
    public void startLog() {
        this.writeBuffer = this.spi.getWriteBuffer();
        super.startLog();
    }

    @Override
    public void startEntry(LogEntry.Start startEntry) throws IOException {
        startEntry.setStartPosition(this.writeBuffer.getFileChannelPosition());
        super.startEntry(startEntry);
        this.logEntryWriter.writeLogEntry(startEntry, this.writeBuffer);
    }

    @Override
    public void prepareEntry(LogEntry.Prepare prepareEntry) throws IOException {
        this.logEntryWriter.writeLogEntry(prepareEntry, this.writeBuffer);
        super.prepareEntry(prepareEntry);
    }

    @Override
    public void onePhaseCommitEntry(LogEntry.OnePhaseCommit onePhaseCommitEntry) throws IOException {
        this.logEntryWriter.writeLogEntry(onePhaseCommitEntry, this.writeBuffer);
        this.writeBuffer.writeOut();
        super.onePhaseCommitEntry(onePhaseCommitEntry);
    }

    @Override
    public void twoPhaseCommitEntry(LogEntry.TwoPhaseCommit twoPhaseCommitEntry) throws IOException {
        this.logEntryWriter.writeLogEntry(twoPhaseCommitEntry, this.writeBuffer);
        this.writeBuffer.writeOut();
        super.twoPhaseCommitEntry(twoPhaseCommitEntry);
    }

    @Override
    public void doneEntry(LogEntry.Done doneEntry) throws IOException {
        this.logEntryWriter.writeLogEntry(doneEntry, this.writeBuffer);
        super.doneEntry(doneEntry);
    }

    @Override
    public void commandEntry(LogEntry.Command commandEntry) throws IOException {
        this.logEntryWriter.writeLogEntry(commandEntry, this.writeBuffer);
        super.commandEntry(commandEntry);
    }
}

