/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Collection;
import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.Thunk;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.store.CacheLoader;
import org.neo4j.kernel.impl.api.store.CacheUpdateListener;
import org.neo4j.kernel.impl.cache.AutoLoadingCache;
import org.neo4j.kernel.impl.core.GraphPropertiesImpl;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.RelationshipImpl;

public class PersistenceCache {
    private final CacheUpdateListener NODE_CACHE_SIZE_LISTENER = new CacheUpdateListener(){

        @Override
        public void newSize(Primitive entity, int size) {
            PersistenceCache.this.nodeCache.updateSize((NodeImpl)entity, size);
        }
    };
    private final CacheUpdateListener RELATIONSHIP_CACHE_SIZE_LISTENER = new CacheUpdateListener(){

        @Override
        public void newSize(Primitive entity, int size) {
            PersistenceCache.this.relationshipCache.updateSize((RelationshipImpl)entity, size);
        }
    };
    private final AutoLoadingCache<NodeImpl> nodeCache;
    private final AutoLoadingCache<RelationshipImpl> relationshipCache;
    private final Thunk<GraphPropertiesImpl> graphProperties;
    private final NodeManager nodeManager;

    public PersistenceCache(AutoLoadingCache<NodeImpl> nodeCache, AutoLoadingCache<RelationshipImpl> relationshipCache, Thunk<GraphPropertiesImpl> graphProperties, NodeManager nodeManager) {
        this.nodeCache = nodeCache;
        this.relationshipCache = relationshipCache;
        this.graphProperties = graphProperties;
        this.nodeManager = nodeManager;
    }

    public boolean nodeHasLabel(long nodeId, int labelId, CacheLoader<int[]> cacheLoader) throws EntityNotFoundException {
        return this.getNode(nodeId).hasLabel(labelId, cacheLoader);
    }

    public int[] nodeGetLabels(long nodeId, CacheLoader<int[]> loader) throws EntityNotFoundException {
        return this.getNode(nodeId).getLabels(loader);
    }

    public NodeImpl getNode(long nodeId) throws EntityNotFoundException {
        NodeImpl node = this.nodeCache.get(nodeId);
        if (node == null) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId);
        }
        return node;
    }

    public RelationshipImpl getRelationship(long relationshipId) throws EntityNotFoundException {
        RelationshipImpl relationship = this.relationshipCache.get(relationshipId);
        if (relationship == null) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId);
        }
        return relationship;
    }

    public void apply(Collection<NodeLabelUpdate> updates) {
        for (NodeLabelUpdate update : updates) {
            NodeImpl node = this.nodeCache.getIfCached(update.getNodeId());
            if (node == null) continue;
            long[] labelsAfter = update.getLabelsAfter();
            int[] labels = new int[labelsAfter.length];
            for (int i = 0; i < labels.length; ++i) {
                labels[i] = (int)labelsAfter[i];
            }
            node.commitLabels(labels);
        }
    }

    public void evictNode(long nodeId) {
        this.nodeCache.remove(nodeId);
    }

    public Iterator<DefinedProperty> nodeGetProperties(long nodeId, CacheLoader<Iterator<DefinedProperty>> cacheLoader) throws EntityNotFoundException {
        return this.getNode(nodeId).getProperties(cacheLoader, this.NODE_CACHE_SIZE_LISTENER);
    }

    public PrimitiveLongIterator nodeGetPropertyKeys(long nodeId, CacheLoader<Iterator<DefinedProperty>> cacheLoader) throws EntityNotFoundException {
        return this.getNode(nodeId).getPropertyKeys(cacheLoader, this.NODE_CACHE_SIZE_LISTENER);
    }

    public Property nodeGetProperty(long nodeId, int propertyKeyId, CacheLoader<Iterator<DefinedProperty>> cacheLoader) throws EntityNotFoundException {
        return this.getNode(nodeId).getProperty(cacheLoader, this.NODE_CACHE_SIZE_LISTENER, propertyKeyId);
    }

    public Iterator<DefinedProperty> relationshipGetProperties(long relationshipId, CacheLoader<Iterator<DefinedProperty>> cacheLoader) throws EntityNotFoundException {
        return this.getRelationship(relationshipId).getProperties(cacheLoader, this.RELATIONSHIP_CACHE_SIZE_LISTENER);
    }

    public Property relationshipGetProperty(long relationshipId, int propertyKeyId, CacheLoader<Iterator<DefinedProperty>> cacheLoader) throws EntityNotFoundException {
        return this.getRelationship(relationshipId).getProperty(cacheLoader, this.RELATIONSHIP_CACHE_SIZE_LISTENER, propertyKeyId);
    }

    public Iterator<DefinedProperty> graphGetProperties(CacheLoader<Iterator<DefinedProperty>> cacheLoader) {
        return this.graphProperties.evaluate().getProperties(cacheLoader, CacheUpdateListener.NO_UPDATES);
    }

    public PrimitiveLongIterator graphGetPropertyKeys(CacheLoader<Iterator<DefinedProperty>> cacheLoader) {
        return this.graphProperties.evaluate().getPropertyKeys(cacheLoader, CacheUpdateListener.NO_UPDATES);
    }

    public Property graphGetProperty(CacheLoader<Iterator<DefinedProperty>> cacheLoader, int propertyKeyId) {
        return this.graphProperties.evaluate().getProperty(cacheLoader, CacheUpdateListener.NO_UPDATES, propertyKeyId);
    }

    public PrimitiveLongIterator nodeGetRelationships(long node, Direction direction, int[] relTypes) throws EntityNotFoundException {
        return this.getNode(node).getRelationships(this.nodeManager, direction, relTypes);
    }

    public PrimitiveLongIterator nodeGetRelationships(long nodeId, Direction direction) throws EntityNotFoundException {
        return this.getNode(nodeId).getRelationships(this.nodeManager, direction);
    }
}

