/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.cache.SizeOfs;

final class DoubleProperty
extends DefinedProperty {
    private final double value;

    DoubleProperty(int propertyKeyId, double value) {
        super(propertyKeyId);
        this.value = value;
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof Double) {
            return this.value == (Double)other;
        }
        return this.valueCompare(this.value, other);
    }

    @Override
    public Double value() {
        return this.value;
    }

    @Override
    int valueHash() {
        long temp = Double.doubleToLongBits(this.value);
        return (int)(temp ^ temp >>> 32);
    }

    @Override
    boolean hasEqualValue(DefinedProperty that) {
        return Double.compare(this.value, ((DoubleProperty)that).value) == 0;
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return SizeOfs.withObjectOverhead(8);
    }
}

