/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.Iterator;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.unsafe.impl.batchimport.cache.NodeIdMapper;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;

public class ActualNodeIdMapper
implements NodeIdMapper {
    private long lastSeenNodeId = -1L;
    private final NodeStore nodeStore;

    public ActualNodeIdMapper(NodeStore nodeStore) {
        this.nodeStore = nodeStore;
    }

    @Override
    public Iterator<InputNode> wrapNodes(Iterator<InputNode> nodes) {
        return new IteratorWrapper<InputNode, InputNode>(nodes){

            @Override
            protected InputNode underlyingObjectToObject(InputNode node) {
                if (ActualNodeIdMapper.this.lastSeenNodeId != -1L && node.id() < ActualNodeIdMapper.this.lastSeenNodeId) {
                    throw new IllegalArgumentException("Cannot go backwards in node id sequence, last seen was " + ActualNodeIdMapper.this.lastSeenNodeId + ", given id is " + node.id());
                }
                ActualNodeIdMapper.this.nodeStore.setHighId(node.id() + 1L);
                ActualNodeIdMapper.this.lastSeenNodeId = node.id();
                return node;
            }
        };
    }

    @Override
    public Iterator<InputRelationship> wrapRelationships(Iterator<InputRelationship> relationships) {
        return relationships;
    }
}

