/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.EmbeddedReadOnlyGraphDatabase;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;

public class GraphDatabaseFactory {
    private final GraphDatabaseFactoryState state;

    public GraphDatabaseFactory() {
        this(new GraphDatabaseFactoryState());
    }

    protected GraphDatabaseFactory(GraphDatabaseFactoryState state) {
        this.state = state;
    }

    protected GraphDatabaseFactoryState getCurrentState() {
        return this.state;
    }

    protected GraphDatabaseFactoryState getStateCopy() {
        return new GraphDatabaseFactoryState(this.getCurrentState());
    }

    public GraphDatabaseService newEmbeddedDatabase(String path) {
        return this.newEmbeddedDatabaseBuilder(path).newGraphDatabase();
    }

    public GraphDatabaseBuilder newEmbeddedDatabaseBuilder(final String path) {
        final GraphDatabaseFactoryState state = this.getStateCopy();
        return new GraphDatabaseBuilder(new GraphDatabaseBuilder.DatabaseCreator(){

            @Override
            public GraphDatabaseService newDatabase(Map<String, String> config) {
                config.put("ephemeral", "false");
                InternalAbstractGraphDatabase.Dependencies dependencies = state.databaseDependencies();
                if ("true".equalsIgnoreCase(config.get(GraphDatabaseSettings.read_only.name()))) {
                    return new EmbeddedReadOnlyGraphDatabase(path, config, dependencies);
                }
                return new EmbeddedGraphDatabase(path, config, dependencies);
            }
        });
    }

    @Deprecated
    public Iterable<KernelExtensionFactory<?>> getKernelExtension() {
        return this.getCurrentState().getKernelExtension();
    }

    @Deprecated
    public GraphDatabaseFactory addKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
        this.getCurrentState().addKernelExtensions(newKernelExtensions);
        return this;
    }

    @Deprecated
    public GraphDatabaseFactory addKernelExtension(KernelExtensionFactory<?> newKernelExtension) {
        List<KernelExtensionFactory<?>> extensions = Arrays.asList(newKernelExtension);
        return this.addKernelExtensions(extensions);
    }

    @Deprecated
    public GraphDatabaseFactory setKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
        this.getCurrentState().setKernelExtensions(newKernelExtensions);
        return this;
    }

    @Deprecated
    public List<CacheProvider> getCacheProviders() {
        return this.getCurrentState().getCacheProviders();
    }

    @Deprecated
    public GraphDatabaseFactory setCacheProviders(Iterable<CacheProvider> newCacheProviders) {
        this.getCurrentState().setCacheProviders(newCacheProviders);
        return this;
    }

    @Deprecated
    public List<TransactionInterceptorProvider> getTransactionInterceptorProviders() {
        return this.getCurrentState().getTransactionInterceptorProviders();
    }

    public GraphDatabaseFactory setTransactionInterceptorProviders(Iterable<TransactionInterceptorProvider> transactionInterceptorProviders) {
        this.getCurrentState().setTransactionInterceptorProviders(transactionInterceptorProviders);
        return this;
    }
}

