/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.store.BatchWritingWindowPoolFactory;
import org.neo4j.unsafe.impl.batchimport.store.BatchingIdGeneratorFactory;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;
import org.neo4j.unsafe.impl.batchimport.store.ChannelReusingFileSystemAbstraction;
import org.neo4j.unsafe.impl.batchimport.store.Monitor;
import org.neo4j.unsafe.impl.batchimport.store.ReverseBatchUpdatingWindowPoolFactory;
import org.neo4j.unsafe.impl.batchimport.store.TailoredWindowPoolFactory;

public class BatchFriendlyNeoStore
implements AutoCloseable {
    private final LifeSupport life = new LifeSupport();
    private final ChannelReusingFileSystemAbstraction fileSystem;
    private final Configuration config;
    private final Monitor writeMonitor;
    private NeoStore neoStore;
    private final BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyRepository;
    private final BatchingTokenRepository.BatchingLabelTokenRepository labelRepository;
    private final BatchingTokenRepository.BatchingRelationshipTypeTokenRepository relationshipTypeRepository;
    private final StringLogger logger;
    private final Config neo4jConfig;
    private final File neoStoreFileName;

    public BatchFriendlyNeoStore(FileSystemAbstraction fileSystem, String storeDir, Configuration config, Monitor writeMonitor, Logging logging) {
        this.fileSystem = this.life.add(new ChannelReusingFileSystemAbstraction(fileSystem));
        this.neoStoreFileName = new File(storeDir, "neostore");
        this.config = config;
        this.writeMonitor = writeMonitor;
        this.logger = logging.getMessagesLog(this.getClass());
        this.neo4jConfig = StoreFactory.configForStoreDir(new Config(MapUtil.stringMap(GraphDatabaseSettings.dense_node_threshold.name(), String.valueOf(config.denseNodeThreshold()))), new File(storeDir));
        this.neoStore = this.newBatchWritingNeoStore();
        this.propertyKeyRepository = new BatchingTokenRepository.BatchingPropertyKeyTokenRepository(this.neoStore.getPropertyKeyTokenStore());
        this.labelRepository = new BatchingTokenRepository.BatchingLabelTokenRepository(this.neoStore.getLabelTokenStore());
        this.relationshipTypeRepository = new BatchingTokenRepository.BatchingRelationshipTypeTokenRepository(this.neoStore.getRelationshipTypeStore());
        this.life.start();
    }

    private NeoStore newNeoStore(WindowPoolFactory windowPoolFactory) {
        StoreFactory storeFactory = new StoreFactory(this.neo4jConfig, new BatchingIdGeneratorFactory(), windowPoolFactory, this.fileSystem, this.logger, new DefaultTxHook());
        if (this.fileSystem.fileExists(this.neoStoreFileName)) {
            return storeFactory.newNeoStore(this.neoStoreFileName);
        }
        return storeFactory.createNeoStore(this.neoStoreFileName);
    }

    private NeoStore newBatchWritingNeoStore() {
        return this.newNeoStore(new BatchWritingWindowPoolFactory(this.config.fileChannelBufferSize(), this.writeMonitor));
    }

    private NeoStore newReverseUpdatingNeoStore() {
        TailoredWindowPoolFactory factory = new TailoredWindowPoolFactory(new BatchWritingWindowPoolFactory(this.config.fileChannelBufferSize(), this.writeMonitor));
        ReverseBatchUpdatingWindowPoolFactory reverseFactory = new ReverseBatchUpdatingWindowPoolFactory(this.config.fileChannelBufferSize(), this.writeMonitor);
        factory.override(".nodestore.db", reverseFactory);
        factory.override(".relationshipstore.db", reverseFactory);
        return this.newNeoStore(factory);
    }

    public NodeStore getNodeStore() {
        return this.neoStore.getNodeStore();
    }

    public PropertyStore getPropertyStore() {
        return this.neoStore.getPropertyStore();
    }

    public BatchingTokenRepository<?> getPropertyKeyRepository() {
        return this.propertyKeyRepository;
    }

    public BatchingTokenRepository<?> getLabelRepository() {
        return this.labelRepository;
    }

    public BatchingTokenRepository<?> getRelationshipTypeRepository() {
        return this.relationshipTypeRepository;
    }

    public RelationshipStore getRelationshipStore() {
        return this.neoStore.getRelationshipStore();
    }

    public RelationshipGroupStore getRelationshipGroupStore() {
        return this.neoStore.getRelationshipGroupStore();
    }

    public void switchNodeAndRelationshipStoresToReverseUpdatingMode() {
        this.propertyKeyRepository.close();
        this.labelRepository.close();
        this.relationshipTypeRepository.close();
        this.neoStore.close();
        this.neoStore = null;
        this.neoStore = this.newReverseUpdatingNeoStore();
    }

    @Override
    public void close() {
        if (this.neoStore != null) {
            this.neoStore.close();
            this.neoStore = null;
        }
        this.life.shutdown();
    }
}

