/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.IOException;
import java.util.Iterator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.DefaultLogging;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.unsafe.impl.batchimport.BatchImporter;
import org.neo4j.unsafe.impl.batchimport.CalculateDenseNodesStep;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.EntityStoreUpdaterStep;
import org.neo4j.unsafe.impl.batchimport.NodeEncoderStep;
import org.neo4j.unsafe.impl.batchimport.NodeFirstRelationshipStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipEncoderStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkbackStep;
import org.neo4j.unsafe.impl.batchimport.cache.LongArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.NodeIdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.NodeIdMapping;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLinkImpl;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ProducerStep;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.store.BatchFriendlyNeoStore;
import org.neo4j.unsafe.impl.batchimport.store.IoMonitor;

public class ParallellBatchImporter
implements BatchImporter {
    private final String storeDir;
    private final FileSystemAbstraction fileSystem;
    private final Configuration config;
    private final IoMonitor writeMonitor;
    private final ExecutionMonitor executionMonitor;
    private final Logging logging;
    private final ConsoleLogger logger;
    private final LifeSupport life = new LifeSupport();

    public ParallellBatchImporter(String storeDir, FileSystemAbstraction fileSystem, Configuration config, Iterable<KernelExtensionFactory<?>> kernelExtensions, ExecutionMonitor executionMonitor) {
        this.storeDir = storeDir;
        this.fileSystem = fileSystem;
        this.config = config;
        this.logging = this.life.add(DefaultLogging.createDefaultLogging(MapUtil.stringMap(GraphDatabaseSettings.store_dir.name(), storeDir)));
        this.logger = this.logging.getConsoleLog(this.getClass());
        this.executionMonitor = executionMonitor;
        this.writeMonitor = new IoMonitor();
        this.life.start();
    }

    @Override
    public void doImport(Iterable<InputNode> nodes, Iterable<InputRelationship> relationships, NodeIdMapping nodeIdMapping) throws IOException {
        this.logger.log("Starting CSV import [TODO source info]");
        try (BatchFriendlyNeoStore neoStore = new BatchFriendlyNeoStore(this.fileSystem, this.storeDir, this.config, this.writeMonitor, this.logging);){
            NodeIdMapper nodeIdMapper = nodeIdMapping.mapper(neoStore.getNodeStore());
            this.executeStage(new NodeStage(nodeIdMapper.wrapNodes(nodes.iterator()), neoStore));
            NodeRelationshipLinkImpl nodeRelationshipLink = new NodeRelationshipLinkImpl(LongArrayFactory.AUTO, neoStore.getNodeStore().getHighId(), this.config.denseNodeThreshold());
            this.executeStage(new CalculateDenseNodesStage(relationships.iterator(), neoStore, nodeRelationshipLink));
            this.executeStage(new RelationshipStage(relationships, neoStore, nodeRelationshipLink));
            neoStore.switchNodeAndRelationshipStoresToReverseUpdatingMode();
            this.executeStage(new NodeFirstRelationshipStage(neoStore, nodeRelationshipLink));
            nodeRelationshipLink.clearRelationships();
            this.executeStage(new RelationshipLinkbackStage(neoStore, nodeRelationshipLink));
            this.executionMonitor.done();
            this.logger.log("Import completed [TODO import stats]");
        }
        catch (Throwable t) {
            this.logger.error("Error during import", t);
            throw Exceptions.launderedException(IOException.class, t);
        }
    }

    private synchronized void executeStage(Stage<?> stage) throws Exception {
        this.executionMonitor.monitor(stage.execute());
    }

    @Override
    public void shutdown() {
        this.logger.log("Shutting down");
        this.life.shutdown();
        this.logger.log("Successfully shut down [TODO store stats?]");
    }

    public class RelationshipLinkbackStage
    extends Stage<Void> {
        public RelationshipLinkbackStage(BatchFriendlyNeoStore neoStore, NodeRelationshipLink nodeRelationshipLink) {
            super(ParallellBatchImporter.this.logging, "Relationship back link", ParallellBatchImporter.this.config);
            this.input(new RelationshipLinkbackStep(this.control(), ParallellBatchImporter.this.config.batchSize(), neoStore.getRelationshipStore(), nodeRelationshipLink), null);
        }
    }

    public class NodeFirstRelationshipStage
    extends Stage<Void> {
        public NodeFirstRelationshipStage(BatchFriendlyNeoStore neoStore, NodeRelationshipLink nodeRelationshipLink) {
            super(ParallellBatchImporter.this.logging, "Node first rel", ParallellBatchImporter.this.config);
            this.input(new NodeFirstRelationshipStep(this.control(), ParallellBatchImporter.this.config.batchSize(), neoStore.getNodeStore(), neoStore.getRelationshipGroupStore(), nodeRelationshipLink), null);
        }
    }

    public class RelationshipStage
    extends Stage<Iterator<InputRelationship>> {
        public RelationshipStage(Iterable<InputRelationship> input, BatchFriendlyNeoStore neoStore, NodeRelationshipLink nodeRelationshipLink) {
            super(ParallellBatchImporter.this.logging, "Relationships", ParallellBatchImporter.this.config);
            this.input(new ProducerStep(this.control(), "INPUT", ParallellBatchImporter.this.config.batchSize()), input.iterator());
            RelationshipStore relationshipStore = neoStore.getRelationshipStore();
            PropertyStore propertyStore = neoStore.getPropertyStore();
            this.add(new RelationshipEncoderStep(this.control(), "ENCODER", ParallellBatchImporter.this.config.workAheadSize(), 1, neoStore.getPropertyKeyRepository(), neoStore.getRelationshipTypeRepository(), relationshipStore, propertyStore, nodeRelationshipLink));
            this.add(new EntityStoreUpdaterStep<RelationshipRecord>(this.control(), "WRITER", relationshipStore, propertyStore, ParallellBatchImporter.this.writeMonitor));
        }
    }

    public class CalculateDenseNodesStage
    extends Stage<Iterator<InputRelationship>> {
        public CalculateDenseNodesStage(Iterator<InputRelationship> input, BatchFriendlyNeoStore neoStore, NodeRelationshipLink nodeRelationshipLink) {
            super(ParallellBatchImporter.this.logging, "Calculate dense nodes", ParallellBatchImporter.this.config);
            this.input(new ProducerStep(this.control(), "INPUT", ParallellBatchImporter.this.config.batchSize()), input);
            this.add(new CalculateDenseNodesStep(this.control(), ParallellBatchImporter.this.config.workAheadSize(), nodeRelationshipLink));
        }
    }

    public class NodeStage
    extends Stage<Iterator<InputNode>> {
        public NodeStage(Iterator<InputNode> input, BatchFriendlyNeoStore neoStore) {
            super(ParallellBatchImporter.this.logging, "Nodes", ParallellBatchImporter.this.config);
            this.input(new ProducerStep(this.control(), "INPUT", ParallellBatchImporter.this.config.batchSize()), input);
            NodeStore nodeStore = neoStore.getNodeStore();
            PropertyStore propertyStore = neoStore.getPropertyStore();
            this.add(new NodeEncoderStep(this.control(), "ENCODER", ParallellBatchImporter.this.config.workAheadSize(), 1, neoStore.getPropertyKeyRepository(), neoStore.getLabelRepository(), nodeStore, propertyStore));
            this.add(new EntityStoreUpdaterStep<NodeRecord>(this.control(), "WRITER", nodeStore, propertyStore, ParallellBatchImporter.this.writeMonitor));
        }
    }
}

