/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.statistics;

import java.io.Serializable;
import org.neo4j.helpers.ArrayUtil;

public class RollingAverage
implements Serializable {
    private static final long serialVersionUID = -230424883810571860L;
    private final Parameters parameters;
    private final double[] averages = new double[8];
    private int populatedWindows = 1;
    private long samplesInCurrentWindow = 0L;

    public RollingAverage(Parameters parameters) {
        this.parameters = parameters;
    }

    public void record(long value) {
        this.averages[0] = (this.averages[0] * (double)this.samplesInCurrentWindow + (double)value) / (double)(this.samplesInCurrentWindow + 1L);
        if (++this.samplesInCurrentWindow > this.parameters.windowSize) {
            double previous = this.averages[0];
            for (int i = 1; i < this.averages.length - 1; ++i) {
                double current = this.averages[i];
                this.averages[i] = previous;
                previous = current;
            }
            this.samplesInCurrentWindow /= 4L;
            this.populatedWindows = Math.min(this.populatedWindows + 1, this.averages.length);
        }
    }

    public double average() {
        double average = 0.0;
        for (int i = 0; i < this.populatedWindows; ++i) {
            long weightMultiplier = (long)Math.pow(this.populatedWindows - i, 2.0);
            average += this.averages[i] * (double)weightMultiplier;
        }
        int totalWeightMultipliers = this.populatedWindows * (this.populatedWindows + 1) * (this.populatedWindows * 2 + 1) / 6;
        return average / (double)totalWeightMultipliers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RollingAverage other = (RollingAverage)o;
        return this.populatedWindows == other.populatedWindows && this.parameters.equals(other.parameters) && ArrayUtil.approximatelyEqual(this.averages, other.averages, this.parameters.equalityTolerance);
    }

    public int hashCode() {
        int result = this.parameters.hashCode();
        result = 31 * result + this.populatedWindows;
        return result;
    }

    public static class Parameters
    implements Serializable {
        private static final long serialVersionUID = 8909006975623003761L;
        public static final int DEFAULT_WINDOW_SIZE = 1024;
        public static final double DEFAULT_EQUALITY_TOLERANCE = 1.0E-4;
        public final long windowSize;
        public final double equalityTolerance;

        public Parameters() {
            this(1024L, 1.0E-4);
        }

        public Parameters(long windowSize, double equalityTolerance) {
            this.windowSize = windowSize;
            this.equalityTolerance = equalityTolerance;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameters that = (Parameters)o;
            return Double.compare(that.equalityTolerance, this.equalityTolerance) == 0 && this.windowSize == that.windowSize;
        }

        public int hashCode() {
            int result = (int)(this.windowSize ^ this.windowSize >>> 32);
            long temp = Double.doubleToLongBits(this.equalityTolerance);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }
}

