/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.MigrationDependencyResolver;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.UpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByConfigurationException;
import org.neo4j.kernel.impl.util.DependencySatisfier;

public class StoreUpgrader
implements DependencySatisfier {
    private static final String MIGRATION_DIRECTORY = "upgrade";
    private static final String MIGRATION_STATUS_FILE = "_status";
    private static final String MIGRATION_LEFT_OVERS_DIRECTORY = "upgrade_backup";
    public static final Monitor NO_MONITOR = new MonitorAdapter(){};
    private final List<StoreMigrationParticipant> participants = new ArrayList<StoreMigrationParticipant>();
    private final UpgradeConfiguration upgradeConfiguration;
    private final FileSystemAbstraction fileSystem;
    private final MigrationDependencyResolver dependencyResolver = new MigrationDependencyResolver();
    private final Monitor monitor;

    public StoreUpgrader(UpgradeConfiguration upgradeConfiguration, FileSystemAbstraction fileSystem, Monitor monitor) {
        this.fileSystem = fileSystem;
        this.upgradeConfiguration = upgradeConfiguration;
        this.monitor = monitor;
    }

    public void addParticipant(StoreMigrationParticipant participant) {
        assert (participant != null);
        this.participants.add(participant);
    }

    @Override
    public <T> void satisfyDependency(Class<T> type, T dependency) {
        this.dependencyResolver.satisfyDependency(type, dependency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateIfNeeded(File storeDirectory) {
        List<StoreMigrationParticipant> participantsNeedingMigration = this.getParticipantsEagerToMigrate(storeDirectory);
        if (participantsNeedingMigration.isEmpty()) {
            return;
        }
        this.monitor.migrationNeeded();
        try {
            this.upgradeConfiguration.checkConfigurationAllowsAutomaticUpgrade();
        }
        catch (UpgradeNotAllowedByConfigurationException e) {
            this.monitor.migrationNotAllowed();
            throw e;
        }
        File migrationDirectory = new File(storeDirectory, MIGRATION_DIRECTORY);
        try {
            File migrationStateFile = new File(migrationDirectory, MIGRATION_STATUS_FILE);
            File leftOversDirectory = new File(storeDirectory, MIGRATION_LEFT_OVERS_DIRECTORY);
            if (!this.migrationStatusIs(migrationStateFile, MigrationStatus.moving)) {
                this.cleanMigrationDirectory(migrationDirectory);
                this.setMigrationStatus(migrationStateFile, MigrationStatus.migrating);
                this.migrateToIsolatedDirectory(participantsNeedingMigration, storeDirectory, migrationDirectory);
                this.setMigrationStatus(migrationStateFile, MigrationStatus.moving);
            }
            this.closeParticipants();
            this.moveMigratedFilesToWorkingDirectory(participantsNeedingMigration, migrationDirectory, storeDirectory, leftOversDirectory);
            this.setMigrationStatus(migrationStateFile, MigrationStatus.completed);
            this.cleanup(participantsNeedingMigration, migrationDirectory);
            this.monitor.migrationCompleted();
        }
        finally {
            this.closeParticipants();
        }
    }

    private void cleanup(Iterable<StoreMigrationParticipant> participants, File migrationDirectory) {
        try {
            for (StoreMigrationParticipant participant : participants) {
                participant.cleanup(this.fileSystem, migrationDirectory);
            }
        }
        catch (IOException e) {
            throw new UnableToUpgradeException("Failure cleaning up after migration", e);
        }
    }

    private void closeParticipants() {
        for (StoreMigrationParticipant participant : this.participants) {
            participant.close();
        }
    }

    private boolean migrationStatusIs(File stateFile, MigrationStatus state) {
        return state.name().equals(this.readFromFile(stateFile));
    }

    private void setMigrationStatus(File stateFile, MigrationStatus status) {
        this.writeToFile(stateFile, status.name());
    }

    private void moveMigratedFilesToWorkingDirectory(Iterable<StoreMigrationParticipant> participantsNeedingMigration, File migrationDirectory, File workingDirectory, File leftOversDirectory) {
        try {
            this.fileSystem.mkdirs(leftOversDirectory);
            for (StoreMigrationParticipant participant : participantsNeedingMigration) {
                participant.moveMigratedFiles(this.fileSystem, migrationDirectory, workingDirectory, leftOversDirectory);
            }
        }
        catch (IOException e) {
            throw new UnableToUpgradeException("Unable to move migrated files into place", e);
        }
    }

    private List<StoreMigrationParticipant> getParticipantsEagerToMigrate(File storeDirectory) {
        ArrayList<StoreMigrationParticipant> participantsNeedingUpgrade = new ArrayList<StoreMigrationParticipant>();
        for (StoreMigrationParticipant participant : this.participants) {
            try {
                if (!participant.needsMigration(this.fileSystem, storeDirectory)) continue;
                participantsNeedingUpgrade.add(participant);
            }
            catch (IOException e) {
                throw new UnableToCheckForUpgradeException(participant.toString() + " for " + storeDirectory, e);
            }
        }
        return participantsNeedingUpgrade;
    }

    private void migrateToIsolatedDirectory(List<StoreMigrationParticipant> participantsNeedingMigration, File storeDir, File migrationDirectory) {
        try {
            for (StoreMigrationParticipant participant : this.participants) {
                boolean participated = false;
                if (participantsNeedingMigration.contains(participant)) {
                    participant.migrate(this.fileSystem, storeDir, migrationDirectory, this.dependencyResolver);
                    participated = true;
                }
                participant.satisfyDependenciesDownstream(this.fileSystem, storeDir, migrationDirectory, this.dependencyResolver, participated);
            }
        }
        catch (IOException e) {
            throw new UnableToUpgradeException("Failure doing migration", e);
        }
        catch (Exception e) {
            throw Exceptions.launderedException(e);
        }
    }

    private void cleanMigrationDirectory(File migrationDirectory) {
        if (migrationDirectory.exists()) {
            try {
                this.fileSystem.deleteRecursively(migrationDirectory);
            }
            catch (IOException e) {
                throw new UnableToUpgradeException("Failure deleting upgrade directory " + migrationDirectory, e);
            }
        }
        this.fileSystem.mkdir(migrationDirectory);
    }

    private void writeToFile(File file, String string) {
        if (this.fileSystem.fileExists(file)) {
            this.fileSystem.deleteFile(file);
        }
        try (Writer writer = this.fileSystem.openAsWriter(file, "utf-8", false);){
            writer.write(string);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readFromFile(File file) {
        try (BufferedReader reader = new BufferedReader(this.fileSystem.openAsReader(file, "utf-8"));){
            String readLine;
            String string = readLine = reader.readLine();
            return string;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class UnableToCheckForUpgradeException
    extends UnableToUpgradeException {
        private static final String MESSAGE = "'%s' failed to check whether or not migration was required";

        public UnableToCheckForUpgradeException(String participant, Throwable cause) {
            super(String.format(MESSAGE, participant), cause);
        }
    }

    public static class UnexpectedUpgradingStoreVersionException
    extends UnableToUpgradeException {
        private static final String MESSAGE = "'%s' has a store version number that we cannot upgrade from. Expected '%s' but file is version '%s'.";

        public UnexpectedUpgradingStoreVersionException(String filename, String expectedVersion, String actualVersion) {
            super(String.format(MESSAGE, filename, expectedVersion, actualVersion));
        }
    }

    public static class UpgradingStoreVersionNotFoundException
    extends UnableToUpgradeException {
        private static final String MESSAGE = "'%s' does not contain a store version, please ensure that the original database was shut down in a clean state.";

        public UpgradingStoreVersionNotFoundException(String filenameWithoutStoreVersion) {
            super(String.format(MESSAGE, filenameWithoutStoreVersion));
        }
    }

    public static class UpgradeMissingStoreFilesException
    extends UnableToUpgradeException {
        private static final String MESSAGE = "Missing required store file '%s'.";

        public UpgradeMissingStoreFilesException(String filenameExpectedToExist) {
            super(String.format(MESSAGE, filenameExpectedToExist));
        }
    }

    public static class UnableToUpgradeException
    extends RuntimeException {
        public UnableToUpgradeException(String message, Throwable cause) {
            super(message, cause);
        }

        public UnableToUpgradeException(String message) {
            super(message);
        }
    }

    public static abstract class MonitorAdapter
    implements Monitor {
        @Override
        public void migrationNeeded() {
        }

        @Override
        public void migrationNotAllowed() {
        }

        @Override
        public void migrationCompleted() {
        }
    }

    public static interface Monitor {
        public void migrationNeeded();

        public void migrationNotAllowed();

        public void migrationCompleted();
    }

    private static enum MigrationStatus {
        migrating,
        moving,
        completed;

    }
}

