/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreUtil;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.StoreFile;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.ParallellBatchImporter;
import org.neo4j.unsafe.impl.batchimport.cache.NodeIdMapping;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.CoarseBoundedProgressExecutionMonitor;

public class StoreMigrator
extends StoreMigrationParticipant.Adapter {
    private static final Object[] NO_PROPERTIES = new Object[0];
    private final MigrationProgressMonitor progressMonitor;
    private final UpgradableDatabase upgradableDatabase;
    private final Config config;

    public StoreMigrator(MigrationProgressMonitor progressMonitor, FileSystemAbstraction fileSystem) {
        this(progressMonitor, new UpgradableDatabase(new StoreVersionCheck(fileSystem)), new Config());
    }

    public StoreMigrator(MigrationProgressMonitor progressMonitor, UpgradableDatabase upgradableDatabase, Config config) {
        this.progressMonitor = progressMonitor;
        this.upgradableDatabase = upgradableDatabase;
        this.config = config;
    }

    @Override
    public boolean needsMigration(FileSystemAbstraction fileSystem, File storeDir) throws IOException {
        NeoStoreUtil neoStoreUtil = new NeoStoreUtil(storeDir, fileSystem);
        String versionAsString = NeoStore.versionLongToString(neoStoreUtil.getStoreVersion());
        boolean sameVersion = "v0.A.3".equals(versionAsString);
        if (!sameVersion) {
            this.upgradableDatabase.checkUpgradeable(storeDir);
        }
        return !sameVersion;
    }

    @Override
    public void migrate(FileSystemAbstraction fileSystem, File storeDir, File migrationDir, DependencyResolver dependencyResolver) throws IOException {
        LegacyStore legacyStore = new LegacyStore(fileSystem, new File(storeDir, "neostore"));
        CoarseBoundedProgressExecutionMonitor executionMonitor = new CoarseBoundedProgressExecutionMonitor(legacyStore.getNodeStoreReader().getMaxId(), legacyStore.getRelStoreReader().getMaxId()){

            @Override
            protected void percent(int percent) {
                StoreMigrator.this.progressMonitor.percentComplete(percent);
            }
        };
        ParallellBatchImporter importer = new ParallellBatchImporter(migrationDir.getAbsolutePath(), fileSystem, new Configuration.FromConfig(this.config), Collections.emptyList(), executionMonitor);
        this.progressMonitor.started();
        importer.doImport(this.legacyNodesAsInput(legacyStore), this.legacyRelationshipsAsInput(legacyStore), NodeIdMapping.actual);
        this.progressMonitor.finished();
        importer.shutdown();
        legacyStore.close();
    }

    private StoreFile[] allExcept(StoreFile ... exceptions) {
        ArrayList<StoreFile> result = new ArrayList<StoreFile>();
        result.addAll(Arrays.asList(StoreFile.values()));
        for (StoreFile except : exceptions) {
            result.remove((Object)except);
        }
        return result.toArray(new StoreFile[result.size()]);
    }

    private Iterable<InputRelationship> legacyRelationshipsAsInput(LegacyStore legacyStore) {
        final LegacyRelationshipStoreReader reader = legacyStore.getRelStoreReader();
        return new Iterable<InputRelationship>(){

            @Override
            public Iterator<InputRelationship> iterator() {
                Iterator<RelationshipRecord> source;
                try {
                    source = reader.iterator(0L);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return new IteratorWrapper<InputRelationship, RelationshipRecord>(source){

                    @Override
                    protected InputRelationship underlyingObjectToObject(RelationshipRecord record) {
                        return new InputRelationship(record.getId(), NO_PROPERTIES, record.getNextProp(), record.getFirstNode(), record.getSecondNode(), null, record.getType());
                    }
                };
            }
        };
    }

    private Iterable<InputNode> legacyNodesAsInput(LegacyStore legacyStore) {
        final LegacyNodeStoreReader reader = legacyStore.getNodeStoreReader();
        final String[] NO_LABELS = new String[]{};
        return new Iterable<InputNode>(){

            @Override
            public Iterator<InputNode> iterator() {
                Iterator<NodeRecord> source;
                try {
                    source = reader.iterator();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return new IteratorWrapper<InputNode, NodeRecord>(source){

                    @Override
                    protected InputNode underlyingObjectToObject(NodeRecord record) {
                        return new InputNode(record.getId(), NO_PROPERTIES, record.getNextProp(), NO_LABELS, record.getLabelField());
                    }
                };
            }
        };
    }

    @Override
    public void moveMigratedFiles(FileSystemAbstraction fileSystem, File migrationDir, File storeDir, File leftOversDir) throws IOException {
        StoreFile.deleteIdFile(fileSystem, migrationDir, this.allExcept(StoreFile.RELATIONSHIP_GROUP_STORE));
        StoreFile.deleteStoreFile(fileSystem, migrationDir, this.allExcept(StoreFile.NODE_STORE, StoreFile.RELATIONSHIP_STORE, StoreFile.RELATIONSHIP_GROUP_STORE));
        StoreFile.move(fileSystem, storeDir, leftOversDir, IteratorUtil.asIterable(StoreFile.NODE_STORE, StoreFile.RELATIONSHIP_STORE), false, false, StoreFileType.STORE);
        StoreFile.move(fileSystem, migrationDir, storeDir, StoreFile.currentStoreFiles(), true, true, StoreFileType.values());
        StoreFile.ensureStoreVersion(fileSystem, storeDir, StoreFile.currentStoreFiles());
    }

    @Override
    public void cleanup(FileSystemAbstraction fileSystem, File migrationDir) throws IOException {
        for (StoreFile storeFile : StoreFile.values()) {
            fileSystem.deleteFile(new File(migrationDir, storeFile.storeFileName()));
            fileSystem.deleteFile(new File(migrationDir, storeFile.idFileName()));
        }
    }

    public String toString() {
        return "Kernel StoreMigrator";
    }
}

