/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.transaction.xa.Xid;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.AbstractRecordStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.SchemaStore;
import org.neo4j.kernel.impl.nioneo.store.TokenRecord;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.nioneo.xa.command.Command;
import org.neo4j.kernel.impl.nioneo.xa.command.CommandRecordVisitor;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandWriter;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryWriterv1;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;

public class TransactionWriter {
    private final int identifier;
    private final int localId;
    private final Output output;

    public TransactionWriter(LogBuffer buffer, int identifier, int localId) {
        this(new LogBufferOutput(buffer), identifier, localId);
    }

    public TransactionWriter(Output output, int identifier, int localId) {
        this.output = output;
        this.identifier = identifier;
        this.localId = localId;
    }

    public void start(int masterId, int myId, long latestCommittedTxWhenTxStarted) throws IOException {
        this.start(XidImpl.getNewGlobalId(XidImpl.DEFAULT_SEED, this.localId), masterId, myId, System.currentTimeMillis(), latestCommittedTxWhenTxStarted);
    }

    public void start(byte[] globalId, int masterId, int myId, long startTimestamp, long latestCommittedTxWhenTxStarted) throws IOException {
        XidImpl xid = new XidImpl(globalId, NeoStoreXaDataSource.BRANCH_ID);
        this.output.writeStart(xid, this.identifier, masterId, myId, startTimestamp, latestCommittedTxWhenTxStarted);
    }

    public void prepare() throws IOException {
        this.prepare(System.currentTimeMillis());
    }

    public void prepare(long prepareTimestamp) throws IOException {
        this.output.writePrepare(this.identifier, prepareTimestamp);
    }

    public void commit(boolean twoPhase, long txId) throws IOException {
        this.commit(twoPhase, txId, System.currentTimeMillis());
    }

    public void commit(boolean twoPhase, long txId, long commitTimestamp) throws IOException {
        this.output.writeCommit(this.identifier, twoPhase, txId, commitTimestamp);
    }

    public void done() throws IOException {
        this.output.writeDone(this.identifier);
    }

    public void propertyKey(int id, String key, int ... dynamicIds) throws IOException {
        Command.PropertyKeyTokenCommand command = new Command.PropertyKeyTokenCommand();
        command.init(TransactionWriter.withName(new PropertyKeyTokenRecord(id), dynamicIds, key));
        this.write(command);
    }

    public void label(int id, String name, int ... dynamicIds) throws IOException {
        Command.LabelTokenCommand command = new Command.LabelTokenCommand();
        command.init(TransactionWriter.withName(new LabelTokenRecord(id), dynamicIds, name));
        this.write(command);
    }

    public void relationshipType(int id, String label, int ... dynamicIds) throws IOException {
        Command.RelationshipTypeTokenCommand command = new Command.RelationshipTypeTokenCommand();
        command.init(TransactionWriter.withName(new RelationshipTypeTokenRecord(id), dynamicIds, label));
        this.write(command);
    }

    public void update(NeoStoreRecord record) throws IOException {
        Command.NeoStoreCommand command = new Command.NeoStoreCommand();
        command.init(record);
        this.write(command);
    }

    public void update(LabelTokenRecord labelToken) throws IOException {
        Command.LabelTokenCommand command = new Command.LabelTokenCommand();
        command.init(labelToken);
        this.write(command);
    }

    public void create(NodeRecord node) throws IOException {
        node.setCreated();
        this.update(new NodeRecord(node.getId(), false, Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue()), node);
    }

    public void create(LabelTokenRecord labelToken) throws IOException {
        labelToken.setCreated();
        this.update(labelToken);
    }

    public void create(PropertyKeyTokenRecord token) throws IOException {
        token.setCreated();
        this.update(token);
    }

    public void create(RelationshipGroupRecord group) throws IOException {
        group.setCreated();
        this.update(group);
    }

    public void update(NodeRecord before, NodeRecord node) throws IOException {
        node.setInUse(true);
        this.add(before, node);
    }

    public void update(PropertyKeyTokenRecord token) throws IOException {
        token.setInUse(true);
        this.add(token);
    }

    public void delete(NodeRecord node) throws IOException {
        node.setInUse(false);
        this.add(node, new NodeRecord(node.getId(), false, Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue()));
    }

    public void create(RelationshipRecord relationship) throws IOException {
        relationship.setCreated();
        this.update(relationship);
    }

    public void delete(RelationshipGroupRecord group) throws IOException {
        group.setInUse(false);
        this.add(group);
    }

    public void createSchema(Collection<DynamicRecord> beforeRecord, Collection<DynamicRecord> afterRecord) throws IOException {
        for (DynamicRecord record : afterRecord) {
            record.setCreated();
        }
        this.updateSchema(beforeRecord, afterRecord);
    }

    public void updateSchema(Collection<DynamicRecord> beforeRecords, Collection<DynamicRecord> afterRecords) throws IOException {
        for (DynamicRecord record : afterRecords) {
            record.setInUse(true);
        }
        this.addSchema(beforeRecords, afterRecords);
    }

    public void update(RelationshipRecord relationship) throws IOException {
        relationship.setInUse(true);
        this.add(relationship);
    }

    public void update(RelationshipGroupRecord group) throws IOException {
        group.setInUse(true);
        this.add(group);
    }

    public void delete(RelationshipRecord relationship) throws IOException {
        relationship.setInUse(false);
        this.add(relationship);
    }

    public void create(PropertyRecord property) throws IOException {
        property.setCreated();
        PropertyRecord before = new PropertyRecord(property.getLongId());
        if (property.isNodeSet()) {
            before.setNodeId(property.getNodeId());
        }
        if (property.isRelSet()) {
            before.setRelId(property.getRelId());
        }
        this.update(before, property);
    }

    public void update(PropertyRecord before, PropertyRecord after) throws IOException {
        after.setInUse(true);
        this.add(before, after);
    }

    public void delete(PropertyRecord before, PropertyRecord after) throws IOException {
        after.setInUse(false);
        this.add(before, after);
    }

    private void addSchema(Collection<DynamicRecord> beforeRecords, Collection<DynamicRecord> afterRecords) throws IOException {
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand();
        command.init(beforeRecords, afterRecords, null, Long.MAX_VALUE);
        this.write(command);
    }

    public void add(NodeRecord before, NodeRecord after) throws IOException {
        Command.NodeCommand command = new Command.NodeCommand();
        command.init(before, after);
        this.write(command);
    }

    public void add(RelationshipRecord relationship) throws IOException {
        Command.RelationshipCommand command = new Command.RelationshipCommand();
        command.init(relationship);
        this.write(command);
    }

    public void add(RelationshipGroupRecord group) throws IOException {
        Command.RelationshipGroupCommand command = new Command.RelationshipGroupCommand();
        command.init(group);
        this.write(command);
    }

    public void add(PropertyRecord before, PropertyRecord property) throws IOException {
        Command.PropertyCommand command = new Command.PropertyCommand();
        command.init(before, property);
        this.write(command);
    }

    public void add(RelationshipTypeTokenRecord record) throws IOException {
        Command.RelationshipTypeTokenCommand command = new Command.RelationshipTypeTokenCommand();
        command.init(record);
        this.write(command);
    }

    public void add(PropertyKeyTokenRecord record) throws IOException {
        Command.PropertyKeyTokenCommand command = new Command.PropertyKeyTokenCommand();
        command.init(record);
        this.write(command);
    }

    public void add(NeoStoreRecord record) throws IOException {
        Command.NeoStoreCommand command = new Command.NeoStoreCommand();
        command.init(record);
        this.write(command);
    }

    private void write(Command command) throws IOException {
        this.output.writeCommand(this.identifier, command);
    }

    private static <T extends TokenRecord> T withName(T record, int[] dynamicIds, String name) {
        if (dynamicIds == null || dynamicIds.length == 0) {
            throw new IllegalArgumentException("No dynamic records for storing the name.");
        }
        record.setInUse(true);
        byte[] data = PropertyStore.encodeString(name);
        if (data.length > dynamicIds.length * 30) {
            throw new IllegalArgumentException(String.format("[%s] is too long to fit in %d blocks", name, dynamicIds.length));
        }
        if (data.length <= (dynamicIds.length - 1) * 30) {
            throw new IllegalArgumentException(String.format("[%s] is to short to fill %d blocks", name, dynamicIds.length));
        }
        for (int i = 0; i < dynamicIds.length; ++i) {
            byte[] part = new byte[Math.min(30, data.length - i * 30)];
            System.arraycopy(data, i * 30, part, 0, part.length);
            DynamicRecord dynamicRecord = new DynamicRecord(dynamicIds[i]);
            dynamicRecord.setInUse(true);
            dynamicRecord.setData(part);
            dynamicRecord.setCreated();
            record.addNameRecord(dynamicRecord);
        }
        record.setNameId(dynamicIds[0]);
        return record;
    }

    public static class CommandCollector
    implements Output {
        private final List<LogEntry> target;

        public CommandCollector(List<LogEntry> target) {
            this.target = target;
        }

        @Override
        public void writeStart(Xid xid, int identifier, int masterId, int myId, long startTimestamp, long latestCommittedTxWhenTxStarted) throws IOException {
            this.add(new LogEntry.Start(xid, identifier, 0, masterId, myId, 16L, startTimestamp, latestCommittedTxWhenTxStarted));
        }

        @Override
        public void writeCommand(int identifier, XaCommand command) throws IOException {
            this.add(new LogEntry.Command(identifier, 0, command));
        }

        @Override
        public void writePrepare(int identifier, long prepareTimestamp) throws IOException {
            this.add(new LogEntry.Prepare(identifier, 0, prepareTimestamp));
        }

        @Override
        public void writeCommit(int identifier, boolean twoPhase, long txId, long commitTimestamp) throws IOException {
            this.add(twoPhase ? new LogEntry.TwoPhaseCommit(identifier, 0, txId, commitTimestamp) : new LogEntry.OnePhaseCommit(identifier, 0, txId, commitTimestamp));
        }

        @Override
        public void writeDone(int identifier) throws IOException {
            this.add(new LogEntry.Done(identifier, 0));
        }

        private void add(LogEntry entry) {
            this.target.add(entry);
        }
    }

    public static class LogBufferOutput
    implements Output {
        private final LogBuffer buffer;
        private final LogEntryWriterv1 logEntryWriter = new LogEntryWriterv1();

        public LogBufferOutput(LogBuffer buffer) {
            this.buffer = buffer;
            this.logEntryWriter.setCommandWriter(new PhysicalLogNeoXaCommandWriter());
        }

        @Override
        public void writeStart(Xid xid, int identifier, int masterId, int myId, long startTimestamp, long latestCommittedTxWhenTxStarted) throws IOException {
            this.logEntryWriter.writeLogEntry(new LogEntry.Start(xid, identifier, masterId, myId, -1L, startTimestamp, latestCommittedTxWhenTxStarted), this.buffer);
        }

        @Override
        public void writeCommand(int identifier, XaCommand command) throws IOException {
            this.logEntryWriter.writeLogEntry(new LogEntry.Command(identifier, command), this.buffer);
        }

        @Override
        public void writePrepare(int identifier, long prepareTimestamp) throws IOException {
            this.logEntryWriter.writeLogEntry(new LogEntry.Prepare(identifier, prepareTimestamp), this.buffer);
        }

        @Override
        public void writeCommit(int identifier, boolean twoPhase, long txId, long commitTimestamp) throws IOException {
            LogEntry.Commit commit = twoPhase ? new LogEntry.TwoPhaseCommit(identifier, txId, commitTimestamp) : new LogEntry.OnePhaseCommit(identifier, txId, commitTimestamp);
            this.logEntryWriter.writeLogEntry(commit, this.buffer);
        }

        @Override
        public void writeDone(int identifier) throws IOException {
            this.logEntryWriter.writeLogEntry(new LogEntry.Done(identifier), this.buffer);
        }
    }

    public static class NeoStoreCommandRecordVisitor
    implements CommandRecordVisitor {
        private final NeoStore neoStore;

        public NeoStoreCommandRecordVisitor(NeoStore neoStore) {
            this.neoStore = neoStore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <RECORD extends AbstractBaseRecord, STORE extends AbstractRecordStore<RECORD>> void update(STORE store, RECORD record) {
            boolean prev = this.neoStore.isInRecoveryMode();
            this.neoStore.setRecoveredStatus(true);
            try {
                store.updateRecord(record);
            }
            finally {
                this.neoStore.setRecoveredStatus(prev);
            }
        }

        @Override
        public void visitNode(NodeRecord record) {
            this.update(this.neoStore.getNodeStore(), record);
        }

        @Override
        public void visitRelationship(RelationshipRecord record) {
            this.update(this.neoStore.getRelationshipStore(), record);
        }

        @Override
        public void visitRelationshipGroup(RelationshipGroupRecord record) {
            this.update(this.neoStore.getRelationshipGroupStore(), record);
        }

        @Override
        public void visitProperty(PropertyRecord record) {
            this.update(this.neoStore.getPropertyStore(), record);
        }

        @Override
        public void visitRelationshipTypeToken(RelationshipTypeTokenRecord record) {
            this.update(this.neoStore.getRelationshipTypeStore(), record);
        }

        @Override
        public void visitLabelToken(LabelTokenRecord record) {
            this.update(this.neoStore.getLabelTokenStore(), record);
        }

        @Override
        public void visitPropertyKeyToken(PropertyKeyTokenRecord record) {
            this.update(this.neoStore.getPropertyStore().getPropertyKeyTokenStore(), record);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitNeoStore(NeoStoreRecord record) {
            boolean prev = this.neoStore.isInRecoveryMode();
            this.neoStore.setRecoveredStatus(true);
            try {
                this.neoStore.setGraphNextProp(record.getNextProp());
            }
            finally {
                this.neoStore.setRecoveredStatus(prev);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitSchemaRule(Collection<DynamicRecord> records) {
            boolean prev = this.neoStore.isInRecoveryMode();
            this.neoStore.setRecoveredStatus(true);
            try {
                SchemaStore schemaStore = this.neoStore.getSchemaStore();
                for (DynamicRecord record : records) {
                    schemaStore.updateRecord(record);
                }
            }
            finally {
                this.neoStore.setRecoveredStatus(prev);
            }
        }
    }

    public static class RecordOutput
    implements Output {
        private final CommandRecordVisitor visitor;

        public RecordOutput(CommandRecordVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public void writeStart(Xid xid, int identifier, int masterId, int myId, long startTimestamp, long latestCommittedTxWhenTxStarted) throws IOException {
        }

        @Override
        public void writeCommand(int identifier, XaCommand command) throws IOException {
            ((Command)command).accept(this.visitor);
        }

        @Override
        public void writePrepare(int identifier, long prepareTimestamp) throws IOException {
        }

        @Override
        public void writeCommit(int identifier, boolean twoPhase, long txId, long commitTimestamp) throws IOException {
        }

        @Override
        public void writeDone(int identifier) throws IOException {
        }
    }

    public static interface Output {
        public void writeStart(Xid var1, int var2, int var3, int var4, long var5, long var7) throws IOException;

        public void writeCommand(int var1, XaCommand var2) throws IOException;

        public void writePrepare(int var1, long var2) throws IOException;

        public void writeCommit(int var1, boolean var2, long var3, long var5) throws IOException;

        public void writeDone(int var1) throws IOException;
    }
}

