/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.TxState;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.state.GraphState;
import org.neo4j.kernel.impl.api.state.LabelState;
import org.neo4j.kernel.impl.api.state.NodeState;
import org.neo4j.kernel.impl.api.state.OldTxStateBridge;
import org.neo4j.kernel.impl.api.state.PropertyChanges;
import org.neo4j.kernel.impl.api.state.PropertyContainerState;
import org.neo4j.kernel.impl.api.state.RelationshipState;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.util.DiffSets;

public final class TxStateImpl
implements TxState {
    private static final StateCreator<LabelState> LABEL_STATE_CREATOR = new StateCreator<LabelState>(){

        @Override
        public LabelState newState(long id) {
            return new LabelState(id);
        }
    };
    private static final StateCreator<NodeState> NODE_STATE_CREATOR = new StateCreator<NodeState>(){

        @Override
        public NodeState newState(long id) {
            return new NodeState(id);
        }
    };
    private static final StateCreator<RelationshipState> RELATIONSHIP_STATE_CREATOR = new StateCreator<RelationshipState>(){

        @Override
        public RelationshipState newState(long id) {
            return new RelationshipState(id);
        }
    };
    private Map<Long, NodeState> nodeStatesMap;
    private Map<Long, RelationshipState> relationshipStatesMap;
    private Map<Long, LabelState> labelStatesMap;
    private GraphState graphState;
    private DiffSets<IndexDescriptor> indexChanges;
    private DiffSets<IndexDescriptor> constraintIndexChanges;
    private DiffSets<UniquenessConstraint> constraintsChanges;
    private PropertyChanges propertyChangesForNodes;
    private DiffSets<Long> nodes;
    private DiffSets<Long> relationships;
    private final Set<Long> nodesCreatedAndDeletedInTx = new HashSet<Long>();
    private final Set<Long> relsCreatedAndDeletedInTx = new HashSet<Long>();
    private Map<UniquenessConstraint, Long> createdConstraintIndexesByConstraint;
    private final OldTxStateBridge legacyState;
    private final PersistenceManager persistenceManager;
    private final TxState.IdGeneration idGeneration;
    private boolean hasChanges;

    public TxStateImpl(OldTxStateBridge legacyState, PersistenceManager legacyTransaction, TxState.IdGeneration idGeneration) {
        this.legacyState = legacyState;
        this.persistenceManager = legacyTransaction;
        this.idGeneration = idGeneration;
    }

    @Override
    public void accept(final TxState.Visitor visitor) {
        if (this.hasNodeStatesMap() && !this.nodeStatesMap().isEmpty()) {
            for (NodeState node : this.modifiedNodes()) {
                node.accept(TxStateImpl.nodeVisitor(visitor));
            }
        }
        if (this.hasRelationshipsStatesMap() && !this.relationshipStatesMap().isEmpty()) {
            for (RelationshipState rel : this.modifiedRelationships()) {
                rel.accept(TxStateImpl.relVisitor(visitor));
            }
        }
        if (this.graphState != null) {
            this.graphState.accept(TxStateImpl.graphPropertyVisitor(visitor));
        }
        if (this.hasIndexChangesDiffSets() && !this.indexChanges().isEmpty()) {
            this.indexChanges().accept(TxStateImpl.indexVisitor(visitor, false));
        }
        if (this.hasConstraintIndexChangesDiffSets() && !this.constraintIndexChanges().isEmpty()) {
            this.constraintIndexChanges().accept(TxStateImpl.indexVisitor(visitor, true));
        }
        if (this.hasConstraintsChangesDiffSets() && !this.constraintsChanges().isEmpty()) {
            this.constraintsChanges().accept(new DiffSets.Visitor<UniquenessConstraint>(){

                @Override
                public void visitAdded(UniquenessConstraint element) {
                    visitor.visitAddedConstraint(element);
                }

                @Override
                public void visitRemoved(UniquenessConstraint element) {
                    visitor.visitRemovedConstraint(element);
                }
            });
        }
    }

    private static DiffSets.Visitor<IndexDescriptor> indexVisitor(final TxState.Visitor visitor, final boolean forConstraint) {
        return new DiffSets.Visitor<IndexDescriptor>(){

            @Override
            public void visitAdded(IndexDescriptor element) {
                visitor.visitAddedIndex(element, forConstraint);
            }

            @Override
            public void visitRemoved(IndexDescriptor element) {
                visitor.visitRemovedIndex(element, forConstraint);
            }
        };
    }

    private static NodeState.Visitor nodeVisitor(final TxState.Visitor visitor) {
        return new NodeState.Visitor(){

            @Override
            public void visitLabelChanges(long nodeId, Iterator<Integer> added, Iterator<Integer> removed) {
                visitor.visitNodeLabelChanges(nodeId, added, removed);
            }

            @Override
            public void visitPropertyChanges(long entityId, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
                visitor.visitNodePropertyChanges(entityId, added, changed, removed);
            }
        };
    }

    private static PropertyContainerState.Visitor relVisitor(final TxState.Visitor visitor) {
        return new PropertyContainerState.Visitor(){

            @Override
            public void visitPropertyChanges(long entityId, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
                visitor.visitRelPropertyChanges(entityId, added, changed, removed);
            }
        };
    }

    private static PropertyContainerState.Visitor graphPropertyVisitor(final TxState.Visitor visitor) {
        return new PropertyContainerState.Visitor(){

            @Override
            public void visitPropertyChanges(long entityId, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
                visitor.visitGraphPropertyChanges(added, changed, removed);
            }
        };
    }

    @Override
    public boolean hasChanges() {
        return this.hasChanges || this.legacyState.hasChanges();
    }

    @Override
    public Iterable<NodeState> modifiedNodes() {
        return this.hasNodeStatesMap() ? this.nodeStatesMap().values() : Iterables.empty();
    }

    @Override
    public DiffSets<Long> labelStateNodeDiffSets(int labelId) {
        return this.getOrCreateLabelState(labelId).getNodeDiffSets();
    }

    @Override
    public DiffSets<Integer> nodeStateLabelDiffSets(long nodeId) {
        return this.getOrCreateNodeState(nodeId).labelDiffSets();
    }

    @Override
    public Iterator<DefinedProperty> augmentNodeProperties(long nodeId, Iterator<DefinedProperty> original) {
        NodeState state;
        if (this.nodeStatesMap != null && (state = this.nodeStatesMap.get(nodeId)) != null) {
            return state.augmentProperties(original);
        }
        return original;
    }

    @Override
    public Iterator<DefinedProperty> augmentRelProperties(long relId, Iterator<DefinedProperty> original) {
        RelationshipState state;
        if (this.relationshipStatesMap != null && (state = this.relationshipStatesMap.get(relId)) != null) {
            return state.augmentProperties(original);
        }
        return original;
    }

    @Override
    public Iterator<DefinedProperty> augmentGraphProperties(Iterator<DefinedProperty> original) {
        if (this.graphState != null) {
            return this.graphState.augmentProperties(original);
        }
        return original;
    }

    @Override
    public Iterator<DefinedProperty> addedAndChangedNodeProperties(long nodeId) {
        NodeState state;
        if (this.nodeStatesMap != null && (state = this.nodeStatesMap.get(nodeId)) != null) {
            return state.addedAndChangedProperties();
        }
        return IteratorUtil.emptyIterator();
    }

    @Override
    public Iterator<DefinedProperty> addedAndChangedRelProperties(long relId) {
        RelationshipState state;
        if (this.relationshipStatesMap != null && (state = this.relationshipStatesMap.get(relId)) != null) {
            return state.addedAndChangedProperties();
        }
        return IteratorUtil.emptyIterator();
    }

    @Override
    public boolean nodeIsAddedInThisTx(long nodeId) {
        return this.hasNodesAddedOrRemoved() && this.nodes.isAdded(nodeId);
    }

    @Override
    public boolean relationshipIsAddedInThisTx(long relationshipId) {
        return this.hasRelsAddedOrRemoved() && this.relationships.isAdded(relationshipId);
    }

    @Override
    public long nodeDoCreate() {
        long id = this.legacyState.nodeCreate();
        this.addedAndRemovedNodes().add(id);
        this.hasChanges = true;
        return id;
    }

    @Override
    public void nodeDoDelete(long nodeId) {
        NodeState nodeState;
        this.legacyState.deleteNode(nodeId);
        if (this.addedAndRemovedNodes().remove(nodeId)) {
            this.nodesCreatedAndDeletedInTx.add(nodeId);
        }
        if (this.hasNodeStatesMap() && (nodeState = this.nodeStatesMap.remove(nodeId)) != null) {
            DiffSets<Integer> diff = nodeState.labelDiffSets();
            for (Integer label : diff.getAdded()) {
                this.labelStateNodeDiffSets(label).remove(nodeId);
            }
            nodeState.clear();
        }
        this.hasChanges = true;
    }

    @Override
    public long relationshipDoCreate(int relationshipTypeId, long startNodeId, long endNodeId) {
        long id = this.legacyState.relationshipCreate(relationshipTypeId, startNodeId, endNodeId);
        this.addedAndRemovedRels().add(id);
        if (startNodeId == endNodeId) {
            this.getOrCreateNodeState(startNodeId).addRelationship(id, relationshipTypeId, Direction.BOTH);
        } else {
            this.getOrCreateNodeState(startNodeId).addRelationship(id, relationshipTypeId, Direction.OUTGOING);
            this.getOrCreateNodeState(endNodeId).addRelationship(id, relationshipTypeId, Direction.INCOMING);
        }
        this.getOrCreateRelationshipState(id).setMetaData(startNodeId, endNodeId, relationshipTypeId);
        this.hasChanges = true;
        return id;
    }

    @Override
    public boolean nodeIsDeletedInThisTx(long nodeId) {
        return this.hasNodesAddedOrRemoved() && this.addedAndRemovedNodes().isRemoved(nodeId) || this.nodesCreatedAndDeletedInTx.contains(nodeId);
    }

    @Override
    public boolean nodeModifiedInThisTx(long nodeId) {
        return this.nodeIsAddedInThisTx(nodeId) || this.nodeIsDeletedInThisTx(nodeId) || this.hasNodeState(nodeId);
    }

    @Override
    public void relationshipDoDelete(long id, long startNodeId, long endNodeId, int type) {
        RelationshipState removed;
        this.legacyState.deleteRelationship(id);
        if (this.addedAndRemovedRels().remove(id)) {
            this.relsCreatedAndDeletedInTx.add(id);
        }
        if (startNodeId == endNodeId) {
            this.getOrCreateNodeState(startNodeId).removeRelationship(id, type, Direction.BOTH);
        } else {
            this.getOrCreateNodeState(startNodeId).removeRelationship(id, type, Direction.OUTGOING);
            this.getOrCreateNodeState(endNodeId).removeRelationship(id, type, Direction.INCOMING);
        }
        if (this.hasRelationshipsStatesMap() && (removed = this.relationshipStatesMap.remove(id)) != null) {
            removed.clear();
        }
        this.hasChanges = true;
    }

    @Override
    public void relationshipDoDeleteAddedInThisTx(long relationshipId) {
        RelationshipState state = this.getOrCreateRelationshipState(relationshipId);
        this.relationshipDoDelete(relationshipId, state.startNode(), state.endNode(), state.type());
    }

    @Override
    public boolean relationshipIsDeletedInThisTx(long relationshipId) {
        return this.hasDeletedRelationshipsDiffSets() && this.addedAndRemovedRels().isRemoved(relationshipId) || this.relsCreatedAndDeletedInTx.contains(relationshipId);
    }

    @Override
    public void nodeDoReplaceProperty(long nodeId, Property replacedProperty, DefinedProperty newProperty) {
        if (replacedProperty.isDefined()) {
            this.getOrCreateNodeState(nodeId).changeProperty(newProperty);
            this.nodePropertyChanges().changeProperty(nodeId, replacedProperty.propertyKeyId(), ((DefinedProperty)replacedProperty).value(), newProperty.value());
        } else {
            this.getOrCreateNodeState(nodeId).addProperty(newProperty);
            this.nodePropertyChanges().addProperty(nodeId, newProperty.propertyKeyId(), newProperty.value());
        }
        this.legacyState.nodeSetProperty(nodeId, newProperty);
        this.hasChanges = true;
    }

    @Override
    public void relationshipDoReplaceProperty(long relationshipId, Property replacedProperty, DefinedProperty newProperty) {
        if (replacedProperty.isDefined()) {
            this.getOrCreateRelationshipState(relationshipId).changeProperty(newProperty);
        } else {
            this.getOrCreateRelationshipState(relationshipId).addProperty(newProperty);
        }
        this.legacyState.relationshipSetProperty(relationshipId, newProperty);
        this.hasChanges = true;
    }

    @Override
    public void graphDoReplaceProperty(Property replacedProperty, DefinedProperty newProperty) {
        if (replacedProperty.isDefined()) {
            this.getOrCreateGraphState().changeProperty(newProperty);
        } else {
            this.getOrCreateGraphState().addProperty(newProperty);
        }
        this.legacyState.graphSetProperty(newProperty);
        this.hasChanges = true;
    }

    @Override
    public void nodeDoRemoveProperty(long nodeId, DefinedProperty removedProperty) {
        this.getOrCreateNodeState(nodeId).removeProperty(removedProperty.propertyKeyId());
        this.nodePropertyChanges().removeProperty(nodeId, removedProperty.propertyKeyId(), removedProperty.value());
        this.legacyState.nodeRemoveProperty(nodeId, removedProperty);
        this.hasChanges = true;
    }

    @Override
    public void relationshipDoRemoveProperty(long relationshipId, DefinedProperty removedProperty) {
        this.getOrCreateRelationshipState(relationshipId).removeProperty(removedProperty.propertyKeyId());
        this.legacyState.relationshipRemoveProperty(relationshipId, removedProperty);
        this.hasChanges = true;
    }

    @Override
    public void graphDoRemoveProperty(DefinedProperty removedProperty) {
        this.getOrCreateGraphState().removeProperty(removedProperty.propertyKeyId());
        this.legacyState.graphRemoveProperty(removedProperty);
        this.hasChanges = true;
    }

    @Override
    public void nodeDoAddLabel(int labelId, long nodeId) {
        this.labelStateNodeDiffSets(labelId).add(nodeId);
        this.nodeStateLabelDiffSets(nodeId).add(labelId);
        this.persistenceManager.addLabelToNode(labelId, nodeId);
        this.hasChanges = true;
    }

    @Override
    public void nodeDoRemoveLabel(int labelId, long nodeId) {
        this.labelStateNodeDiffSets(labelId).remove(nodeId);
        this.nodeStateLabelDiffSets(nodeId).remove(labelId);
        this.persistenceManager.removeLabelFromNode(labelId, nodeId);
        this.hasChanges = true;
    }

    @Override
    public TxState.UpdateTriState labelState(long nodeId, int labelId) {
        NodeState nodeState = this.getState(this.nodeStatesMap(), nodeId, null);
        if (nodeState != null) {
            DiffSets<Integer> labelDiff = nodeState.labelDiffSets();
            if (labelDiff.isAdded(labelId)) {
                return TxState.UpdateTriState.ADDED;
            }
            if (labelDiff.isRemoved(labelId)) {
                return TxState.UpdateTriState.REMOVED;
            }
        }
        return TxState.UpdateTriState.UNTOUCHED;
    }

    @Override
    public Set<Long> nodesWithLabelAdded(int labelId) {
        LabelState state;
        if (this.hasLabelStatesMap() && null != (state = this.getState(this.labelStatesMap, labelId, null))) {
            return state.getNodeDiffSets().getAdded();
        }
        return Collections.emptySet();
    }

    @Override
    public DiffSets<Long> nodesWithLabelChanged(int labelId) {
        LabelState state;
        if (this.hasLabelStatesMap() && null != (state = this.getState(this.labelStatesMap, labelId, null))) {
            return state.getNodeDiffSets();
        }
        return DiffSets.emptyDiffSets();
    }

    @Override
    public void indexRuleDoAdd(IndexDescriptor descriptor) {
        DiffSets<IndexDescriptor> diff = this.indexChanges();
        if (diff.unRemove(descriptor)) {
            this.getOrCreateLabelState(descriptor.getLabelId()).indexChanges().unRemove(descriptor);
        } else {
            this.indexChanges().add(descriptor);
            this.getOrCreateLabelState(descriptor.getLabelId()).indexChanges().add(descriptor);
        }
        this.hasChanges = true;
    }

    @Override
    public void constraintIndexRuleDoAdd(IndexDescriptor descriptor) {
        this.constraintIndexChanges().add(descriptor);
        this.getOrCreateLabelState(descriptor.getLabelId()).constraintIndexChanges().add(descriptor);
        this.hasChanges = true;
    }

    @Override
    public void indexDoDrop(IndexDescriptor descriptor) {
        this.indexChanges().remove(descriptor);
        this.getOrCreateLabelState(descriptor.getLabelId()).indexChanges().remove(descriptor);
        this.hasChanges = true;
    }

    @Override
    public void constraintIndexDoDrop(IndexDescriptor descriptor) {
        this.constraintIndexChanges().remove(descriptor);
        this.getOrCreateLabelState(descriptor.getLabelId()).constraintIndexChanges().remove(descriptor);
        this.hasChanges = true;
    }

    @Override
    public DiffSets<IndexDescriptor> indexDiffSetsByLabel(int labelId) {
        LabelState labelState;
        if (this.hasLabelStatesMap() && null != (labelState = this.getState(this.labelStatesMap, labelId, null))) {
            return labelState.indexChanges();
        }
        return DiffSets.emptyDiffSets();
    }

    @Override
    public DiffSets<IndexDescriptor> constraintIndexDiffSetsByLabel(int labelId) {
        LabelState labelState;
        if (this.hasLabelStatesMap() && (labelState = this.getState(this.labelStatesMap(), labelId, null)) != null) {
            return labelState.constraintIndexChanges();
        }
        return DiffSets.emptyDiffSets();
    }

    @Override
    public DiffSets<IndexDescriptor> indexChanges() {
        if (!this.hasIndexChangesDiffSets()) {
            this.indexChanges = new DiffSets();
        }
        return this.indexChanges;
    }

    private boolean hasIndexChangesDiffSets() {
        return this.indexChanges != null;
    }

    @Override
    public DiffSets<IndexDescriptor> constraintIndexChanges() {
        if (!this.hasConstraintIndexChangesDiffSets()) {
            this.constraintIndexChanges = new DiffSets();
        }
        return this.constraintIndexChanges;
    }

    private boolean hasConstraintIndexChangesDiffSets() {
        return this.constraintIndexChanges != null;
    }

    @Override
    public DiffSets<Long> nodesWithChangedProperty(int propertyKeyId, Object value) {
        return this.propertyChangesForNodes != null ? this.propertyChangesForNodes.changesForProperty(propertyKeyId, value) : DiffSets.emptyDiffSets();
    }

    @Override
    public DiffSets<Long> addedAndRemovedNodes() {
        if (!this.hasNodesAddedOrRemoved()) {
            this.nodes = new DiffSets();
        }
        return this.nodes;
    }

    private boolean hasNodesAddedOrRemoved() {
        return this.nodes != null;
    }

    private boolean hasRelsAddedOrRemoved() {
        return this.relationships != null;
    }

    @Override
    public PrimitiveLongIterator augmentRelationships(long nodeId, Direction direction, PrimitiveLongIterator rels) {
        if (this.hasNodeState(nodeId)) {
            rels = this.getOrCreateNodeState(nodeId).augmentRelationships(direction, rels);
            if (this.hasDeletedRelationshipsDiffSets()) {
                rels = this.addedAndRemovedRels().augmentWithRemovals(rels);
            }
        }
        return rels;
    }

    @Override
    public PrimitiveLongIterator augmentRelationships(long nodeId, Direction direction, int[] types, PrimitiveLongIterator rels) {
        if (this.hasNodeState(nodeId)) {
            rels = this.getOrCreateNodeState(nodeId).augmentRelationships(direction, types, rels);
            if (this.hasDeletedRelationshipsDiffSets()) {
                rels = this.addedAndRemovedRels().augmentWithRemovals(rels);
            }
        }
        return rels;
    }

    @Override
    public int augmentNodeDegree(long nodeId, int degree, Direction direction) {
        if (this.hasNodeState(nodeId)) {
            return this.getOrCreateNodeState(nodeId).augmentDegree(direction, degree);
        }
        return degree;
    }

    @Override
    public int augmentNodeDegree(long nodeId, int degree, Direction direction, int typeId) {
        if (this.hasNodeState(nodeId)) {
            return this.getOrCreateNodeState(nodeId).augmentDegree(direction, degree, typeId);
        }
        return degree;
    }

    @Override
    public PrimitiveIntIterator nodeRelationshipTypes(long nodeId) {
        if (this.hasNodeState(nodeId)) {
            return this.getOrCreateNodeState(nodeId).relationshipTypes();
        }
        return PrimitiveIntCollections.emptyIterator();
    }

    @Override
    public DiffSets<Long> addedAndRemovedRels() {
        if (!this.hasDeletedRelationshipsDiffSets()) {
            this.relationships = new DiffSets();
        }
        return this.relationships;
    }

    @Override
    public Iterable<RelationshipState> modifiedRelationships() {
        return this.relationshipStatesMap != null ? this.relationshipStatesMap.values() : Iterables.empty();
    }

    private boolean hasDeletedRelationshipsDiffSets() {
        return this.relationships != null;
    }

    private LabelState getOrCreateLabelState(int labelId) {
        return this.getState(this.labelStatesMap(), labelId, LABEL_STATE_CREATOR);
    }

    private NodeState getOrCreateNodeState(long nodeId) {
        return this.getState(this.nodeStatesMap(), nodeId, NODE_STATE_CREATOR);
    }

    private RelationshipState getOrCreateRelationshipState(long relationshipId) {
        return this.getState(this.relationshipStatesMap(), relationshipId, RELATIONSHIP_STATE_CREATOR);
    }

    private GraphState getOrCreateGraphState() {
        if (this.graphState == null) {
            this.graphState = new GraphState();
        }
        return this.graphState;
    }

    private <STATE> STATE getState(Map<Long, STATE> states, long id, StateCreator<STATE> creator) {
        STATE result = states.get(id);
        if (result != null) {
            return result;
        }
        if (creator != null) {
            result = creator.newState(id);
            states.put(id, result);
            this.hasChanges = true;
        }
        return result;
    }

    @Override
    public void constraintDoAdd(UniquenessConstraint constraint, long indexId) {
        this.constraintsChanges().add(constraint);
        this.createdConstraintIndexesByConstraint().put(constraint, indexId);
        this.getOrCreateLabelState(constraint.label()).constraintsChanges().add(constraint);
        this.hasChanges = true;
    }

    @Override
    public DiffSets<UniquenessConstraint> constraintsChangesForLabelAndProperty(int labelId, final int propertyKey) {
        return this.getOrCreateLabelState(labelId).constraintsChanges().filterAdded(new Predicate<UniquenessConstraint>(){

            @Override
            public boolean accept(UniquenessConstraint item) {
                return item.propertyKeyId() == propertyKey;
            }
        });
    }

    @Override
    public DiffSets<UniquenessConstraint> constraintsChangesForLabel(int labelId) {
        return this.getOrCreateLabelState(labelId).constraintsChanges();
    }

    @Override
    public DiffSets<UniquenessConstraint> constraintsChanges() {
        if (!this.hasConstraintsChangesDiffSets()) {
            this.constraintsChanges = new DiffSets();
        }
        return this.constraintsChanges;
    }

    private boolean hasConstraintsChangesDiffSets() {
        return this.constraintsChanges != null;
    }

    @Override
    public void constraintDoDrop(UniquenessConstraint constraint) {
        this.constraintsChanges().remove(constraint);
        this.constraintIndexDoDrop(new IndexDescriptor(constraint.label(), constraint.propertyKeyId()));
        this.constraintsChangesForLabel(constraint.label()).remove(constraint);
        this.hasChanges = true;
    }

    @Override
    public boolean constraintDoUnRemove(UniquenessConstraint constraint) {
        if (this.constraintsChanges().unRemove(constraint)) {
            this.constraintsChangesForLabel(constraint.label()).unRemove(constraint);
            return true;
        }
        return false;
    }

    @Override
    public boolean constraintIndexDoUnRemove(IndexDescriptor index) {
        if (this.constraintIndexChanges().unRemove(index)) {
            this.constraintIndexDiffSetsByLabel(index.getLabelId()).unRemove(index);
            return true;
        }
        return false;
    }

    @Override
    public Iterable<IndexDescriptor> constraintIndexesCreatedInTx() {
        Map<UniquenessConstraint, Long> constraintMap;
        if (this.hasCreatedConstraintIndexesMap() && !(constraintMap = this.createdConstraintIndexesByConstraint()).isEmpty()) {
            return Iterables.map(new Function<UniquenessConstraint, IndexDescriptor>(){

                @Override
                public IndexDescriptor apply(UniquenessConstraint constraint) {
                    return new IndexDescriptor(constraint.label(), constraint.propertyKeyId());
                }
            }, constraintMap.keySet());
        }
        return Iterables.empty();
    }

    @Override
    public Long indexCreatedForConstraint(UniquenessConstraint constraint) {
        return this.createdConstraintIndexesByConstraint == null ? null : this.createdConstraintIndexesByConstraint.get(constraint);
    }

    private Map<UniquenessConstraint, Long> createdConstraintIndexesByConstraint() {
        if (!this.hasCreatedConstraintIndexesMap()) {
            this.createdConstraintIndexesByConstraint = new HashMap<UniquenessConstraint, Long>();
        }
        return this.createdConstraintIndexesByConstraint;
    }

    private boolean hasCreatedConstraintIndexesMap() {
        return null != this.createdConstraintIndexesByConstraint;
    }

    private boolean hasNodeState(long nodeId) {
        return this.hasNodeStatesMap() && this.nodeStatesMap().containsKey(nodeId);
    }

    private Map<Long, NodeState> nodeStatesMap() {
        if (!this.hasNodeStatesMap()) {
            this.nodeStatesMap = new HashMap<Long, NodeState>();
        }
        return this.nodeStatesMap;
    }

    private boolean hasNodeStatesMap() {
        return null != this.nodeStatesMap;
    }

    private Map<Long, RelationshipState> relationshipStatesMap() {
        if (!this.hasRelationshipsStatesMap()) {
            this.relationshipStatesMap = new HashMap<Long, RelationshipState>();
        }
        return this.relationshipStatesMap;
    }

    private boolean hasRelationshipsStatesMap() {
        return null != this.relationshipStatesMap;
    }

    private Map<Long, LabelState> labelStatesMap() {
        if (!this.hasLabelStatesMap()) {
            this.labelStatesMap = new HashMap<Long, LabelState>();
        }
        return this.labelStatesMap;
    }

    private boolean hasLabelStatesMap() {
        return null != this.labelStatesMap;
    }

    private PropertyChanges nodePropertyChanges() {
        return this.propertyChangesForNodes == null ? (this.propertyChangesForNodes = new PropertyChanges()) : this.propertyChangesForNodes;
    }

    private static interface StateCreator<STATE> {
        public STATE newState(long var1);
    }
}

