/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.neo4j.kernel.impl.util.PrimitiveIntIterator;

public class PrimitiveIntIteratorForArray
implements PrimitiveIntIterator {
    private final int[] values;
    int i = 0;
    public static final int[] EMPTY_INT_ARRAY = new int[0];

    public PrimitiveIntIteratorForArray(int ... values) {
        this.values = values;
    }

    @Override
    public boolean hasNext() {
        return this.i < this.values.length;
    }

    @Override
    public int next() {
        if (this.hasNext()) {
            return this.values[this.i++];
        }
        throw new NoSuchElementException();
    }

    public static int[] primitiveIntIteratorToIntArray(PrimitiveIntIterator iterator) {
        if (!iterator.hasNext()) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[5];
        int cursor = 0;
        while (iterator.hasNext()) {
            if (cursor >= result.length) {
                result = Arrays.copyOf(result, result.length * 2);
            }
            result[cursor++] = iterator.next();
        }
        return cursor == result.length ? result : Arrays.copyOf(result, cursor);
    }
}

