/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyLogCommandReader;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.IllegalLogFormatException;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.ReadPastEndException;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;

public class LegacyLogIoUtil {
    private static final short LEGACY_FORMAT_VERSION = 2;
    static final int LOG_HEADER_SIZE = 16;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] readLogHeader(FileSystemAbstraction fileSystem, File file) throws IOException {
        try (StoreChannel channel = fileSystem.open(file, "r");){
            long[] lArray = LegacyLogIoUtil.readLogHeader(ByteBuffer.allocateDirect(100000), channel, true);
            return lArray;
        }
    }

    public static long[] readLogHeader(ByteBuffer buffer, ReadableByteChannel channel, boolean strict) throws IOException {
        buffer.clear();
        buffer.limit(16);
        if (channel.read(buffer) != 16) {
            if (strict) {
                throw new IOException("Unable to read log version and last committed tx");
            }
            return null;
        }
        buffer.flip();
        long version = buffer.getLong();
        long previousCommittedTx = buffer.getLong();
        long logFormatVersion = version >> 56 & 0xFFL;
        if (2L != logFormatVersion) {
            throw new IllegalLogFormatException(2L, logFormatVersion);
        }
        return new long[]{version &= 0xFFFFFFFFFFFFFFL, previousCommittedTx};
    }

    public static LogEntry readEntry(ByteBuffer buffer, ReadableByteChannel channel, LegacyLogCommandReader commandReader) throws IOException {
        try {
            return LegacyLogIoUtil.readLogEntry(buffer, channel, commandReader);
        }
        catch (ReadPastEndException e) {
            return null;
        }
    }

    public static LogEntry readLogEntry(ByteBuffer buffer, ReadableByteChannel channel, LegacyLogCommandReader commandReader) throws IOException, ReadPastEndException {
        byte entry = LegacyLogIoUtil.readNextByte(buffer, channel);
        switch (entry) {
            case 1: {
                return LegacyLogIoUtil.readTxStartEntry(buffer, channel);
            }
            case 2: {
                return LegacyLogIoUtil.readTxPrepareEntry(buffer, channel);
            }
            case 5: {
                return LegacyLogIoUtil.readTxOnePhaseCommitEntry(buffer, channel);
            }
            case 6: {
                return LegacyLogIoUtil.readTxTwoPhaseCommitEntry(buffer, channel);
            }
            case 3: {
                return LegacyLogIoUtil.readTxCommandEntry(buffer, channel, commandReader);
            }
            case 4: {
                return LegacyLogIoUtil.readTxDoneEntry(buffer, channel);
            }
            case 0: {
                return null;
            }
        }
        throw new IOException("Unknown entry[" + entry + "]");
    }

    private static LogEntry.Start readTxStartEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        byte globalIdLength = LegacyLogIoUtil.readNextByte(buf, channel);
        byte branchIdLength = LegacyLogIoUtil.readNextByte(buf, channel);
        byte[] globalId = new byte[globalIdLength];
        LegacyLogIoUtil.readIntoBufferAndFlip(ByteBuffer.wrap(globalId), channel, globalIdLength);
        byte[] branchId = new byte[branchIdLength];
        LegacyLogIoUtil.readIntoBufferAndFlip(ByteBuffer.wrap(branchId), channel, branchIdLength);
        int identifier = LegacyLogIoUtil.readNextInt(buf, channel);
        int formatId = LegacyLogIoUtil.readNextInt(buf, channel);
        int masterId = LegacyLogIoUtil.readNextInt(buf, channel);
        int myId = LegacyLogIoUtil.readNextInt(buf, channel);
        long timeWritten = LegacyLogIoUtil.readNextLong(buf, channel);
        XidImpl xid = new XidImpl(globalId, branchId);
        return new LogEntry.Start(xid, identifier, masterId, myId, -1L, timeWritten, 0L);
    }

    private static LogEntry.Prepare readTxPrepareEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.Prepare(LegacyLogIoUtil.readNextInt(buf, channel), LegacyLogIoUtil.readNextLong(buf, channel));
    }

    private static LogEntry.OnePhaseCommit readTxOnePhaseCommitEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.OnePhaseCommit(LegacyLogIoUtil.readNextInt(buf, channel), LegacyLogIoUtil.readNextLong(buf, channel), LegacyLogIoUtil.readNextLong(buf, channel));
    }

    private static LogEntry.Done readTxDoneEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.Done(LegacyLogIoUtil.readNextInt(buf, channel));
    }

    private static LogEntry.TwoPhaseCommit readTxTwoPhaseCommitEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.TwoPhaseCommit(LegacyLogIoUtil.readNextInt(buf, channel), LegacyLogIoUtil.readNextLong(buf, channel), LegacyLogIoUtil.readNextLong(buf, channel));
    }

    private static LogEntry.Command readTxCommandEntry(ByteBuffer buf, ReadableByteChannel channel, LegacyLogCommandReader commandReader) throws IOException, ReadPastEndException {
        int identifier = LegacyLogIoUtil.readNextInt(buf, channel);
        XaCommand command = commandReader.readCommand(channel, buf);
        if (command == null) {
            return null;
        }
        return new LogEntry.Command(identifier, command);
    }

    private static int readNextInt(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return LegacyLogIoUtil.readIntoBufferAndFlip(buf, channel, 4).getInt();
    }

    private static long readNextLong(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return LegacyLogIoUtil.readIntoBufferAndFlip(buf, channel, 8).getLong();
    }

    public static byte readNextByte(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return LegacyLogIoUtil.readIntoBufferAndFlip(buf, channel, 1).get();
    }

    private static ByteBuffer readIntoBufferAndFlip(ByteBuffer buf, ReadableByteChannel channel, int numberOfBytes) throws IOException, ReadPastEndException {
        buf.clear();
        buf.limit(numberOfBytes);
        if (channel.read(buf) != buf.limit()) {
            throw new ReadPastEndException();
        }
        buf.flip();
        return buf;
    }
}

