/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.api.index.IndexUpdates;
import org.neo4j.kernel.impl.api.index.UpdateMode;
import org.neo4j.kernel.impl.core.IteratingPropertyReceiver;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransaction;

class LazyIndexUpdates
implements IndexUpdates {
    private final NodeStore nodeStore;
    private final PropertyStore propertyStore;
    private final Map<Long, List<Command.PropertyCommand>> propCommands;
    private final Map<Long, Command.NodeCommand> nodeCommands;
    private Collection<NodePropertyUpdate> updates;

    public LazyIndexUpdates(NodeStore nodeStore, PropertyStore propertyStore, Map<Long, List<Command.PropertyCommand>> propCommands, Map<Long, Command.NodeCommand> nodeCommands) {
        this.nodeStore = nodeStore;
        this.propertyStore = propertyStore;
        this.propCommands = propCommands;
        this.nodeCommands = nodeCommands;
    }

    @Override
    public Iterator<NodePropertyUpdate> iterator() {
        if (this.updates == null) {
            this.updates = this.gatherPropertyAndLabelUpdates();
        }
        return this.updates.iterator();
    }

    @Override
    public Set<Long> changedNodeIds() {
        HashSet<Long> nodeIds = new HashSet<Long>(this.nodeCommands.keySet());
        for (List<Command.PropertyCommand> propCmd : this.propCommands.values()) {
            PropertyRecord record = propCmd.get(0).getAfter();
            if (!record.isNodeSet()) continue;
            nodeIds.add(record.getNodeId());
        }
        return nodeIds;
    }

    private Collection<NodePropertyUpdate> gatherPropertyAndLabelUpdates() {
        HashSet<NodePropertyUpdate> propertyUpdates = new HashSet<NodePropertyUpdate>();
        HashMap<Pair<Long, Integer>, NodePropertyUpdate> propertyChanges = new HashMap<Pair<Long, Integer>, NodePropertyUpdate>();
        this.gatherUpdatesFromPropertyCommands(propertyUpdates, propertyChanges);
        this.gatherUpdatesFromNodeCommands(propertyUpdates, propertyChanges);
        return propertyUpdates;
    }

    private void gatherUpdatesFromPropertyCommands(Collection<NodePropertyUpdate> updates, Map<Pair<Long, Integer>, NodePropertyUpdate> propertyLookup) {
        for (List<Command.PropertyCommand> propertyCommands : this.propCommands.values()) {
            long[] nodeLabelsAfter;
            long[] nodeLabelsBefore;
            PropertyRecord representative = propertyCommands.get(0).getAfter();
            if (!representative.isNodeSet()) continue;
            long nodeId = representative.getNodeId();
            Command.NodeCommand nodeChanges = this.nodeCommands.get(nodeId);
            if (nodeChanges != null) {
                nodeLabelsBefore = NodeLabelsField.parseLabelsField(nodeChanges.getBefore()).get(this.nodeStore);
                nodeLabelsAfter = NodeLabelsField.parseLabelsField(nodeChanges.getAfter()).get(this.nodeStore);
            } else {
                NodeRecord nodeRecord = this.nodeStore.getRecord(nodeId);
                nodeLabelsBefore = nodeLabelsAfter = NodeLabelsField.parseLabelsField(nodeRecord).get(this.nodeStore);
            }
            this.propertyStore.toLogicalUpdates(updates, Iterables.cast(propertyCommands), nodeLabelsBefore, nodeLabelsAfter);
        }
        for (NodePropertyUpdate update : updates) {
            if (update.getUpdateMode() != UpdateMode.CHANGED) continue;
            propertyLookup.put(Pair.of(update.getNodeId(), update.getPropertyKeyId()), update);
        }
    }

    private void gatherUpdatesFromNodeCommands(Collection<NodePropertyUpdate> propertyUpdates, Map<Pair<Long, Integer>, NodePropertyUpdate> propertyLookup) {
        for (Command.NodeCommand nodeCommand : this.nodeCommands.values()) {
            NeoStoreTransaction.LabelChangeSummary summary;
            long nodeId = nodeCommand.getKey();
            long[] labelsBefore = NodeLabelsField.parseLabelsField(nodeCommand.getBefore()).get(this.nodeStore);
            long[] labelsAfter = NodeLabelsField.parseLabelsField(nodeCommand.getAfter()).get(this.nodeStore);
            if (nodeCommand.getMode() != Command.Mode.UPDATE || !(summary = new NeoStoreTransaction.LabelChangeSummary(labelsBefore, labelsAfter)).hasAddedLabels() && !summary.hasRemovedLabels()) continue;
            Iterator<DefinedProperty> properties = this.nodeFullyLoadProperties(nodeId);
            while (properties.hasNext()) {
                DefinedProperty property = properties.next();
                int propertyKeyId = property.propertyKeyId();
                if (summary.hasAddedLabels()) {
                    Object value = property.value();
                    propertyUpdates.add(NodePropertyUpdate.add(nodeId, propertyKeyId, value, summary.getAddedLabels()));
                }
                if (!summary.hasRemovedLabels()) continue;
                NodePropertyUpdate propertyChange = propertyLookup.get(Pair.of(nodeId, propertyKeyId));
                Object value = propertyChange == null ? property.value() : propertyChange.getValueBefore();
                propertyUpdates.add(NodePropertyUpdate.remove(nodeId, propertyKeyId, value, summary.getRemovedLabels()));
            }
        }
    }

    private Iterator<DefinedProperty> nodeFullyLoadProperties(long nodeId) {
        IteratingPropertyReceiver receiver = new IteratingPropertyReceiver();
        Map<Long, PropertyRecord> propertiesById = this.propertiesFromCommandsForNode(nodeId);
        NeoStoreTransaction.loadProperties(this.propertyStore, this.nodeCommands.get(nodeId).getAfter().getNextProp(), receiver, propertiesById);
        return receiver;
    }

    private Map<Long, PropertyRecord> propertiesFromCommandsForNode(long nodeId) {
        List<Command.PropertyCommand> propertyCommands = this.propCommands.get(nodeId);
        if (propertyCommands == null) {
            return Collections.emptyMap();
        }
        HashMap<Long, PropertyRecord> result = new HashMap<Long, PropertyRecord>(propertyCommands.size(), 1.0f);
        for (Command.PropertyCommand command : propertyCommands) {
            PropertyRecord after = command.getAfter();
            if (!after.inUse() || !after.isNodeSet()) continue;
            result.put(after.getId(), after);
        }
        return result;
    }
}

