/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.DynamicStringStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.TokenStore;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class RelationshipTypeTokenStore
extends TokenStore<RelationshipTypeTokenRecord> {
    public static final String TYPE_DESCRIPTOR = "RelationshipTypeStore";
    private static final int RECORD_SIZE = 5;

    public RelationshipTypeTokenStore(File fileName, Config config, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, DynamicStringStore nameStore) {
        super(fileName, config, IdType.RELATIONSHIP_TYPE_TOKEN, idGeneratorFactory, windowPoolFactory, fileSystemAbstraction, stringLogger, nameStore);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, RelationshipTypeTokenRecord record) throws FAILURE {
        processor.processRelationshipTypeToken(this, record);
    }

    @Override
    protected RelationshipTypeTokenRecord newRecord(int id) {
        return new RelationshipTypeTokenRecord(id);
    }

    @Override
    public int getRecordSize() {
        return 5;
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    protected boolean reserveIdsDuringRebuild() {
        return true;
    }

    public static abstract class Configuration
    extends TokenStore.Configuration {
    }
}

