/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.NestingIterable;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;

public class SchemaCache {
    private final Map<Integer, Map<Long, SchemaRule>> rulesByLabelMap = new HashMap<Integer, Map<Long, SchemaRule>>();
    private final Map<Long, SchemaRule> ruleByIdMap = new HashMap<Long, SchemaRule>();
    private final Collection<UniquenessConstraint> constraints = new HashSet<UniquenessConstraint>();
    private final Map<Integer, Map<Integer, CommittedIndexDescriptor>> indexDescriptors = new HashMap<Integer, Map<Integer, CommittedIndexDescriptor>>();

    public SchemaCache(Iterable<SchemaRule> initialRules) {
        this.splitUpInitialRules(initialRules);
    }

    private void splitUpInitialRules(Iterable<SchemaRule> initialRules) {
        for (SchemaRule rule : initialRules) {
            this.addSchemaRule(rule);
        }
    }

    private Map<Long, SchemaRule> getOrCreateSchemaRulesMapForLabel(int label) {
        Map<Long, SchemaRule> rulesForLabel = this.rulesByLabelMap.get(label);
        if (rulesForLabel == null) {
            rulesForLabel = new HashMap<Long, SchemaRule>();
            this.rulesByLabelMap.put(label, rulesForLabel);
        }
        return rulesForLabel;
    }

    public Iterable<SchemaRule> schemaRules() {
        return new NestingIterable<SchemaRule, Map<Long, SchemaRule>>(this.rulesByLabelMap.values()){

            @Override
            protected Iterator<SchemaRule> createNestedIterator(Map<Long, SchemaRule> item) {
                return item.values().iterator();
            }
        };
    }

    public Collection<SchemaRule> schemaRulesForLabel(int label) {
        Map<Long, SchemaRule> rulesForLabel = this.rulesByLabelMap.get(label);
        return rulesForLabel != null ? Collections.unmodifiableCollection(rulesForLabel.values()) : Collections.emptyList();
    }

    public Iterator<UniquenessConstraint> constraints() {
        return this.constraints.iterator();
    }

    public Iterator<UniquenessConstraint> constraintsForLabel(final int label) {
        return Iterables.filter(new Predicate<UniquenessConstraint>(){

            @Override
            public boolean accept(UniquenessConstraint item) {
                return item.label() == label;
            }
        }, this.constraints.iterator());
    }

    public Iterator<UniquenessConstraint> constraintsForLabelAndProperty(final int label, final int property) {
        return Iterables.filter(new Predicate<UniquenessConstraint>(){

            @Override
            public boolean accept(UniquenessConstraint item) {
                return item.label() == label && item.propertyKeyId() == property;
            }
        }, this.constraints.iterator());
    }

    public void addSchemaRule(SchemaRule rule) {
        this.getOrCreateSchemaRulesMapForLabel(rule.getLabel()).put(rule.getId(), rule);
        this.ruleByIdMap.put(rule.getId(), rule);
        if (rule instanceof UniquenessConstraintRule) {
            this.constraints.add(this.ruleToConstraint((UniquenessConstraintRule)rule));
        } else if (rule instanceof IndexRule) {
            IndexRule indexRule = (IndexRule)rule;
            Map<Integer, CommittedIndexDescriptor> byLabel = this.indexDescriptors.get(indexRule.getLabel());
            if (byLabel == null) {
                byLabel = new HashMap<Integer, CommittedIndexDescriptor>();
                this.indexDescriptors.put(indexRule.getLabel(), byLabel);
            }
            byLabel.put(indexRule.getPropertyKey(), new CommittedIndexDescriptor(indexRule.getLabel(), indexRule.getPropertyKey(), indexRule.getId()));
        }
    }

    public void clear() {
        this.rulesByLabelMap.clear();
        this.ruleByIdMap.clear();
        this.constraints.clear();
        this.indexDescriptors.clear();
    }

    public void removeSchemaRule(long id) {
        SchemaRule rule = this.ruleByIdMap.remove(id);
        if (rule == null) {
            return;
        }
        int labelId = rule.getLabel();
        Map<Long, SchemaRule> rules = this.rulesByLabelMap.get(labelId);
        if (rules.remove(id) != null && rules.isEmpty()) {
            this.rulesByLabelMap.remove(labelId);
        }
        if (rule instanceof UniquenessConstraintRule) {
            this.constraints.remove(this.ruleToConstraint((UniquenessConstraintRule)rule));
        } else if (rule instanceof IndexRule) {
            IndexRule indexRule = (IndexRule)rule;
            Map<Integer, CommittedIndexDescriptor> byLabel = this.indexDescriptors.get(indexRule.getLabel());
            byLabel.remove(indexRule.getPropertyKey());
            if (byLabel.isEmpty()) {
                this.indexDescriptors.remove(indexRule.getLabel());
            }
        }
    }

    public long indexId(IndexDescriptor index) {
        CommittedIndexDescriptor committed;
        Map<Integer, CommittedIndexDescriptor> byLabel = this.indexDescriptors.get(index.getLabelId());
        if (byLabel != null && (committed = byLabel.get(index.getPropertyKeyId())) != null) {
            return committed.getId();
        }
        throw new IllegalStateException("Couldn't resolve index id for " + index + " at this point. Schema rule not committed yet?");
    }

    private UniquenessConstraint ruleToConstraint(UniquenessConstraintRule constraintRule) {
        return new UniquenessConstraint(constraintRule.getLabel(), constraintRule.getPropertyKey());
    }

    public IndexDescriptor indexDescriptor(int labelId, int propertyKey) throws SchemaRuleNotFoundException {
        CommittedIndexDescriptor committed;
        Map<Integer, CommittedIndexDescriptor> byLabel = this.indexDescriptors.get(labelId);
        if (byLabel != null && (committed = byLabel.get(propertyKey)) != null) {
            return committed.getDescriptor();
        }
        throw new SchemaRuleNotFoundException(labelId, propertyKey, "No such index found");
    }

    private static class CommittedIndexDescriptor {
        private final IndexDescriptor descriptor;
        private final long id;

        public CommittedIndexDescriptor(int labelId, int propertyKey, long id) {
            this.descriptor = new IndexDescriptor(labelId, propertyKey);
            this.id = id;
        }

        public IndexDescriptor getDescriptor() {
            return this.descriptor;
        }

        public long getId() {
            return this.id;
        }
    }
}

