/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.kernel.impl.util.StringLogger;

public class Monitors {
    private final ConcurrentMap<Class<?>, MonitorProxy> proxies = new ConcurrentHashMap();
    private final StringLogger logger;

    public Monitors(StringLogger logger) {
        this.logger = logger;
    }

    public <T> T newMonitor(Class<T> monitorInterface) {
        MonitorProxy<T> monitorProxy = this.proxyFor(monitorInterface);
        return monitorProxy.instance();
    }

    public void addListener(Object listener) {
        for (Class<?> monitorInterface : listener.getClass().getInterfaces()) {
            if (!Monitors.validMonitorInterface(monitorInterface)) continue;
            this.proxyFor(monitorInterface).addListener(listener);
        }
    }

    public void removeListener(Object listener) {
        for (Class<?> monitorInterface : listener.getClass().getInterfaces()) {
            if (!Monitors.validMonitorInterface(monitorInterface)) continue;
            this.proxyFor(monitorInterface).removeListener(listener);
        }
    }

    private <T> MonitorProxy<T> proxyFor(Class<T> monitorInterface) {
        if (!this.proxies.containsKey(monitorInterface)) {
            this.proxies.putIfAbsent(monitorInterface, new MonitorProxy(monitorInterface, this.logger));
        }
        return (MonitorProxy)this.proxies.get(monitorInterface);
    }

    private static void assertValidMonitorInterface(Class<?> monitorInterface) {
        if (!Monitors.validMonitorInterface(monitorInterface)) {
            throw new IllegalArgumentException("Only void methods are allowed in monitor interfaces: " + monitorInterface);
        }
    }

    private static boolean validMonitorInterface(Class<?> monitorInterface) {
        for (Method method : monitorInterface.getDeclaredMethods()) {
            if (method.getReturnType() == Void.TYPE) continue;
            return false;
        }
        return true;
    }

    private static final class MonitorProxy<T>
    implements InvocationHandler {
        private final Class<T> monitorInterface;
        private final Set<T> listeners = new HashSet<T>();
        private final T proxyInstance;
        private final StringLogger logger;

        private MonitorProxy(Class<T> monitorInterface, StringLogger logger) {
            this.monitorInterface = monitorInterface;
            this.logger = logger;
            Monitors.assertValidMonitorInterface(monitorInterface);
            this.proxyInstance = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{monitorInterface}, (InvocationHandler)this);
        }

        public T instance() {
            return this.proxyInstance;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!this.listeners.isEmpty()) {
                for (T listener : this.listeners) {
                    try {
                        method.invoke(listener, args);
                    }
                    catch (Exception e) {
                        this.logger.error("Monitor listener failure.", e);
                    }
                }
            }
            return null;
        }

        public void addListener(Object rawListener) {
            this.listeners.add(this.monitorInterface.cast(rawListener));
        }

        public void removeListener(Object rawListener) {
            this.listeners.remove(this.monitorInterface.cast(rawListener));
        }
    }
}

