/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import java.util.Collections;
import java.util.Set;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.index.IndexEntryConflictException;

public class ConstraintVerificationFailedKernelException
extends KernelException {
    private final UniquenessConstraint constraint;
    private final Set<Evidence> evidence;

    public ConstraintVerificationFailedKernelException(UniquenessConstraint constraint, Set<Evidence> evidence) {
        super("Existing data does not satisfy %s.", constraint);
        this.constraint = constraint;
        this.evidence = evidence;
    }

    public ConstraintVerificationFailedKernelException(UniquenessConstraint constraint, Throwable failure) {
        super(failure, "Failed to verify constraint %s: %s", constraint, failure.getMessage());
        this.constraint = constraint;
        this.evidence = null;
    }

    public Set<Evidence> evidence() {
        return this.evidence == null ? Collections.emptySet() : Collections.unmodifiableSet(this.evidence);
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        StringBuilder message = new StringBuilder();
        for (Evidence evidenceItem : this.evidence()) {
            IndexEntryConflictException conflict = evidenceItem.conflict;
            message.append(conflict.evidenceMessage(tokenNameLookup.labelGetName(this.constraint.label()), tokenNameLookup.propertyKeyGetName(this.constraint.propertyKeyId())));
        }
        return message.toString();
    }

    public static final class Evidence {
        private final IndexEntryConflictException conflict;

        public Evidence(IndexEntryConflictException conflict) {
            this.conflict = conflict;
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.conflict.equals(((Evidence)o).conflict);
        }

        public int hashCode() {
            return this.conflict.hashCode();
        }

        public String toString() {
            return "Evidence{conflict=" + this.conflict + '}';
        }
    }
}

