/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;

public class AddIndexFailureException
extends SchemaKernelException {
    private static final String MESSAGE = "Unable to add index %s : %s";
    private final int labelId;
    private final int propertyKey;

    public AddIndexFailureException(int labelId, int propertyKey, KernelException cause) {
        super(String.format(MESSAGE, new IndexDescriptor(labelId, propertyKey), cause.getMessage()), cause);
        this.labelId = labelId;
        this.propertyKey = propertyKey;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format(String.format(MESSAGE, new IndexDescriptor(this.labelId, this.propertyKey).userDescription(tokenNameLookup), ((KernelException)this.getCause()).getUserMessage(tokenNameLookup)), new Object[0]);
    }
}

