/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.StoreFile;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;

public class UpgradableDatabase {
    private final FileSystemAbstraction fs;

    public UpgradableDatabase(FileSystemAbstraction fs) {
        this.fs = fs;
    }

    public boolean storeFilesUpgradeable(File neoStoreFile) {
        try {
            this.checkUpgradeable(neoStoreFile);
            return true;
        }
        catch (StoreUpgrader.UnableToUpgradeException e) {
            return false;
        }
    }

    public void checkUpgradeable(File neoStoreFile) {
        File storeDirectory = neoStoreFile.getParentFile();
        for (StoreFile store : StoreFile.legacyStoreFiles()) {
            String expectedVersion = store.legacyVersion();
            AbstractInterruptibleChannel fileChannel = null;
            byte[] expectedVersionBytes = UTF8.encode(expectedVersion);
            try {
                File storeFile = new File(storeDirectory, store.storeFileName());
                if (!this.fs.fileExists(storeFile)) {
                    throw new StoreUpgrader.UpgradeMissingStoreFilesException(storeFile.getName());
                }
                fileChannel = this.fs.open(storeFile, "r");
                if (((FileChannel)fileChannel).size() < (long)expectedVersionBytes.length) {
                    throw new StoreUpgrader.UpgradingStoreVersionNotFoundException(storeFile.getName());
                }
                ((FileChannel)fileChannel).position(((FileChannel)fileChannel).size() - (long)expectedVersionBytes.length);
                byte[] foundVersionBytes = new byte[expectedVersionBytes.length];
                ((FileChannel)fileChannel).read(ByteBuffer.wrap(foundVersionBytes));
                String actualVersion = UTF8.decode(foundVersionBytes);
                if (!actualVersion.startsWith(store.typeDescriptor())) {
                    throw new StoreUpgrader.UpgradingStoreVersionNotFoundException(store.storeFileName());
                }
                if (expectedVersion.equals(actualVersion)) continue;
                throw new StoreUpgrader.UnexpectedUpgradingStoreVersionException(storeFile.getName(), expectedVersion, actualVersion);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (fileChannel == null) continue;
                try {
                    fileChannel.close();
                }
                catch (IOException e) {
                    return;
                }
            }
        }
    }
}

