/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;

public class CurrentDatabase {
    private Map<String, String> fileNamesToTypeDescriptors = new HashMap<String, String>();

    public CurrentDatabase() {
        this.fileNamesToTypeDescriptors.put("neostore", "NeoStore");
        this.fileNamesToTypeDescriptors.put("neostore.nodestore.db", "NodeStore");
        this.fileNamesToTypeDescriptors.put("neostore.propertystore.db", "PropertyStore");
        this.fileNamesToTypeDescriptors.put("neostore.propertystore.db.arrays", "ArrayPropertyStore");
        this.fileNamesToTypeDescriptors.put("neostore.propertystore.db.index", "PropertyIndexStore");
        this.fileNamesToTypeDescriptors.put("neostore.propertystore.db.index.keys", "StringPropertyStore");
        this.fileNamesToTypeDescriptors.put("neostore.propertystore.db.strings", "StringPropertyStore");
        this.fileNamesToTypeDescriptors.put("neostore.relationshipstore.db", "RelationshipStore");
        this.fileNamesToTypeDescriptors.put("neostore.relationshiptypestore.db", "RelationshipTypeStore");
        this.fileNamesToTypeDescriptors.put("neostore.relationshiptypestore.db.names", "StringPropertyStore");
    }

    public boolean storeFilesAtCurrentVersion(File storeDirectory) {
        for (String fileName : this.fileNamesToTypeDescriptors.keySet()) {
            String expectedVersion = CommonAbstractStore.buildTypeDescriptorAndVersion(this.fileNamesToTypeDescriptors.get(fileName));
            AbstractInterruptibleChannel fileChannel = null;
            byte[] expectedVersionBytes = UTF8.encode(expectedVersion);
            try {
                File storeFile = new File(storeDirectory, fileName);
                if (!storeFile.exists()) {
                    boolean bl = false;
                    return bl;
                }
                fileChannel = new RandomAccessFile(storeFile, "r").getChannel();
                ((FileChannel)fileChannel).position(((FileChannel)fileChannel).size() - (long)expectedVersionBytes.length);
                byte[] foundVersionBytes = new byte[expectedVersionBytes.length];
                ((FileChannel)fileChannel).read(ByteBuffer.wrap(foundVersionBytes));
                if (expectedVersion.equals(UTF8.decode(foundVersionBytes))) continue;
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (fileChannel == null) continue;
                try {
                    fileChannel.close();
                }
                catch (IOException e) {
                    return true;
                }
            }
        }
        return true;
    }
}

