/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.SillyUtils;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;

public class NeoStoreFileListing {
    private final XaContainer xaContainer;
    private final File storeDir;
    private final LabelScanStore labelScanStore;
    private final IndexingService indexingService;

    public NeoStoreFileListing(XaContainer xaContainer, File storeDir, LabelScanStore labelScanStore, IndexingService indexingService) {
        this.xaContainer = xaContainer;
        this.storeDir = storeDir;
        this.labelScanStore = labelScanStore;
        this.indexingService = indexingService;
    }

    public ResourceIterator<File> listStoreFiles(boolean includeLogicalLogs) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        this.gatherNeoStoreFiles(includeLogicalLogs, files);
        Resource labelScanStoreSnapshot = this.gatherLabelScanStoreFiles(files);
        Resource schemaIndexSnapshots = this.gatherSchemaIndexFiles(files);
        return new StoreSnapshot(files.iterator(), labelScanStoreSnapshot, schemaIndexSnapshots);
    }

    private Resource gatherSchemaIndexFiles(Collection<File> targetFiles) throws IOException {
        ResourceIterator<File> snapshot = this.indexingService.snapshotStoreFiles();
        IteratorUtil.addToCollection(snapshot, targetFiles);
        return snapshot;
    }

    private Resource gatherLabelScanStoreFiles(Collection<File> targetFiles) throws IOException {
        ResourceIterator<File> snapshot = this.labelScanStore.snapshotStoreFiles();
        IteratorUtil.addToCollection(snapshot, targetFiles);
        return snapshot;
    }

    private void gatherNeoStoreFiles(boolean includeLogicalLogs, Collection<File> targetFiles) {
        File neostoreFile = null;
        Pattern logFilePattern = this.xaContainer.getLogicalLog().getHistoryFileNamePattern();
        for (File dbFile : SillyUtils.nonNull(this.storeDir.listFiles())) {
            String name = dbFile.getName();
            if (!dbFile.isFile()) continue;
            if (name.equals("neostore")) {
                neostoreFile = dbFile;
                continue;
            }
            if ((name.startsWith("neostore") || name.equals("index.db")) && !name.endsWith(".id")) {
                targetFiles.add(dbFile);
                continue;
            }
            if (!includeLogicalLogs || !logFilePattern.matcher(dbFile.getName()).matches()) continue;
            targetFiles.add(dbFile);
        }
        targetFiles.add(neostoreFile);
    }

    private static class StoreSnapshot
    extends PrefetchingIterator<File>
    implements ResourceIterator<File> {
        private final Iterator<File> files;
        private final Resource[] thingsToCloseWhenDone;

        StoreSnapshot(Iterator<File> files, Resource ... thingsToCloseWhenDone) {
            this.files = files;
            this.thingsToCloseWhenDone = thingsToCloseWhenDone;
        }

        @Override
        protected File fetchNextOrNull() {
            return this.files.hasNext() ? this.files.next() : null;
        }

        @Override
        public void close() {
            for (Resource resource : this.thingsToCloseWhenDone) {
                resource.close();
            }
        }
    }
}

