/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.DiffSets;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.state.GraphState;
import org.neo4j.kernel.impl.api.state.LabelState;
import org.neo4j.kernel.impl.api.state.NodeState;
import org.neo4j.kernel.impl.api.state.OldTxStateBridge;
import org.neo4j.kernel.impl.api.state.RelationshipState;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.persistence.PersistenceManager;

public final class TxStateImpl
implements TxState {
    private static final StateCreator<LabelState> LABEL_STATE_CREATOR = new StateCreator<LabelState>(){

        @Override
        public LabelState newState(long id) {
            return new LabelState(id);
        }
    };
    private static final StateCreator<NodeState> NODE_STATE_CREATOR = new StateCreator<NodeState>(){

        @Override
        public NodeState newState(long id) {
            return new NodeState(id);
        }
    };
    private static final StateCreator<RelationshipState> RELATIONSHIP_STATE_CREATOR = new StateCreator<RelationshipState>(){

        @Override
        public RelationshipState newState(long id) {
            return new RelationshipState(id);
        }
    };
    private Map<Long, NodeState> nodeStatesMap;
    private Map<Long, RelationshipState> relationshipStatesMap;
    private Map<Long, LabelState> labelStatesMap;
    private GraphState graphState;
    private DiffSets<IndexDescriptor> indexChanges;
    private DiffSets<IndexDescriptor> constraintIndexChanges;
    private DiffSets<UniquenessConstraint> constraintsChanges;
    private DiffSets<Long> deletedNodes;
    private DiffSets<Long> deletedRelationships;
    private Map<UniquenessConstraint, Long> createdConstraintIndexesByConstraint;
    private final OldTxStateBridge legacyState;
    private final PersistenceManager persistenceManager;
    private final TxState.IdGeneration idGeneration;
    private boolean hasChanges;

    public TxStateImpl(OldTxStateBridge legacyState, PersistenceManager legacyTransaction, TxState.IdGeneration idGeneration) {
        this.legacyState = legacyState;
        this.persistenceManager = legacyTransaction;
        this.idGeneration = idGeneration;
    }

    @Override
    public void accept(final TxState.Visitor visitor) {
        if (this.hasNodeStatesMap() && !this.nodeStatesMap().isEmpty()) {
            for (NodeState node : this.nodeStates()) {
                DiffSets<Integer> labelDiff = node.labelDiffSets();
                visitor.visitNodeLabelChanges(node.getId(), labelDiff.getAdded(), labelDiff.getRemoved());
            }
        }
        if (this.hasIndexChangesDiffSets() && !this.indexChanges().isEmpty()) {
            this.indexChanges().accept(TxStateImpl.indexVisitor(visitor, false));
        }
        if (this.hasConstraintIndexChangesDiffSets() && !this.constraintIndexChanges().isEmpty()) {
            this.constraintIndexChanges().accept(TxStateImpl.indexVisitor(visitor, true));
        }
        if (this.hasConstraintsChangesDiffSets() && !this.constraintsChanges().isEmpty()) {
            this.constraintsChanges().accept(new DiffSets.Visitor<UniquenessConstraint>(){

                @Override
                public void visitAdded(UniquenessConstraint element) {
                    visitor.visitAddedConstraint(element);
                }

                @Override
                public void visitRemoved(UniquenessConstraint element) {
                    visitor.visitRemovedConstraint(element);
                }
            });
        }
    }

    private static DiffSets.Visitor<IndexDescriptor> indexVisitor(final TxState.Visitor visitor, final boolean forConstraint) {
        return new DiffSets.Visitor<IndexDescriptor>(){

            @Override
            public void visitAdded(IndexDescriptor element) {
                visitor.visitAddedIndex(element, forConstraint);
            }

            @Override
            public void visitRemoved(IndexDescriptor element) {
                visitor.visitRemovedIndex(element, forConstraint);
            }
        };
    }

    @Override
    public boolean hasChanges() {
        return this.hasChanges || this.legacyState.hasChanges();
    }

    @Override
    public Iterable<NodeState> nodeStates() {
        return this.hasNodeStatesMap() ? this.nodeStatesMap().values() : Iterables.empty();
    }

    @Override
    public DiffSets<Long> labelStateNodeDiffSets(int labelId) {
        return this.getOrCreateLabelState(labelId).getNodeDiffSets();
    }

    @Override
    public DiffSets<Integer> nodeStateLabelDiffSets(long nodeId) {
        return this.getOrCreateNodeState(nodeId).labelDiffSets();
    }

    @Override
    public DiffSets<DefinedProperty> nodePropertyDiffSets(long nodeId) {
        return this.getOrCreateNodeState(nodeId).propertyDiffSets();
    }

    @Override
    public DiffSets<DefinedProperty> relationshipPropertyDiffSets(long relationshipId) {
        return this.getOrCreateRelationshipState(relationshipId).propertyDiffSets();
    }

    @Override
    public DiffSets<DefinedProperty> graphPropertyDiffSets() {
        return this.getOrCreateGraphState().propertyDiffSets();
    }

    @Override
    public boolean nodeIsAddedInThisTx(long nodeId) {
        return this.legacyState.nodeIsAddedInThisTx(nodeId);
    }

    @Override
    public boolean relationshipIsAddedInThisTx(long relationshipId) {
        return this.legacyState.relationshipIsAddedInThisTx(relationshipId);
    }

    @Override
    public void nodeDoDelete(long nodeId) {
        this.legacyState.deleteNode(nodeId);
        this.nodesDeletedInTx().remove(nodeId);
        this.hasChanges = true;
    }

    @Override
    public boolean nodeIsDeletedInThisTx(long nodeId) {
        return this.hasDeletedNodesDiffSets() && this.nodesDeletedInTx().isRemoved(nodeId);
    }

    @Override
    public void relationshipDoDelete(long relationshipId) {
        this.legacyState.deleteRelationship(relationshipId);
        this.deletedRelationships().remove(relationshipId);
        this.hasChanges = true;
    }

    @Override
    public boolean relationshipIsDeletedInThisTx(long relationshipId) {
        return this.hasDeletedRelationshipsDiffSets() && this.deletedRelationships().isRemoved(relationshipId);
    }

    @Override
    public void nodeDoReplaceProperty(long nodeId, Property replacedProperty, DefinedProperty newProperty) {
        if (newProperty.isDefined()) {
            DiffSets<DefinedProperty> diffSets = this.nodePropertyDiffSets(nodeId);
            if (replacedProperty.isDefined()) {
                diffSets.replace((DefinedProperty)replacedProperty, newProperty);
            } else {
                diffSets.add(newProperty);
            }
            this.legacyState.nodeSetProperty(nodeId, newProperty);
            this.hasChanges = true;
        }
    }

    @Override
    public void relationshipDoReplaceProperty(long relationshipId, Property replacedProperty, DefinedProperty newProperty) {
        if (newProperty.isDefined()) {
            DiffSets<DefinedProperty> diffSets = this.relationshipPropertyDiffSets(relationshipId);
            if (replacedProperty.isDefined()) {
                diffSets.replace((DefinedProperty)replacedProperty, newProperty);
            } else {
                diffSets.add(newProperty);
            }
            this.legacyState.relationshipSetProperty(relationshipId, newProperty);
            this.hasChanges = true;
        }
    }

    @Override
    public void graphDoReplaceProperty(Property replacedProperty, DefinedProperty newProperty) {
        if (newProperty.isDefined()) {
            DiffSets<DefinedProperty> diffSets = this.graphPropertyDiffSets();
            if (replacedProperty.isDefined()) {
                diffSets.replace((DefinedProperty)replacedProperty, newProperty);
            } else {
                diffSets.add(newProperty);
            }
            this.legacyState.graphSetProperty(newProperty);
            this.hasChanges = true;
        }
    }

    @Override
    public void nodeDoRemoveProperty(long nodeId, Property removedProperty) {
        if (removedProperty.isDefined()) {
            this.nodePropertyDiffSets(nodeId).remove((DefinedProperty)removedProperty);
            this.legacyState.nodeRemoveProperty(nodeId, (DefinedProperty)removedProperty);
            this.hasChanges = true;
        }
    }

    @Override
    public void relationshipDoRemoveProperty(long relationshipId, Property removedProperty) {
        if (removedProperty.isDefined()) {
            this.relationshipPropertyDiffSets(relationshipId).remove((DefinedProperty)removedProperty);
            this.legacyState.relationshipRemoveProperty(relationshipId, (DefinedProperty)removedProperty);
            this.hasChanges = true;
        }
    }

    @Override
    public void graphDoRemoveProperty(Property removedProperty) {
        if (removedProperty.isDefined()) {
            this.graphPropertyDiffSets().remove((DefinedProperty)removedProperty);
            this.legacyState.graphRemoveProperty((DefinedProperty)removedProperty);
            this.hasChanges = true;
        }
    }

    @Override
    public void nodeDoAddLabel(int labelId, long nodeId) {
        this.labelStateNodeDiffSets(labelId).add(nodeId);
        this.nodeStateLabelDiffSets(nodeId).add(labelId);
        this.persistenceManager.addLabelToNode(labelId, nodeId);
        this.hasChanges = true;
    }

    @Override
    public void nodeDoRemoveLabel(int labelId, long nodeId) {
        this.labelStateNodeDiffSets(labelId).remove(nodeId);
        this.nodeStateLabelDiffSets(nodeId).remove(labelId);
        this.persistenceManager.removeLabelFromNode(labelId, nodeId);
        this.hasChanges = true;
    }

    @Override
    public TxState.UpdateTriState labelState(long nodeId, int labelId) {
        NodeState nodeState = this.getState(this.nodeStatesMap(), nodeId, null);
        if (nodeState != null) {
            DiffSets<Integer> labelDiff = nodeState.labelDiffSets();
            if (labelDiff.isAdded(labelId)) {
                return TxState.UpdateTriState.ADDED;
            }
            if (labelDiff.isRemoved(labelId)) {
                return TxState.UpdateTriState.REMOVED;
            }
        }
        return TxState.UpdateTriState.UNTOUCHED;
    }

    @Override
    public Set<Long> nodesWithLabelAdded(int labelId) {
        LabelState state;
        if (this.hasLabelStatesMap() && null != (state = this.getState(this.labelStatesMap, labelId, null))) {
            return state.getNodeDiffSets().getAdded();
        }
        return Collections.emptySet();
    }

    @Override
    public DiffSets<Long> nodesWithLabelChanged(int labelId) {
        LabelState state;
        if (this.hasLabelStatesMap() && null != (state = this.getState(this.labelStatesMap, labelId, null))) {
            return state.getNodeDiffSets();
        }
        return DiffSets.emptyDiffSets();
    }

    @Override
    public void indexRuleDoAdd(IndexDescriptor descriptor) {
        this.indexChanges().add(descriptor);
        this.getOrCreateLabelState(descriptor.getLabelId()).indexChanges().add(descriptor);
        this.hasChanges = true;
    }

    @Override
    public void constraintIndexRuleDoAdd(IndexDescriptor descriptor) {
        this.constraintIndexChanges().add(descriptor);
        this.getOrCreateLabelState(descriptor.getLabelId()).constraintIndexChanges().add(descriptor);
        this.hasChanges = true;
    }

    @Override
    public void indexDoDrop(IndexDescriptor descriptor) {
        this.indexChanges().remove(descriptor);
        this.getOrCreateLabelState(descriptor.getLabelId()).indexChanges().remove(descriptor);
        this.hasChanges = true;
    }

    @Override
    public void constraintIndexDoDrop(IndexDescriptor descriptor) {
        this.constraintIndexChanges().remove(descriptor);
        this.getOrCreateLabelState(descriptor.getLabelId()).constraintIndexChanges().remove(descriptor);
        this.hasChanges = true;
    }

    @Override
    public DiffSets<IndexDescriptor> indexDiffSetsByLabel(int labelId) {
        LabelState labelState;
        if (this.hasLabelStatesMap() && null != (labelState = this.getState(this.labelStatesMap, labelId, null))) {
            return labelState.indexChanges();
        }
        return DiffSets.emptyDiffSets();
    }

    @Override
    public DiffSets<IndexDescriptor> constraintIndexDiffSetsByLabel(int labelId) {
        LabelState labelState;
        if (this.hasLabelStatesMap() && (labelState = this.getState(this.labelStatesMap(), labelId, null)) != null) {
            return labelState.constraintIndexChanges();
        }
        return DiffSets.emptyDiffSets();
    }

    @Override
    public DiffSets<IndexDescriptor> indexChanges() {
        if (!this.hasIndexChangesDiffSets()) {
            this.indexChanges = new DiffSets();
        }
        return this.indexChanges;
    }

    private boolean hasIndexChangesDiffSets() {
        return this.indexChanges != null;
    }

    @Override
    public DiffSets<IndexDescriptor> constraintIndexChanges() {
        if (!this.hasConstraintIndexChangesDiffSets()) {
            this.constraintIndexChanges = new DiffSets();
        }
        return this.constraintIndexChanges;
    }

    private boolean hasConstraintIndexChangesDiffSets() {
        return this.constraintIndexChanges != null;
    }

    @Override
    public DiffSets<Long> nodesWithChangedProperty(int propertyKeyId, Object value) {
        return this.legacyState.getNodesWithChangedProperty(propertyKeyId, value);
    }

    @Override
    public Map<Long, Object> nodesWithChangedProperty(int propertyKeyId) {
        return this.legacyState.getNodesWithChangedProperty(propertyKeyId);
    }

    @Override
    public DiffSets<Long> nodesDeletedInTx() {
        if (!this.hasDeletedNodesDiffSets()) {
            this.deletedNodes = new DiffSets();
        }
        return this.deletedNodes;
    }

    private boolean hasDeletedNodesDiffSets() {
        return this.deletedNodes != null;
    }

    public DiffSets<Long> deletedRelationships() {
        if (!this.hasDeletedRelationshipsDiffSets()) {
            this.deletedRelationships = new DiffSets();
        }
        return this.deletedRelationships;
    }

    private boolean hasDeletedRelationshipsDiffSets() {
        return this.deletedRelationships != null;
    }

    private LabelState getOrCreateLabelState(int labelId) {
        return this.getState(this.labelStatesMap(), labelId, LABEL_STATE_CREATOR);
    }

    private NodeState getOrCreateNodeState(long nodeId) {
        return this.getState(this.nodeStatesMap(), nodeId, NODE_STATE_CREATOR);
    }

    private RelationshipState getOrCreateRelationshipState(long relationshipId) {
        return this.getState(this.relationshipStatesMap(), relationshipId, RELATIONSHIP_STATE_CREATOR);
    }

    private GraphState getOrCreateGraphState() {
        if (this.graphState == null) {
            this.graphState = new GraphState();
        }
        return this.graphState;
    }

    private <STATE> STATE getState(Map<Long, STATE> states, long id, StateCreator<STATE> creator) {
        STATE result = states.get(id);
        if (result != null) {
            return result;
        }
        if (creator != null) {
            result = creator.newState(id);
            states.put(id, result);
            this.hasChanges = true;
        }
        return result;
    }

    @Override
    public void constraintDoAdd(UniquenessConstraint constraint, long indexId) {
        this.constraintsChanges().add(constraint);
        this.createdConstraintIndexesByConstraint().put(constraint, indexId);
        this.getOrCreateLabelState(constraint.label()).constraintsChanges().add(constraint);
        this.hasChanges = true;
    }

    @Override
    public DiffSets<UniquenessConstraint> constraintsChangesForLabelAndProperty(int labelId, final int propertyKey) {
        return this.getOrCreateLabelState(labelId).constraintsChanges().filterAdded(new Predicate<UniquenessConstraint>(){

            @Override
            public boolean accept(UniquenessConstraint item) {
                return item.propertyKeyId() == propertyKey;
            }
        });
    }

    @Override
    public DiffSets<UniquenessConstraint> constraintsChangesForLabel(int labelId) {
        return this.getOrCreateLabelState(labelId).constraintsChanges();
    }

    @Override
    public DiffSets<UniquenessConstraint> constraintsChanges() {
        if (!this.hasConstraintsChangesDiffSets()) {
            this.constraintsChanges = new DiffSets();
        }
        return this.constraintsChanges;
    }

    private boolean hasConstraintsChangesDiffSets() {
        return this.constraintsChanges != null;
    }

    @Override
    public void constraintDoDrop(UniquenessConstraint constraint) {
        if (this.constraintsChanges().remove(constraint)) {
            this.createdConstraintIndexesByConstraint().remove(constraint);
        }
        this.constraintIndexDoDrop(new IndexDescriptor(constraint.label(), constraint.propertyKeyId()));
        this.constraintsChangesForLabel(constraint.label()).remove(constraint);
        this.hasChanges = true;
    }

    @Override
    public boolean constraintDoUnRemove(UniquenessConstraint constraint) {
        if (this.constraintsChanges().unRemove(constraint)) {
            this.constraintIndexChanges.unRemove(new IndexDescriptor(constraint.label(), constraint.propertyKeyId()));
            return true;
        }
        return false;
    }

    @Override
    public Iterable<IndexDescriptor> constraintIndexesCreatedInTx() {
        Map<UniquenessConstraint, Long> constraintMap;
        if (this.hasCreatedConstraintIndexesMap() && !(constraintMap = this.createdConstraintIndexesByConstraint()).isEmpty()) {
            return Iterables.map(new Function<UniquenessConstraint, IndexDescriptor>(){

                @Override
                public IndexDescriptor apply(UniquenessConstraint constraint) {
                    return new IndexDescriptor(constraint.label(), constraint.propertyKeyId());
                }
            }, constraintMap.keySet());
        }
        return Iterables.empty();
    }

    private Map<UniquenessConstraint, Long> createdConstraintIndexesByConstraint() {
        if (!this.hasCreatedConstraintIndexesMap()) {
            this.createdConstraintIndexesByConstraint = new HashMap<UniquenessConstraint, Long>();
        }
        return this.createdConstraintIndexesByConstraint;
    }

    private boolean hasCreatedConstraintIndexesMap() {
        return null != this.createdConstraintIndexesByConstraint;
    }

    private Map<Long, NodeState> nodeStatesMap() {
        if (!this.hasNodeStatesMap()) {
            this.nodeStatesMap = new HashMap<Long, NodeState>();
        }
        return this.nodeStatesMap;
    }

    private boolean hasNodeStatesMap() {
        return null != this.nodeStatesMap;
    }

    private Map<Long, RelationshipState> relationshipStatesMap() {
        if (!this.hasRelationshipsStatesMap()) {
            this.relationshipStatesMap = new HashMap<Long, RelationshipState>();
        }
        return this.relationshipStatesMap;
    }

    private boolean hasRelationshipsStatesMap() {
        return null != this.relationshipStatesMap;
    }

    private Map<Long, LabelState> labelStatesMap() {
        if (!this.hasLabelStatesMap()) {
            this.labelStatesMap = new HashMap<Long, LabelState>();
        }
        return this.labelStatesMap;
    }

    private boolean hasLabelStatesMap() {
        return null != this.labelStatesMap;
    }

    private static interface StateCreator<STATE> {
        public STATE newState(long var1);
    }
}

