/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.KernelStatement;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.operations.AuxiliaryStoreOperations;
import org.neo4j.kernel.api.operations.EntityReadOperations;
import org.neo4j.kernel.api.operations.EntityWriteOperations;
import org.neo4j.kernel.api.operations.KeyReadOperations;
import org.neo4j.kernel.api.operations.KeyWriteOperations;
import org.neo4j.kernel.api.operations.SchemaReadOperations;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.PrimitiveIntIterator;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaStorage;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;

public class StoreStatementOperations
implements KeyReadOperations,
KeyWriteOperations,
EntityReadOperations,
EntityWriteOperations,
SchemaReadOperations,
AuxiliaryStoreOperations {
    private static final Function<UniquenessConstraintRule, UniquenessConstraint> UNIQUENESS_CONSTRAINT_TO_RULE = new Function<UniquenessConstraintRule, UniquenessConstraint>(){

        @Override
        public UniquenessConstraint apply(UniquenessConstraintRule rule) {
            return new UniquenessConstraint(rule.getLabel(), rule.getPropertyKey());
        }
    };
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final NeoStore neoStore;
    private final IndexingService indexService;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final PropertyStore propertyStore;
    private final RelationshipTypeTokenHolder relationshipTypeTokenHolder;
    private final SchemaStorage schemaStorage;
    private final PersistenceManager persistenceManager;
    private static final Predicate<SchemaRule> INDEX_RULES = new Predicate<SchemaRule>(){

        @Override
        public boolean accept(SchemaRule rule) {
            return rule.getKind() == SchemaRule.Kind.INDEX_RULE;
        }
    };
    private static final Predicate<SchemaRule> CONSTRAINT_INDEX_RULES = new Predicate<SchemaRule>(){

        @Override
        public boolean accept(SchemaRule rule) {
            return rule.getKind() == SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
        }
    };

    public StoreStatementOperations(PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, RelationshipTypeTokenHolder relationshipTypeTokenHolder, SchemaStorage schemaStorage, NeoStore neoStore, PersistenceManager persistenceManager, IndexingService indexService) {
        this.relationshipTypeTokenHolder = relationshipTypeTokenHolder;
        this.schemaStorage = schemaStorage;
        assert (neoStore != null) : "No neoStore provided";
        this.indexService = indexService;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
        this.neoStore = neoStore;
        this.nodeStore = neoStore.getNodeStore();
        this.relationshipStore = neoStore.getRelationshipStore();
        this.propertyStore = neoStore.getPropertyStore();
        this.persistenceManager = persistenceManager;
    }

    private UnsupportedOperationException shouldNotManipulateStoreDirectly() {
        throw new UnsupportedOperationException("The storage layer can not be written to directly, you have to go through a transaction.");
    }

    private UnsupportedOperationException shouldNotHaveReachedAllTheWayHere() {
        throw new UnsupportedOperationException("This call should not reach all the way here");
    }

    private UnsupportedOperationException shouldCallAuxiliaryInstead() {
        return new UnsupportedOperationException("This shouldn't be called directly, but instead to an appropriate method in the " + AuxiliaryStoreOperations.class.getSimpleName() + " interface");
    }

    @Override
    public int labelGetOrCreateForName(Statement state, String label) throws TooManyLabelsException {
        try {
            return this.labelTokenHolder.getOrCreateId(label);
        }
        catch (TransactionFailureException e) {
            if (e.getCause() instanceof UnderlyingStorageException && e.getCause().getMessage().equals("Id capacity exceeded")) {
                throw new TooManyLabelsException(e);
            }
            throw e;
        }
    }

    @Override
    public int labelGetForName(Statement state, String label) {
        int id = this.labelTokenHolder.getIdByName(label);
        if (id == -1) {
            return -1;
        }
        return id;
    }

    @Override
    public boolean nodeHasLabel(KernelStatement state, long nodeId, int labelId) {
        try {
            return IteratorUtil.contains(this.nodeGetLabels(state, nodeId), labelId);
        }
        catch (InvalidRecordException e) {
            return false;
        }
    }

    @Override
    public PrimitiveIntIterator nodeGetLabels(KernelStatement state, long nodeId) {
        try {
            final long[] labels = NodeLabelsField.parseLabelsField(this.nodeStore.getRecord(nodeId)).get(this.nodeStore);
            return new PrimitiveIntIterator(){
                private int cursor;

                @Override
                public boolean hasNext() {
                    return this.cursor < labels.length;
                }

                @Override
                public int next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return IoPrimitiveUtils.safeCastLongToInt(labels[this.cursor++]);
                }
            };
        }
        catch (InvalidRecordException e) {
            return IteratorUtil.emptyPrimitiveIntIterator();
        }
    }

    @Override
    public String labelGetName(Statement state, int labelId) throws LabelNotFoundKernelException {
        try {
            return ((Token)this.labelTokenHolder.getTokenById(labelId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new LabelNotFoundKernelException("Label by id " + labelId, e);
        }
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        return state.getLabelScanReader().nodesWithLabel(labelId);
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens(Statement state) {
        return this.propertyKeyTokenHolder.getAllTokens().iterator();
    }

    @Override
    public Iterator<Token> labelsGetAllTokens(Statement state) {
        return this.labelTokenHolder.getAllTokens().iterator();
    }

    @Override
    public int relationshipTypeGetForName(Statement state, String relationshipType) {
        return this.relationshipTypeTokenHolder.getIdByName(relationshipType);
    }

    @Override
    public String relationshipTypeGetName(Statement state, int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        try {
            return ((Token)this.relationshipTypeTokenHolder.getTokenById(relationshipTypeId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new RelationshipTypeIdNotFoundKernelException(relationshipTypeId, e);
        }
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKey) throws SchemaRuleNotFoundException {
        return StoreStatementOperations.descriptor(this.schemaStorage.indexRule(labelId, propertyKey));
    }

    private static IndexDescriptor descriptor(IndexRule ruleRecord) {
        return new IndexDescriptor(ruleRecord.getLabel(), ruleRecord.getPropertyKey());
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(KernelStatement state, int labelId) {
        return this.getIndexDescriptorsFor(StoreStatementOperations.indexRules(labelId));
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(KernelStatement state) {
        return this.getIndexDescriptorsFor(INDEX_RULES);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(KernelStatement state, int labelId) {
        return this.getIndexDescriptorsFor(StoreStatementOperations.constraintIndexRules(labelId));
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll(KernelStatement state) {
        return this.getIndexDescriptorsFor(CONSTRAINT_INDEX_RULES);
    }

    private static Predicate<SchemaRule> indexRules(final int labelId) {
        return new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.INDEX_RULE;
            }
        };
    }

    private static Predicate<SchemaRule> constraintIndexRules(final int labelId) {
        return new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
            }
        };
    }

    private Iterator<IndexDescriptor> getIndexDescriptorsFor(Predicate<SchemaRule> filter) {
        Iterator<SchemaRule> filtered = Iterables.filter(filter, this.neoStore.getSchemaStore().loadAllSchemaRules());
        return Iterables.map(new Function<SchemaRule, IndexDescriptor>(){

            @Override
            public IndexDescriptor apply(SchemaRule from) {
                return StoreStatementOperations.descriptor((IndexRule)from);
            }
        }, filtered);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(KernelStatement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId()).getOwningConstraint();
    }

    @Override
    public long indexGetCommittedId(KernelStatement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId()).getId();
    }

    @Override
    public InternalIndexState indexGetState(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getProxyForRule(this.indexId(descriptor)).getState();
    }

    @Override
    public String indexGetFailure(Statement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getProxyForRule(this.indexId(descriptor)).getPopulationFailure().asString();
    }

    private long indexId(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        try {
            return this.schemaStorage.indexRule(descriptor.getLabelId(), descriptor.getPropertyKeyId()).getId();
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IndexNotFoundKernelException(e.getMessage(), e);
        }
    }

    private long constraintIndexId(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        try {
            return this.schemaStorage.constraintIndexRule(descriptor.getLabelId(), descriptor.getPropertyKeyId()).getId();
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IndexNotFoundKernelException(e.getMessage(), e);
        }
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(KernelStatement state, int labelId, final int propertyKeyId) {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, UniquenessConstraintRule.class, labelId, new Predicate<UniquenessConstraintRule>(){

            @Override
            public boolean accept(UniquenessConstraintRule rule) {
                return rule.containsPropertyKeyId(propertyKeyId);
            }
        });
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(KernelStatement state, int labelId) {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, UniquenessConstraintRule.class, labelId, Predicates.TRUE());
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll(KernelStatement state) {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, SchemaRule.Kind.UNIQUENESS_CONSTRAINT, Predicates.TRUE());
    }

    @Override
    public int propertyKeyGetOrCreateForName(Statement state, String propertyKey) {
        return this.propertyKeyTokenHolder.getOrCreateId(propertyKey);
    }

    @Override
    public int relationshipTypeGetOrCreateForName(Statement state, String relationshipType) {
        return this.relationshipTypeTokenHolder.getOrCreateId(relationshipType);
    }

    @Override
    public int propertyKeyGetForName(Statement state, String propertyKey) {
        int id = this.propertyKeyTokenHolder.getIdByName(propertyKey);
        if (id == -1) {
            return -1;
        }
        return id;
    }

    @Override
    public String propertyKeyGetName(Statement state, int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        try {
            return ((Token)this.propertyKeyTokenHolder.getTokenById(propertyKeyId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new PropertyKeyIdNotFoundKernelException(propertyKeyId, e);
        }
    }

    @Override
    public Iterator<DefinedProperty> nodeGetAllProperties(KernelStatement state, long nodeId) throws EntityNotFoundException {
        try {
            return this.loadAllPropertiesOf(this.nodeStore.getRecord(nodeId));
        }
        catch (InvalidRecordException e) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId, e);
        }
    }

    @Override
    public Iterator<DefinedProperty> relationshipGetAllProperties(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        try {
            return this.loadAllPropertiesOf(this.relationshipStore.getRecord(relationshipId));
        }
        catch (InvalidRecordException e) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId, e);
        }
    }

    @Override
    public Iterator<DefinedProperty> graphGetAllProperties(KernelStatement state) {
        return this.loadAllPropertiesOf(this.neoStore.asRecord());
    }

    @Override
    public long nodeGetUniqueFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        try (IndexReader reader = state.getFreshIndexReader(this.constraintIndexId(index));){
            PrimitiveLongIterator iterator = reader.lookup(value);
            long l = IteratorUtil.single(iterator, -1L);
            return l;
        }
    }

    private Iterator<DefinedProperty> loadAllPropertiesOf(PrimitiveRecord primitiveRecord) {
        Collection<PropertyRecord> records = this.propertyStore.getPropertyRecordChain(primitiveRecord.getNextProp());
        if (null == records) {
            return IteratorUtil.emptyIterator();
        }
        ArrayList<DefinedProperty> properties = new ArrayList<DefinedProperty>();
        for (PropertyRecord record : records) {
            for (PropertyBlock block : record.getPropertyBlocks()) {
                properties.add(block.getType().readProperty(block.getKeyIndexId(), block, this.propertyStore));
            }
        }
        return properties.iterator();
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        return state.getIndexReader(this.indexId(index)).lookup(value);
    }

    @Override
    public void nodeAddStoreProperty(long nodeId, DefinedProperty property) {
        this.persistenceManager.nodeAddProperty(nodeId, property.propertyKeyId(), property.value());
    }

    @Override
    public void relationshipAddStoreProperty(long relationshipId, DefinedProperty property) {
        this.persistenceManager.relAddProperty(relationshipId, property.propertyKeyId(), property.value());
    }

    @Override
    public void graphAddStoreProperty(DefinedProperty property) {
        this.persistenceManager.graphAddProperty(property.propertyKeyId(), property.value());
    }

    @Override
    public void nodeChangeStoreProperty(long nodeId, DefinedProperty previousProperty, DefinedProperty property) {
        this.persistenceManager.nodeChangeProperty(nodeId, property.propertyKeyId(), property.value());
    }

    @Override
    public void relationshipChangeStoreProperty(long relationshipId, DefinedProperty previousProperty, DefinedProperty property) {
        this.persistenceManager.relChangeProperty(relationshipId, property.propertyKeyId(), property.value());
    }

    @Override
    public void graphChangeStoreProperty(DefinedProperty previousProperty, DefinedProperty property) {
        this.persistenceManager.graphChangeProperty(property.propertyKeyId(), property.value());
    }

    @Override
    public void nodeRemoveStoreProperty(long nodeId, DefinedProperty property) {
        this.persistenceManager.nodeRemoveProperty(nodeId, property.propertyKeyId());
    }

    @Override
    public void relationshipRemoveStoreProperty(long relationshipId, DefinedProperty property) {
        this.persistenceManager.relRemoveProperty(relationshipId, property.propertyKeyId());
    }

    @Override
    public void graphRemoveStoreProperty(DefinedProperty property) {
        this.persistenceManager.graphRemoveProperty(property.propertyKeyId());
    }

    @Override
    public Property nodeSetProperty(KernelStatement state, long nodeId, DefinedProperty property) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public Property relationshipSetProperty(KernelStatement state, long relationshipId, DefinedProperty property) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public Property graphSetProperty(KernelStatement state, DefinedProperty property) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public Property nodeRemoveProperty(KernelStatement state, long nodeId, int propertyKeyId) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public Property relationshipRemoveProperty(KernelStatement state, long relationshipId, int propertyKeyId) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public Property graphRemoveProperty(KernelStatement state, int propertyKeyId) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public void nodeDelete(KernelStatement state, long nodeId) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public void relationshipDelete(KernelStatement state, long relationshipId) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public void nodeDelete(long nodeId) {
        throw this.shouldNotManipulateStoreDirectly();
    }

    @Override
    public void relationshipDelete(long relationshipId) {
        throw this.shouldNotManipulateStoreDirectly();
    }

    @Override
    public boolean nodeAddLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        throw this.shouldNotManipulateStoreDirectly();
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        throw this.shouldNotManipulateStoreDirectly();
    }

    @Override
    public Property nodeGetProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }

    @Override
    public Property relationshipGetProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }

    @Override
    public Property graphGetProperty(KernelStatement state, int propertyKeyId) {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }

    @Override
    public PrimitiveLongIterator nodeGetPropertyKeys(KernelStatement state, long nodeId) throws EntityNotFoundException {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }

    @Override
    public PrimitiveLongIterator relationshipGetPropertyKeys(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }

    @Override
    public PrimitiveLongIterator graphGetPropertyKeys(KernelStatement state) {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }
}

