/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.KernelStatement;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.TransactionalException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.operations.AuxiliaryStoreOperations;
import org.neo4j.kernel.api.operations.EntityReadOperations;
import org.neo4j.kernel.api.operations.EntityWriteOperations;
import org.neo4j.kernel.api.operations.SchemaReadOperations;
import org.neo4j.kernel.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.PropertyKeyIdIterator;
import org.neo4j.kernel.impl.api.DiffSets;
import org.neo4j.kernel.impl.api.PrimitiveIntIterator;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.api.constraints.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.constraints.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.state.TxState;

public class StateHandlingStatementOperations
implements EntityReadOperations,
EntityWriteOperations,
SchemaReadOperations,
SchemaWriteOperations {
    private final EntityReadOperations entityReadDelegate;
    private final SchemaReadOperations schemaReadDelegate;
    private final AuxiliaryStoreOperations auxStoreOps;
    private final ConstraintIndexCreator constraintIndexCreator;

    public StateHandlingStatementOperations(EntityReadOperations entityReadDelegate, SchemaReadOperations schemaReadDelegate, AuxiliaryStoreOperations auxStoreOps, ConstraintIndexCreator constraintIndexCreator) {
        this.entityReadDelegate = entityReadDelegate;
        this.schemaReadDelegate = schemaReadDelegate;
        this.auxStoreOps = auxStoreOps;
        this.constraintIndexCreator = constraintIndexCreator;
    }

    @Override
    public void nodeDelete(KernelStatement state, long nodeId) {
        this.auxStoreOps.nodeDelete(nodeId);
        state.txState().nodeDoDelete(nodeId);
    }

    @Override
    public void relationshipDelete(KernelStatement state, long relationshipId) {
        this.auxStoreOps.relationshipDelete(relationshipId);
        state.txState().relationshipDoDelete(relationshipId);
    }

    @Override
    public boolean nodeHasLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().nodeIsDeletedInThisTx(nodeId)) {
                return false;
            }
            if (state.txState().nodeIsAddedInThisTx(nodeId)) {
                TxState.UpdateTriState labelState = state.txState().labelState(nodeId, labelId);
                return labelState.isTouched() && labelState.isAdded();
            }
            TxState.UpdateTriState labelState = state.txState().labelState(nodeId, labelId);
            if (labelState.isTouched()) {
                return labelState.isAdded();
            }
        }
        return this.entityReadDelegate.nodeHasLabel(state, nodeId, labelId);
    }

    @Override
    public PrimitiveIntIterator nodeGetLabels(KernelStatement state, long nodeId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().nodeIsDeletedInThisTx(nodeId)) {
                return IteratorUtil.emptyPrimitiveIntIterator();
            }
            if (state.txState().nodeIsAddedInThisTx(nodeId)) {
                return IteratorUtil.toPrimitiveIntIterator(state.txState().nodeStateLabelDiffSets(nodeId).getAdded().iterator());
            }
            return state.txState().nodeStateLabelDiffSets(nodeId).applyPrimitiveIntIterator(this.entityReadDelegate.nodeGetLabels(state, nodeId));
        }
        return this.entityReadDelegate.nodeGetLabels(state, nodeId);
    }

    @Override
    public boolean nodeAddLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        if (this.nodeHasLabel(state, nodeId, labelId)) {
            return false;
        }
        state.txState().nodeDoAddLabel(labelId, nodeId);
        return true;
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        if (!this.nodeHasLabel(state, nodeId, labelId)) {
            return false;
        }
        state.txState().nodeDoRemoveLabel(labelId, nodeId);
        return true;
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        if (state.hasTxStateWithChanges()) {
            PrimitiveLongIterator wLabelChanges = state.txState().nodesWithLabelChanged(labelId).applyPrimitiveLongIterator(this.entityReadDelegate.nodesGetForLabel(state, labelId));
            return state.txState().nodesDeletedInTx().applyPrimitiveLongIterator(wLabelChanges);
        }
        return this.entityReadDelegate.nodesGetForLabel(state, labelId);
    }

    @Override
    public IndexDescriptor indexCreate(KernelStatement state, int labelId, int propertyKey) {
        IndexDescriptor rule = new IndexDescriptor(labelId, propertyKey);
        state.txState().indexRuleDoAdd(rule);
        return rule;
    }

    @Override
    public void indexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        state.txState().indexDoDrop(descriptor);
    }

    @Override
    public void uniqueIndexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        state.txState().constraintIndexDoDrop(descriptor);
    }

    @Override
    public UniquenessConstraint uniquenessConstraintCreate(KernelStatement state, int labelId, int propertyKeyId) throws CreateConstraintFailureException {
        UniquenessConstraint constraint = new UniquenessConstraint(labelId, propertyKeyId);
        try {
            if (!state.txState().constraintDoUnRemove(constraint)) {
                Iterator<UniquenessConstraint> it = this.schemaReadDelegate.constraintsGetForLabelAndPropertyKey(state, labelId, propertyKeyId);
                while (it.hasNext()) {
                    if (!it.next().equals(labelId, propertyKeyId)) continue;
                    return constraint;
                }
                long indexId = this.constraintIndexCreator.createUniquenessConstraintIndex(state, this, labelId, propertyKeyId);
                state.txState().constraintDoAdd(constraint, indexId);
            }
            return constraint;
        }
        catch (TransactionalException | DropIndexFailureException | ConstraintVerificationFailedKernelException e) {
            throw new CreateConstraintFailureException(constraint, (Throwable)e);
        }
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKeyId) {
        return this.applyConstraintsDiff(state, this.schemaReadDelegate.constraintsGetForLabelAndPropertyKey(state, labelId, propertyKeyId), labelId, propertyKeyId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(KernelStatement state, int labelId) {
        return this.applyConstraintsDiff(state, this.schemaReadDelegate.constraintsGetForLabel(state, labelId), labelId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll(KernelStatement state) {
        return this.applyConstraintsDiff(state, this.schemaReadDelegate.constraintsGetAll(state));
    }

    private Iterator<UniquenessConstraint> applyConstraintsDiff(KernelStatement state, Iterator<UniquenessConstraint> constraints, int labelId, int propertyKeyId) {
        DiffSets<UniquenessConstraint> diff;
        if (state.hasTxStateWithChanges() && (diff = state.txState().constraintsChangesForLabelAndProperty(labelId, propertyKeyId)) != null) {
            return diff.apply(constraints);
        }
        return constraints;
    }

    private Iterator<UniquenessConstraint> applyConstraintsDiff(KernelStatement state, Iterator<UniquenessConstraint> constraints, int labelId) {
        DiffSets<UniquenessConstraint> diff;
        if (state.hasTxStateWithChanges() && (diff = state.txState().constraintsChangesForLabel(labelId)) != null) {
            return diff.apply(constraints);
        }
        return constraints;
    }

    private Iterator<UniquenessConstraint> applyConstraintsDiff(KernelStatement state, Iterator<UniquenessConstraint> constraints) {
        DiffSets<UniquenessConstraint> diff;
        if (state.hasTxStateWithChanges() && (diff = state.txState().constraintsChanges()) != null) {
            return diff.apply(constraints);
        }
        return constraints;
    }

    @Override
    public void constraintDrop(KernelStatement state, UniquenessConstraint constraint) {
        state.txState().constraintDoDrop(constraint);
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKey) throws SchemaRuleNotFoundException {
        Iterable<Object> committedRules;
        try {
            committedRules = Iterables.option(this.schemaReadDelegate.indexesGetForLabelAndPropertyKey(state, labelId, propertyKey));
        }
        catch (SchemaRuleNotFoundException e) {
            committedRules = Collections.emptyList();
        }
        DiffSets<IndexDescriptor> ruleDiffSet = state.txState().indexDiffSetsByLabel(labelId);
        Iterator<Object> rules = state.hasTxStateWithChanges() ? ruleDiffSet.apply(committedRules.iterator()) : committedRules.iterator();
        IndexDescriptor single = (IndexDescriptor)IteratorUtil.singleOrNull(rules);
        if (single == null) {
            throw new SchemaRuleNotFoundException("Index rule for label:" + labelId + " and property:" + propertyKey + " not found");
        }
        return single;
    }

    @Override
    public InternalIndexState indexGetState(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        if (state.hasTxStateWithChanges()) {
            if (this.checkIndexState(descriptor, state.txState().indexDiffSetsByLabel(descriptor.getLabelId()))) {
                return InternalIndexState.POPULATING;
            }
            if (this.checkIndexState(descriptor, state.txState().constraintIndexDiffSetsByLabel(descriptor.getLabelId()))) {
                return InternalIndexState.POPULATING;
            }
        }
        return this.schemaReadDelegate.indexGetState(state, descriptor);
    }

    private boolean checkIndexState(IndexDescriptor indexRule, DiffSets<IndexDescriptor> diffSet) throws IndexNotFoundKernelException {
        if (diffSet.isAdded(indexRule)) {
            return true;
        }
        if (diffSet.isRemoved(indexRule)) {
            throw new IndexNotFoundKernelException(String.format("Index for label id %d on property id %d has been dropped in this transaction.", indexRule.getLabelId(), indexRule.getPropertyKeyId()));
        }
        return false;
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(KernelStatement state, int labelId) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().indexDiffSetsByLabel(labelId).apply(this.schemaReadDelegate.indexesGetForLabel(state, labelId));
        }
        return this.schemaReadDelegate.indexesGetForLabel(state, labelId);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().indexChanges().apply(this.schemaReadDelegate.indexesGetAll(state));
        }
        return this.schemaReadDelegate.indexesGetAll(state);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(KernelStatement state, int labelId) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintIndexDiffSetsByLabel(labelId).apply(this.schemaReadDelegate.uniqueIndexesGetForLabel(state, labelId));
        }
        return this.schemaReadDelegate.uniqueIndexesGetForLabel(state, labelId);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintIndexChanges().apply(this.schemaReadDelegate.uniqueIndexesGetAll(state));
        }
        return this.schemaReadDelegate.uniqueIndexesGetAll(state);
    }

    @Override
    public long nodeGetUniqueFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        if (state.hasTxStateWithChanges()) {
            TxState txState = state.txState();
            DiffSets<Long> diff = this.nodesWithLabelAndPropertyDiffSet(state, index, value);
            long indexNode = this.entityReadDelegate.nodeGetUniqueFromIndexLookup(state, index, value);
            if (diff.isEmpty()) {
                if (-1L == indexNode) {
                    return -1L;
                }
                return this.nodeIfNotDeleted(indexNode, txState);
            }
            if (-1L == indexNode) {
                Iterator<Long> iterator = diff.getAdded().iterator();
                if (iterator.hasNext()) {
                    return IteratorUtil.single(txState.nodesDeletedInTx().apply(iterator), Long.valueOf(-1L));
                }
                return -1L;
            }
            return IteratorUtil.single(txState.nodesDeletedInTx().applyPrimitiveLongIterator(diff.applyPrimitiveLongIterator(IteratorUtil.asPrimitiveIterator(indexNode))), -1L);
        }
        return this.entityReadDelegate.nodeGetUniqueFromIndexLookup(state, index, value);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        if (state.hasTxStateWithChanges()) {
            TxState txState = state.txState();
            DiffSets<Long> diff = this.nodesWithLabelAndPropertyDiffSet(state, index, value);
            PrimitiveLongIterator committed = this.entityReadDelegate.nodesGetFromIndexLookup(state, index, value);
            return txState.nodesDeletedInTx().applyPrimitiveLongIterator(diff.applyPrimitiveLongIterator(committed));
        }
        return this.entityReadDelegate.nodesGetFromIndexLookup(state, index, value);
    }

    @Override
    public Property nodeSetProperty(KernelStatement state, long nodeId, DefinedProperty property) throws EntityNotFoundException {
        Property existingProperty = this.nodeGetProperty(state, nodeId, property.propertyKeyId());
        if (!existingProperty.isDefined()) {
            this.auxStoreOps.nodeAddStoreProperty(nodeId, property);
        } else {
            this.auxStoreOps.nodeChangeStoreProperty(nodeId, (DefinedProperty)existingProperty, property);
        }
        state.txState().nodeDoReplaceProperty(nodeId, existingProperty, property);
        return existingProperty;
    }

    @Override
    public Property relationshipSetProperty(KernelStatement state, long relationshipId, DefinedProperty property) throws EntityNotFoundException {
        Property existingProperty = this.relationshipGetProperty(state, relationshipId, property.propertyKeyId());
        if (!existingProperty.isDefined()) {
            this.auxStoreOps.relationshipAddStoreProperty(relationshipId, property);
        } else {
            this.auxStoreOps.relationshipChangeStoreProperty(relationshipId, (DefinedProperty)existingProperty, property);
        }
        state.txState().relationshipDoReplaceProperty(relationshipId, existingProperty, property);
        return existingProperty;
    }

    @Override
    public Property graphSetProperty(KernelStatement state, DefinedProperty property) {
        Property existingProperty = this.graphGetProperty(state, property.propertyKeyId());
        if (!existingProperty.isDefined()) {
            this.auxStoreOps.graphAddStoreProperty(property);
        } else {
            this.auxStoreOps.graphChangeStoreProperty((DefinedProperty)existingProperty, property);
        }
        state.txState().graphDoReplaceProperty(existingProperty, property);
        return existingProperty;
    }

    @Override
    public Property nodeRemoveProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        Property existingProperty = this.nodeGetProperty(state, nodeId, propertyKeyId);
        if (existingProperty.isDefined()) {
            this.auxStoreOps.nodeRemoveStoreProperty(nodeId, (DefinedProperty)existingProperty);
        }
        state.txState().nodeDoRemoveProperty(nodeId, existingProperty);
        return existingProperty;
    }

    @Override
    public Property relationshipRemoveProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        Property existingProperty = this.relationshipGetProperty(state, relationshipId, propertyKeyId);
        if (existingProperty.isDefined()) {
            this.auxStoreOps.relationshipRemoveStoreProperty(relationshipId, (DefinedProperty)existingProperty);
        }
        state.txState().relationshipDoRemoveProperty(relationshipId, existingProperty);
        return existingProperty;
    }

    @Override
    public Property graphRemoveProperty(KernelStatement state, int propertyKeyId) {
        Property existingProperty = this.graphGetProperty(state, propertyKeyId);
        if (existingProperty.isDefined()) {
            this.auxStoreOps.graphRemoveStoreProperty((DefinedProperty)existingProperty);
        }
        state.txState().graphDoRemoveProperty(existingProperty);
        return existingProperty;
    }

    @Override
    public PrimitiveLongIterator nodeGetPropertyKeys(KernelStatement state, long nodeId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            return new PropertyKeyIdIterator(this.nodeGetAllProperties(state, nodeId));
        }
        return this.entityReadDelegate.nodeGetPropertyKeys(state, nodeId);
    }

    @Override
    public Property nodeGetProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            Iterator<DefinedProperty> properties = this.nodeGetAllProperties(state, nodeId);
            while (properties.hasNext()) {
                Property property = properties.next();
                if (property.propertyKeyId() != propertyKeyId) continue;
                return property;
            }
            return Property.noNodeProperty(nodeId, propertyKeyId);
        }
        return this.entityReadDelegate.nodeGetProperty(state, nodeId, propertyKeyId);
    }

    @Override
    public Iterator<DefinedProperty> nodeGetAllProperties(KernelStatement state, long nodeId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().nodeIsAddedInThisTx(nodeId)) {
                return state.txState().nodePropertyDiffSets(nodeId).getAdded().iterator();
            }
            if (state.txState().nodeIsDeletedInThisTx(nodeId)) {
                throw new IllegalStateException("Node " + nodeId + " has been deleted");
            }
            return state.txState().nodePropertyDiffSets(nodeId).apply(this.entityReadDelegate.nodeGetAllProperties(state, nodeId));
        }
        return this.entityReadDelegate.nodeGetAllProperties(state, nodeId);
    }

    @Override
    public PrimitiveLongIterator relationshipGetPropertyKeys(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            return new PropertyKeyIdIterator(this.relationshipGetAllProperties(state, relationshipId));
        }
        return this.entityReadDelegate.relationshipGetPropertyKeys(state, relationshipId);
    }

    @Override
    public Property relationshipGetProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            Iterator<DefinedProperty> properties = this.relationshipGetAllProperties(state, relationshipId);
            while (properties.hasNext()) {
                Property property = properties.next();
                if (property.propertyKeyId() != propertyKeyId) continue;
                return property;
            }
            return Property.noRelationshipProperty(relationshipId, propertyKeyId);
        }
        return this.entityReadDelegate.relationshipGetProperty(state, relationshipId, propertyKeyId);
    }

    @Override
    public Iterator<DefinedProperty> relationshipGetAllProperties(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().relationshipIsAddedInThisTx(relationshipId)) {
                return state.txState().relationshipPropertyDiffSets(relationshipId).getAdded().iterator();
            }
            if (state.txState().relationshipIsDeletedInThisTx(relationshipId)) {
                throw new IllegalStateException("Relationship " + relationshipId + " has been deleted");
            }
            return state.txState().relationshipPropertyDiffSets(relationshipId).apply(this.entityReadDelegate.relationshipGetAllProperties(state, relationshipId));
        }
        return this.entityReadDelegate.relationshipGetAllProperties(state, relationshipId);
    }

    @Override
    public PrimitiveLongIterator graphGetPropertyKeys(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return new PropertyKeyIdIterator(this.graphGetAllProperties(state));
        }
        return this.entityReadDelegate.graphGetPropertyKeys(state);
    }

    @Override
    public Property graphGetProperty(KernelStatement state, int propertyKeyId) {
        Iterator<DefinedProperty> properties = this.graphGetAllProperties(state);
        while (properties.hasNext()) {
            Property property = properties.next();
            if (property.propertyKeyId() != propertyKeyId) continue;
            return property;
        }
        return Property.noGraphProperty(propertyKeyId);
    }

    @Override
    public Iterator<DefinedProperty> graphGetAllProperties(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().graphPropertyDiffSets().apply(this.entityReadDelegate.graphGetAllProperties(state));
        }
        return this.entityReadDelegate.graphGetAllProperties(state);
    }

    private DiffSets<Long> nodesWithLabelAndPropertyDiffSet(KernelStatement state, IndexDescriptor index, Object value) {
        TxState txState = state.txState();
        int labelId = index.getLabelId();
        int propertyKeyId = index.getPropertyKeyId();
        DiffSets<Long> diff = txState.nodesWithChangedProperty(propertyKeyId, value);
        HasLabelFilter hasLabel = new HasLabelFilter(state, labelId);
        diff = diff.filter(hasLabel);
        HasPropertyFilter hasPropertyFilter = new HasPropertyFilter(state, propertyKeyId, value);
        Iterator<Long> addedNodesWithLabel = txState.nodesWithLabelAdded(labelId).iterator();
        diff.addAll(Iterables.filter(hasPropertyFilter, addedNodesWithLabel));
        Set<Long> removedNodesWithLabel = txState.nodesWithLabelChanged(index.getLabelId()).getRemoved();
        diff.removeAll(Iterables.filter(hasPropertyFilter, removedNodesWithLabel.iterator()));
        return diff;
    }

    private long nodeIfNotDeleted(long nodeId, TxState txState) {
        return txState.nodeIsDeletedInThisTx(nodeId) ? -1L : nodeId;
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(KernelStatement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.schemaReadDelegate.indexGetOwningUniquenessConstraintId(state, index);
    }

    @Override
    public long indexGetCommittedId(KernelStatement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.schemaReadDelegate.indexGetCommittedId(state, index);
    }

    @Override
    public String indexGetFailure(Statement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.schemaReadDelegate.indexGetFailure(state, descriptor);
    }

    private class HasLabelFilter
    implements Predicate<Long> {
        private final int labelId;
        private final KernelStatement state;

        public HasLabelFilter(KernelStatement state, int labelId) {
            this.state = state;
            this.labelId = labelId;
        }

        @Override
        public boolean accept(Long nodeId) {
            try {
                return StateHandlingStatementOperations.this.nodeHasLabel(this.state, nodeId, this.labelId);
            }
            catch (EntityNotFoundException e) {
                return false;
            }
        }
    }

    private class HasPropertyFilter
    implements Predicate<Long> {
        private final Object value;
        private final int propertyKeyId;
        private final KernelStatement state;

        public HasPropertyFilter(KernelStatement state, int propertyKeyId, Object value) {
            this.state = state;
            this.value = value;
            this.propertyKeyId = propertyKeyId;
        }

        @Override
        public boolean accept(Long nodeId) {
            try {
                if (this.state.hasTxStateWithChanges() && this.state.txState().nodeIsDeletedInThisTx(nodeId)) {
                    return false;
                }
                Property property = StateHandlingStatementOperations.this.nodeGetProperty(this.state, nodeId, this.propertyKeyId);
                return property.isDefined() && property.valueEquals(this.value);
            }
            catch (EntityNotFoundException e) {
                return false;
            }
        }
    }
}

