/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.operations;

import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.operations.TokenNameLookup;

public final class StatementTokenNameLookup
implements TokenNameLookup {
    private final ReadOperations statement;

    public StatementTokenNameLookup(ReadOperations statement) {
        this.statement = statement;
    }

    @Override
    public String labelGetName(int labelId) {
        try {
            return this.statement.labelGetName(labelId);
        }
        catch (LabelNotFoundKernelException e) {
            return "[" + labelId + "]";
        }
    }

    @Override
    public String propertyKeyGetName(int propertyKeyId) {
        try {
            return this.statement.propertyKeyGetName(propertyKeyId);
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            return "[" + propertyKeyId + "]";
        }
    }
}

