/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.KernelTransactionImplementation;
import org.neo4j.kernel.api.OperationsFacade;
import org.neo4j.kernel.api.ReadOnlyDatabaseKernelException;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementOperationParts;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.labelscan.LabelScanReader;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.operations.LegacyKernelOperations;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.LockHolder;
import org.neo4j.kernel.impl.api.state.TxState;

public class KernelStatement
implements TxState.Holder,
Statement {
    private final KernelTransactionImplementation transaction;
    protected final LockHolder lockHolder;
    protected final TxState.Holder txStateHolder;
    protected final IndexReaderFactory indexReaderFactory;
    protected final LabelScanStore labelScanStore;
    private LabelScanReader labelScanReader;
    private int referenceCount;
    private final OperationsFacade facade;
    private boolean closed;

    public KernelStatement(KernelTransactionImplementation transaction, IndexReaderFactory indexReaderFactory, LabelScanStore labelScanStore, TxState.Holder txStateHolder, LockHolder lockHolder, LegacyKernelOperations legacyKernelOperations, StatementOperationParts operations) {
        this.transaction = transaction;
        this.lockHolder = lockHolder;
        this.indexReaderFactory = indexReaderFactory;
        this.txStateHolder = txStateHolder;
        this.labelScanStore = labelScanStore;
        this.facade = new OperationsFacade(this, legacyKernelOperations, operations);
    }

    @Override
    public ReadOperations readOperations() {
        return this.facade;
    }

    @Override
    public TokenWriteOperations tokenWriteOperations() throws ReadOnlyDatabaseKernelException {
        this.transaction.assertTokenWriteAllowed();
        return this.facade;
    }

    @Override
    public DataWriteOperations dataWriteOperations() throws InvalidTransactionTypeKernelException, ReadOnlyDatabaseKernelException {
        this.transaction.upgradeToDataTransaction();
        return this.facade;
    }

    @Override
    public SchemaWriteOperations schemaWriteOperations() throws InvalidTransactionTypeKernelException, ReadOnlyDatabaseKernelException {
        this.transaction.upgradeToSchemaTransaction();
        return this.facade;
    }

    @Override
    public TxState txState() {
        return this.txStateHolder.txState();
    }

    @Override
    public boolean hasTxState() {
        return this.txStateHolder.hasTxState();
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.txStateHolder.hasTxStateWithChanges();
    }

    @Override
    public void close() {
        if (!this.closed && this.release()) {
            this.closed = true;
            this.indexReaderFactory.close();
            if (null != this.labelScanReader) {
                this.labelScanReader.close();
            }
            this.transaction.releaseStatement(this);
        }
    }

    void assertOpen() {
        if (this.closed) {
            throw new NotInTransactionException("The statement has been closed.");
        }
    }

    public LockHolder locks() {
        return this.lockHolder;
    }

    public IndexReader getIndexReader(long indexId) throws IndexNotFoundKernelException {
        return this.indexReaderFactory.newReader(indexId);
    }

    public IndexReader getFreshIndexReader(long indexId) throws IndexNotFoundKernelException {
        return this.indexReaderFactory.newUnCachedReader(indexId);
    }

    public LabelScanReader getLabelScanReader() {
        if (this.labelScanReader == null) {
            this.labelScanReader = this.labelScanStore.newReader();
        }
        return this.labelScanReader;
    }

    final void acquire() {
        ++this.referenceCount;
    }

    private boolean release() {
        return --this.referenceCount == 0;
    }

    final void forceClose() {
        this.referenceCount = 0;
        this.close();
    }
}

