/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.lifecycle.Lifecycle;

public abstract class AbstractTransactionManager
implements TransactionManager,
Lifecycle {
    public void begin(ForceMode forceMode) throws NotSupportedException, SystemException {
        this.begin();
    }

    public abstract void doRecovery() throws Throwable;

    public ForceMode getForceMode() {
        return ForceMode.forced;
    }

    public abstract TransactionState getTransactionState();

    public abstract int getEventIdentifier();

    public Throwable getRecoveryError() {
        return null;
    }

    @Deprecated
    public abstract void setKernel(KernelAPI var1);

    @Deprecated
    public KernelTransaction getKernelTransaction() {
        throw new UnsupportedOperationException(String.format("The current transaction manager implementation [%s] does not support the new TransactionContext interface. This is an intermediary problem during transition to a new internal API.", this.getClass().getName()));
    }

    public void assertInTransaction() {
        try {
            if (this.getTransaction() == null) {
                throw new NotInTransactionException();
            }
        }
        catch (SystemException e) {
            throw new IllegalStateException("Unable to determine transaction state", e);
        }
    }
}

