/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;
import org.neo4j.kernel.impl.persistence.NeoStoreTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;

class ReadTransaction
implements NeoStoreTransaction {
    private final NeoStore neoStore;

    public ReadTransaction(NeoStore neoStore) {
        this.neoStore = neoStore;
    }

    private NodeStore getNodeStore() {
        return this.neoStore.getNodeStore();
    }

    private int getRelGrabSize() {
        return this.neoStore.getRelationshipGrabSize();
    }

    private RelationshipStore getRelationshipStore() {
        return this.neoStore.getRelationshipStore();
    }

    private PropertyStore getPropertyStore() {
        return this.neoStore.getPropertyStore();
    }

    @Override
    public NodeRecord nodeLoadLight(long nodeId) {
        return this.getNodeStore().loadLightNode(nodeId);
    }

    @Override
    public RelationshipRecord relLoadLight(long id) {
        return this.getRelationshipStore().getLightRel(id);
    }

    @Override
    public long getRelationshipChainPosition(long nodeId) {
        return this.getNodeStore().getRecord(nodeId).getNextRel();
    }

    @Override
    public Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, Long> getMoreRelationships(long nodeId, long position) {
        return ReadTransaction.getMoreRelationships(nodeId, position, this.getRelGrabSize(), this.getRelationshipStore());
    }

    static Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, Long> getMoreRelationships(long nodeId, long position, int grabSize, RelationshipStore relStore) {
        ArrayList<RelationshipRecord> out = new ArrayList<RelationshipRecord>();
        ArrayList<RelationshipRecord> in = new ArrayList<RelationshipRecord>();
        ArrayList<RelationshipRecord> loop = null;
        EnumMap result = new EnumMap(RelIdArray.DirectionWrapper.class);
        result.put(RelIdArray.DirectionWrapper.OUTGOING, out);
        result.put(RelIdArray.DirectionWrapper.INCOMING, in);
        for (int i = 0; i < grabSize && position != (long)Record.NO_NEXT_RELATIONSHIP.intValue(); ++i) {
            RelationshipRecord relRecord = relStore.getChainRecord(position);
            if (relRecord == null) {
                return Pair.of(result, position);
            }
            long firstNode = relRecord.getFirstNode();
            long secondNode = relRecord.getSecondNode();
            if (relRecord.inUse()) {
                if (firstNode == secondNode) {
                    if (loop == null) {
                        loop = new ArrayList<RelationshipRecord>();
                        result.put(RelIdArray.DirectionWrapper.BOTH, loop);
                    }
                    loop.add(relRecord);
                } else if (firstNode == nodeId) {
                    out.add(relRecord);
                } else if (secondNode == nodeId) {
                    in.add(relRecord);
                }
            } else {
                --i;
            }
            if (firstNode == nodeId) {
                position = relRecord.getFirstNextRel();
                continue;
            }
            if (secondNode == nodeId) {
                position = relRecord.getSecondNextRel();
                continue;
            }
            throw new InvalidRecordException("Node[" + nodeId + "] is neither firstNode[" + firstNode + "] nor secondNode[" + secondNode + "] for Relationship[" + relRecord.getId() + "]");
        }
        return Pair.of(result, position);
    }

    static void loadPropertyChain(Collection<PropertyRecord> chain, PropertyStore propertyStore, NeoStoreTransaction.PropertyReceiver receiver) {
        if (chain != null) {
            for (PropertyRecord propRecord : chain) {
                for (PropertyBlock propBlock : propRecord.getPropertyBlocks()) {
                    receiver.receive(propBlock.newPropertyData(propertyStore), propRecord.getId());
                }
            }
        }
    }

    static void loadProperties(PropertyStore propertyStore, long nextProp, NeoStoreTransaction.PropertyReceiver receiver) {
        Collection<PropertyRecord> chain = propertyStore.getPropertyRecordChain(nextProp);
        if (chain != null) {
            ReadTransaction.loadPropertyChain(chain, propertyStore, receiver);
        }
    }

    @Override
    public void relLoadProperties(long relId, boolean light, NeoStoreTransaction.PropertyReceiver receiver) {
        RelationshipRecord relRecord = this.getRelationshipStore().getRecord(relId);
        if (!relRecord.inUse()) {
            throw new InvalidRecordException("Relationship[" + relId + "] not in use");
        }
        ReadTransaction.loadProperties(this.getPropertyStore(), relRecord.getNextProp(), receiver);
    }

    @Override
    public void nodeLoadProperties(long nodeId, boolean light, NeoStoreTransaction.PropertyReceiver receiver) {
        ReadTransaction.loadProperties(this.getPropertyStore(), this.getNodeStore().getRecord(nodeId).getNextProp(), receiver);
    }

    @Override
    public void graphLoadProperties(boolean light, NeoStoreTransaction.PropertyReceiver receiver) {
        ReadTransaction.loadProperties(this.getPropertyStore(), this.neoStore.getGraphNextProp(), receiver);
    }

    @Override
    public Token[] loadAllPropertyKeyTokens() {
        PropertyKeyTokenStore indexStore = this.getPropertyStore().getPropertyKeyTokenStore();
        return indexStore.getTokens(Integer.MAX_VALUE);
    }

    @Override
    public Token[] loadAllLabelTokens() {
        return this.neoStore.getLabelTokenStore().getTokens(Integer.MAX_VALUE);
    }

    @Override
    public void setXaConnection(XaConnection connection) {
    }

    @Override
    public boolean delistResource(Transaction tx, int tmsuccess) throws SystemException {
        throw this.readOnlyException();
    }

    private IllegalStateException readOnlyException() {
        return new IllegalStateException("This is a read only transaction, this method should never be invoked");
    }

    @Override
    public void destroy() {
        throw this.readOnlyException();
    }

    @Override
    public ArrayMap<Integer, DefinedProperty> nodeDelete(long nodeId) {
        throw this.readOnlyException();
    }

    @Override
    public DefinedProperty nodeAddProperty(long nodeId, int propertyKey, Object value) {
        throw this.readOnlyException();
    }

    @Override
    public DefinedProperty nodeChangeProperty(long nodeId, int propertyKey, Object value) {
        throw this.readOnlyException();
    }

    @Override
    public void nodeRemoveProperty(long nodeId, int propertyKey) {
        throw this.readOnlyException();
    }

    @Override
    public void nodeCreate(long id) {
        throw this.readOnlyException();
    }

    @Override
    public void relationshipCreate(long id, int typeId, long startNodeId, long endNodeId) {
        throw this.readOnlyException();
    }

    @Override
    public ArrayMap<Integer, DefinedProperty> relDelete(long relId) {
        throw this.readOnlyException();
    }

    @Override
    public DefinedProperty relAddProperty(long relId, int propertyKey, Object value) {
        throw this.readOnlyException();
    }

    @Override
    public DefinedProperty relChangeProperty(long relId, int propertyKey, Object value) {
        throw this.readOnlyException();
    }

    @Override
    public void relRemoveProperty(long relId, int propertyKey) {
        throw this.readOnlyException();
    }

    @Override
    public Token[] loadRelationshipTypes() {
        Token[] relTypeData = this.neoStore.getRelationshipTypeStore().getTokens(Integer.MAX_VALUE);
        Token[] rawRelTypeData = new Token[relTypeData.length];
        for (int i = 0; i < relTypeData.length; ++i) {
            rawRelTypeData[i] = new Token(relTypeData[i].name(), relTypeData[i].id());
        }
        return rawRelTypeData;
    }

    @Override
    public void createPropertyKeyToken(String key, int id) {
        throw this.readOnlyException();
    }

    @Override
    public void createLabelToken(String name, int id) {
        throw this.readOnlyException();
    }

    @Override
    public void createRelationshipTypeToken(int id, String name) {
        throw this.readOnlyException();
    }

    @Override
    public DefinedProperty graphAddProperty(int propertyKey, Object value) {
        throw this.readOnlyException();
    }

    @Override
    public DefinedProperty graphChangeProperty(int propertyKey, Object value) {
        throw this.readOnlyException();
    }

    @Override
    public void graphRemoveProperty(int propertyKey) {
        throw this.readOnlyException();
    }

    @Override
    public void createSchemaRule(SchemaRule schemaRule) {
        throw this.readOnlyException();
    }

    @Override
    public void dropSchemaRule(SchemaRule rule) {
        throw this.readOnlyException();
    }

    @Override
    public void addLabelToNode(int labelId, long nodeId) {
        throw this.readOnlyException();
    }

    @Override
    public void removeLabelFromNode(int labelId, long nodeId) {
        throw this.readOnlyException();
    }

    @Override
    public PrimitiveLongIterator getLabelsForNode(long nodeId) {
        NodeRecord node = this.getNodeStore().getRecord(nodeId);
        return IteratorUtil.asPrimitiveIterator(NodeLabelsField.parseLabelsField(node).get(this.getNodeStore()));
    }

    @Override
    public void setConstraintIndexOwner(IndexRule constraintIndex, long constraintId) {
        throw this.readOnlyException();
    }
}

