/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store.labels;

import java.util.Arrays;

public class LabelIdArray {
    static long[] concatAndSort(long[] existing, long additional) {
        LabelIdArray.assertNotContains(existing, additional);
        long[] result = new long[existing.length + 1];
        System.arraycopy(existing, 0, result, 0, existing.length);
        result[existing.length] = additional;
        Arrays.sort(result);
        return result;
    }

    private static void assertNotContains(long[] existingLabels, long labelId) {
        if (Arrays.binarySearch(existingLabels, labelId) >= 0) {
            throw new IllegalStateException("Label " + labelId + " already exists.");
        }
    }

    static long[] filter(long[] ids, long excludeId) {
        boolean found = false;
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] != excludeId) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException("Label " + excludeId + " not found.");
        }
        long[] result = new long[ids.length - 1];
        int writerIndex = 0;
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == excludeId) continue;
            result[writerIndex++] = ids[i];
        }
        return result;
    }
}

