/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.ReadOnlyDatabaseKernelException;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.TokenNotFoundException;

public class RelationshipProxy
implements Relationship {
    private final long relId;
    private final RelationshipLookups relationshipLookups;
    private final ThreadToStatementContextBridge statementContextProvider;

    RelationshipProxy(long relId, RelationshipLookups relationshipLookups, ThreadToStatementContextBridge statementContextProvider) {
        this.relId = relId;
        this.relationshipLookups = relationshipLookups;
        this.statementContextProvider = statementContextProvider;
    }

    @Override
    public long getId() {
        return this.relId;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.relationshipLookups.getGraphDatabaseService();
    }

    @Override
    public void delete() {
        try (Statement statement = this.statementContextProvider.statement();){
            statement.dataWriteOperations().relationshipDelete(this.getId());
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (ReadOnlyDatabaseKernelException e) {
            throw new ReadOnlyDbException();
        }
    }

    @Override
    public Node[] getNodes() {
        this.assertInTransaction();
        RelationshipImpl relationship = this.relationshipLookups.lookupRelationship(this.relId);
        return new Node[]{this.relationshipLookups.newNodeProxy(relationship.getStartNodeId()), this.relationshipLookups.newNodeProxy(relationship.getEndNodeId())};
    }

    @Override
    public Node getOtherNode(Node node) {
        this.assertInTransaction();
        RelationshipImpl relationship = this.relationshipLookups.lookupRelationship(this.relId);
        if (relationship.getStartNodeId() == node.getId()) {
            return this.relationshipLookups.newNodeProxy(relationship.getEndNodeId());
        }
        if (relationship.getEndNodeId() == node.getId()) {
            return this.relationshipLookups.newNodeProxy(relationship.getStartNodeId());
        }
        throw new NotFoundException("Node[" + node.getId() + "] not connected to this relationship[" + this.getId() + "]");
    }

    @Override
    public Node getStartNode() {
        this.assertInTransaction();
        return this.relationshipLookups.newNodeProxy(this.relationshipLookups.lookupRelationship(this.relId).getStartNodeId());
    }

    @Override
    public Node getEndNode() {
        this.assertInTransaction();
        return this.relationshipLookups.newNodeProxy(this.relationshipLookups.lookupRelationship(this.relId).getEndNodeId());
    }

    @Override
    public RelationshipType getType() {
        this.assertInTransaction();
        try {
            return this.relationshipLookups.getNodeManager().getRelationshipTypeById(this.relationshipLookups.lookupRelationship(this.relId).getTypeId());
        }
        catch (TokenNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<String> getPropertyKeys() {
        try (Statement statement = this.statementContextProvider.statement();){
            ArrayList<String> keys = new ArrayList<String>();
            Iterator<DefinedProperty> properties = statement.readOperations().relationshipGetAllProperties(this.getId());
            while (properties.hasNext()) {
                keys.add(statement.readOperations().propertyKeyGetName(properties.next().propertyKeyId()));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Relationship not found", e);
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new ThisShouldNotHappenError("Jake", "Property key retrieved through kernel API should exist.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<Object> getPropertyValues() {
        try (Statement statement = this.statementContextProvider.statement();){
            Set<Object> set = IteratorUtil.asSet(Iterables.map(new Function<DefinedProperty, Object>(){

                @Override
                public Object apply(DefinedProperty prop) {
                    return prop.value();
                }
            }, statement.readOperations().relationshipGetAllProperties(this.getId())));
            return set;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Relationship has been deleted", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getProperty(String key) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (Statement statement = this.statementContextProvider.statement();){
            int propertyId = statement.readOperations().propertyKeyGetForName(key);
            if (propertyId == -1) {
                throw new NotFoundException(String.format("No such property, '%s'.", key));
            }
            Object object = statement.readOperations().relationshipGetProperty(this.relId, propertyId).value();
            return object;
        }
        catch (EntityNotFoundException | PropertyNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (Statement statement = this.statementContextProvider.statement();){
            int propertyId = statement.readOperations().propertyKeyGetForName(key);
            Object object = statement.readOperations().relationshipGetProperty(this.relId, propertyId).value(defaultValue);
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        try (Statement statement = this.statementContextProvider.statement();){
            int propertyId = statement.readOperations().propertyKeyGetForName(key);
            boolean bl = propertyId != -1 && statement.readOperations().relationshipGetProperty(this.relId, propertyId).isDefined();
            return bl;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setProperty(String key, Object value) {
        boolean success = false;
        try (Statement statement = this.statementContextProvider.statement();){
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            statement.dataWriteOperations().relationshipSetProperty(this.relId, Property.property(propertyKeyId, value));
            success = true;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (ReadOnlyDatabaseKernelException e) {
            throw new ReadOnlyDbException();
        }
        finally {
            if (!success) {
                this.relationshipLookups.getNodeManager().setRollbackOnly();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object removeProperty(String key) {
        try (Statement statement = this.statementContextProvider.statement();){
            int propertyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            Object object = statement.dataWriteOperations().relationshipRemoveProperty(this.relId, propertyId).value(null);
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (ReadOnlyDatabaseKernelException e) {
            throw new ReadOnlyDbException();
        }
    }

    @Override
    public boolean isType(RelationshipType type) {
        this.assertInTransaction();
        try {
            return this.relationshipLookups.getNodeManager().getRelationshipTypeById(this.relationshipLookups.lookupRelationship(this.relId).getTypeId()).name().equals(type.name());
        }
        catch (TokenNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    public int compareTo(Object rel) {
        long theirId;
        Relationship r = (Relationship)rel;
        long ourId = this.getId();
        if (ourId < (theirId = r.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof Relationship && this.getId() == ((Relationship)o).getId();
    }

    public int hashCode() {
        return (int)(this.relId >>> 32 ^ this.relId);
    }

    public String toString() {
        return "Relationship[" + this.getId() + "]";
    }

    private void assertInTransaction() {
        this.statementContextProvider.assertInTransaction();
    }

    public static interface RelationshipLookups {
        public Node newNodeProxy(long var1);

        public RelationshipImpl lookupRelationship(long var1);

        public GraphDatabaseService getGraphDatabaseService();

        public NodeManager getNodeManager();
    }
}

