/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.ReadOnlyDatabaseKernelException;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.PropertyKeyIdIterator;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.core.WritableTransactionState;
import org.neo4j.kernel.impl.util.ArrayMap;

public class GraphPropertiesImpl
extends Primitive
implements GraphProperties {
    private final NodeManager nodeManager;
    private Map<Integer, DefinedProperty> properties;
    private final ThreadToStatementContextBridge statementContextProvider;

    GraphPropertiesImpl(NodeManager nodeManager, ThreadToStatementContextBridge statementContextProvider) {
        super(false);
        this.nodeManager = nodeManager;
        this.statementContextProvider = statementContextProvider;
    }

    @Override
    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.nodeManager.getGraphDbService();
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return 0;
    }

    @Override
    protected boolean hasLoadedProperties() {
        return this.properties != null;
    }

    @Override
    protected Iterator<DefinedProperty> loadProperties(NodeManager nodeManager) {
        return nodeManager.loadGraphProperties(false);
    }

    @Override
    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        try (Statement statement = this.statementContextProvider.statement();){
            int propertyId = statement.readOperations().propertyKeyGetForName(key);
            boolean bl = statement.readOperations().graphGetProperty(propertyId).isDefined();
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getProperty(String key) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (Statement statement = this.statementContextProvider.statement();){
            int propertyId = statement.readOperations().propertyKeyGetForName(key);
            if (propertyId == -1) {
                Boolean bl = false;
                return bl;
            }
            Object object = statement.readOperations().graphGetProperty(propertyId).value();
            return object;
        }
        catch (PropertyNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (Statement statement = this.statementContextProvider.statement();){
            int propertyId = statement.readOperations().propertyKeyGetForName(key);
            if (propertyId == -1) {
                Boolean bl = false;
                return bl;
            }
            Object object = statement.readOperations().graphGetProperty(propertyId).value(defaultValue);
            return object;
        }
    }

    @Override
    public void setProperty(String key, Object value) {
        boolean success = false;
        try (Statement statement = this.statementContextProvider.statement();){
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            statement.dataWriteOperations().graphSetProperty(Property.property(propertyKeyId, value));
            success = true;
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (ReadOnlyDatabaseKernelException e) {
            throw new ReadOnlyDbException();
        }
        finally {
            if (!success) {
                this.nodeManager.setRollbackOnly();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object removeProperty(String key) {
        try (Statement statement = this.statementContextProvider.statement();){
            int propertyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            Object object = statement.dataWriteOperations().graphRemoveProperty(propertyId).value(null);
            return object;
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (ReadOnlyDatabaseKernelException e) {
            throw new ReadOnlyDbException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<String> getPropertyKeys() {
        try (Statement statement = this.statementContextProvider.statement();){
            ArrayList<String> keys = new ArrayList<String>();
            Iterator<DefinedProperty> properties = statement.readOperations().graphGetAllProperties();
            while (properties.hasNext()) {
                keys.add(statement.readOperations().propertyKeyGetName(properties.next().propertyKeyId()));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new ThisShouldNotHappenError("Jake", "Property key retrieved through kernel API should exist.");
        }
    }

    @Override
    public Iterable<Object> getPropertyValues() {
        try (Statement statement = this.statementContextProvider.statement();){
            Set<Object> set = IteratorUtil.asSet(Iterables.map(new Function<DefinedProperty, Object>(){

                @Override
                public Object apply(DefinedProperty prop) {
                    return prop.value();
                }
            }, statement.readOperations().graphGetAllProperties()));
            return set;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof GraphProperties && ((GraphProperties)obj).getNodeManager().equals(this.nodeManager);
    }

    @Override
    public int hashCode() {
        return this.nodeManager.hashCode();
    }

    @Override
    public long getId() {
        return -1L;
    }

    @Override
    protected void setEmptyProperties() {
        this.properties = new HashMap<Integer, DefinedProperty>();
    }

    @Override
    protected Iterator<DefinedProperty> getCachedProperties() {
        return this.properties.values().iterator();
    }

    @Override
    protected PrimitiveLongIterator getCachedPropertyKeys() {
        return new PropertyKeyIdIterator(this.getCachedProperties());
    }

    @Override
    protected Property getCachedProperty(int key) {
        Property property = this.properties.get(key);
        return property != null ? property : Property.noGraphProperty(key);
    }

    @Override
    protected DefinedProperty getPropertyForIndex(int keyId) {
        DefinedProperty property = this.properties.get(keyId);
        return property != null ? property : null;
    }

    @Override
    protected void setProperties(Iterator<DefinedProperty> loadedProperties) {
        if (loadedProperties != null && loadedProperties.hasNext()) {
            HashMap<Integer, DefinedProperty> newProperties = new HashMap<Integer, DefinedProperty>();
            while (loadedProperties.hasNext()) {
                DefinedProperty property = loadedProperties.next();
                newProperties.put(property.propertyKeyId(), property);
            }
            this.properties = newProperties;
        } else {
            this.properties = new HashMap<Integer, DefinedProperty>();
        }
    }

    @Override
    public WritableTransactionState.CowEntityElement getEntityElement(WritableTransactionState.PrimitiveElement element, boolean create) {
        return element.graphElement(create);
    }

    @Override
    PropertyContainer asProxy(NodeManager nm) {
        return this;
    }

    @Override
    protected void commitPropertyMaps(ArrayMap<Integer, DefinedProperty> cowPropertyAddMap, ArrayMap<Integer, DefinedProperty> cowPropertyRemoveMap, long firstProp) {
        if (cowPropertyAddMap != null) {
            for (Map.Entry<Integer, DefinedProperty> entry : cowPropertyAddMap.entrySet()) {
                this.properties.put(entry.getKey(), Property.property(entry.getKey(), entry.getValue().value()));
            }
        }
        if (cowPropertyRemoveMap != null) {
            for (Map.Entry<Integer, DefinedProperty> entry : cowPropertyRemoveMap.entrySet()) {
                this.properties.remove(entry.getKey());
            }
        }
    }
}

