/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.impl.cache.EntityWithSizeObject;
import org.neo4j.kernel.impl.cache.HitCounter;
import org.neo4j.kernel.impl.cache.ReferenceCache;
import org.neo4j.kernel.impl.cache.WeakReferenceQueue;
import org.neo4j.kernel.impl.cache.WeakValue;

public class WeakLruCache<E extends EntityWithSizeObject>
extends ReferenceCache<E> {
    private final ConcurrentHashMap<Long, WeakValue<Long, E>> cache = new ConcurrentHashMap();
    private final WeakReferenceQueue<Long, E> refQueue = new WeakReferenceQueue();
    private final String name;
    private final HitCounter counter = new HitCounter();

    public WeakLruCache(String name) {
        this.name = name;
    }

    @Override
    public E put(E value) {
        Long key = value.getId();
        WeakValue<Long, E> ref = new WeakValue<Long, E>(key, value, this.refQueue);
        WeakValue<Long, E> previous = this.cache.putIfAbsent(key, ref);
        this.pollClearedValues();
        return (E)(previous != null ? (EntityWithSizeObject)previous.get() : value);
    }

    @Override
    public void putAll(Collection<E> entities) {
        HashMap<Long, WeakValue<Long, EntityWithSizeObject>> softMap = new HashMap<Long, WeakValue<Long, EntityWithSizeObject>>(entities.size() * 2);
        for (EntityWithSizeObject entity : entities) {
            Long key = entity.getId();
            WeakValue<Long, EntityWithSizeObject> ref = new WeakValue<Long, EntityWithSizeObject>(key, entity, this.refQueue);
            softMap.put(key, ref);
        }
        this.cache.putAll(softMap);
        this.pollClearedValues();
    }

    @Override
    public E get(long key) {
        WeakReference ref = this.cache.get(key);
        if (ref != null) {
            if (ref.get() == null) {
                this.cache.remove(key);
            }
            return (E)((EntityWithSizeObject)this.counter.count(ref.get()));
        }
        return (E)((EntityWithSizeObject)this.counter.count(null));
    }

    @Override
    public E remove(long key) {
        WeakReference ref = this.cache.remove(key);
        if (ref != null) {
            return (E)((EntityWithSizeObject)ref.get());
        }
        return null;
    }

    @Override
    protected void pollClearedValues() {
        WeakValue<Long, E> clearedValue = this.refQueue.safePoll();
        while (clearedValue != null) {
            this.cache.remove(clearedValue.key);
            clearedValue = this.refQueue.safePoll();
        }
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public long hitCount() {
        return this.counter.getHitsCount();
    }

    @Override
    public long missCount() {
        return this.counter.getMissCount();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

